/*
 * Decompiled with CFR 0.152.
 */
package org.piwik.java.tracking;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;

class HttpClientFactory {
    private static final Map<KeyEntry, CloseableHttpAsyncClient> ASYNC_INSTANCES = new HashMap<KeyEntry, CloseableHttpAsyncClient>();

    HttpClientFactory() {
    }

    public static HttpClient getInstanceFor(String proxyHost, int proxyPort, int timeout) {
        return HttpClientBuilder.create().setRoutePlanner((HttpRoutePlanner)HttpClientFactory.createRoutePlanner(proxyHost, proxyPort)).setDefaultRequestConfig(HttpClientFactory.createRequestConfig(timeout)).build();
    }

    public static synchronized CloseableHttpAsyncClient getAsyncInstanceFor(String proxyHost, int proxyPort, int timeout) {
        return ASYNC_INSTANCES.computeIfAbsent(new KeyEntry(proxyHost, proxyPort, timeout), key -> HttpAsyncClientBuilder.create().setRoutePlanner((HttpRoutePlanner)HttpClientFactory.createRoutePlanner(((KeyEntry)key).proxyHost, ((KeyEntry)key).proxyPort)).setDefaultRequestConfig(HttpClientFactory.createRequestConfig(((KeyEntry)key).timeout)).build());
    }

    private static DefaultProxyRoutePlanner createRoutePlanner(String proxyHost, int proxyPort) {
        if (proxyHost != null && proxyPort != 0) {
            HttpHost proxy = new HttpHost(proxyHost, proxyPort);
            DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxy);
            return routePlanner;
        }
        return null;
    }

    private static RequestConfig createRequestConfig(int timeout) {
        RequestConfig.Builder config = RequestConfig.custom().setConnectTimeout(timeout).setConnectionRequestTimeout(timeout).setSocketTimeout(timeout);
        return config.build();
    }

    private static final class KeyEntry {
        private final String proxyHost;
        private final int proxyPort;
        private final int timeout;

        public KeyEntry(String proxyHost, int proxyPort, int timeout) {
            this.proxyHost = proxyHost;
            this.proxyPort = proxyPort;
            this.timeout = timeout;
        }

        public int hashCode() {
            return Objects.hash(this.proxyHost, this.proxyPort, this.timeout);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj instanceof KeyEntry) {
                KeyEntry other = (KeyEntry)obj;
                return Objects.equals(this.proxyHost, other.proxyHost) && this.proxyPort == other.proxyPort && this.timeout == other.timeout;
            }
            return false;
        }
    }
}

