/*
 * Decompiled with CFR 0.152.
 */
package org.piwik.java.tracking;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.Future;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.piwik.java.tracking.HttpClientFactory;
import org.piwik.java.tracking.PiwikRequest;

public class PiwikTracker {
    private static final String AUTH_TOKEN = "token_auth";
    private static final String REQUESTS = "requests";
    private static final int DEFAULT_TIMEOUT = 5000;
    private final URIBuilder uriBuilder;
    private final int timeout;
    private final String proxyHost;
    private final int proxyPort;

    public PiwikTracker(String hostUrl) {
        this(hostUrl, 5000);
    }

    public PiwikTracker(String hostUrl, int timeout) {
        this.uriBuilder = new URIBuilder(URI.create(hostUrl));
        this.timeout = timeout;
        this.proxyHost = null;
        this.proxyPort = 0;
    }

    public PiwikTracker(String hostUrl, String proxyHost, int proxyPort) {
        this(hostUrl, proxyHost, proxyPort, 5000);
    }

    public PiwikTracker(String hostUrl, String proxyHost, int proxyPort, int timeout) {
        this.uriBuilder = new URIBuilder(URI.create(hostUrl));
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.timeout = timeout;
    }

    @Deprecated
    public HttpResponse sendRequest(PiwikRequest request) throws IOException {
        HttpClient client = this.getHttpClient();
        this.uriBuilder.setCustomQuery(request.getQueryString());
        HttpGet get = null;
        try {
            get = new HttpGet(this.uriBuilder.build());
            return client.execute((HttpUriRequest)get);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    public Future<HttpResponse> sendRequestAsync(PiwikRequest request) throws IOException {
        return this.sendRequestAsync(request, null);
    }

    public Future<HttpResponse> sendRequestAsync(PiwikRequest request, FutureCallback<HttpResponse> callback) throws IOException {
        CloseableHttpAsyncClient client = this.getHttpAsyncClient();
        client.start();
        this.uriBuilder.setCustomQuery(request.getQueryString());
        HttpGet get = null;
        try {
            get = new HttpGet(this.uriBuilder.build());
            return client.execute((HttpUriRequest)get, callback);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    @Deprecated
    public HttpResponse sendBulkRequest(Iterable<PiwikRequest> requests) throws IOException {
        return this.sendBulkRequest(requests, null);
    }

    public Future<HttpResponse> sendBulkRequestAsync(Iterable<PiwikRequest> requests) throws IOException {
        return this.sendBulkRequestAsync(requests, null, null);
    }

    public Future<HttpResponse> sendBulkRequestAsync(Iterable<PiwikRequest> requests, FutureCallback<HttpResponse> callback) throws IOException {
        return this.sendBulkRequestAsync(requests, null, callback);
    }

    @Deprecated
    public HttpResponse sendBulkRequest(Iterable<PiwikRequest> requests, String authToken) throws IOException {
        if (authToken != null && authToken.length() != 32) {
            throw new IllegalArgumentException(authToken + " is not " + 32 + " characters long.");
        }
        JsonObjectBuilder ob = Json.createObjectBuilder();
        JsonArrayBuilder ab = Json.createArrayBuilder();
        for (PiwikRequest request : requests) {
            ab.add("?" + request.getQueryString());
        }
        ob.add(REQUESTS, ab);
        if (authToken != null) {
            ob.add(AUTH_TOKEN, authToken);
        }
        HttpClient client = this.getHttpClient();
        HttpPost post = null;
        try {
            post = new HttpPost(this.uriBuilder.build());
            post.setEntity((HttpEntity)new StringEntity(ob.build().toString(), ContentType.APPLICATION_JSON));
            return client.execute((HttpUriRequest)post);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    public Future<HttpResponse> sendBulkRequestAsync(Iterable<PiwikRequest> requests, String authToken) throws IOException {
        return this.sendBulkRequestAsync(requests, authToken, null);
    }

    public Future<HttpResponse> sendBulkRequestAsync(Iterable<PiwikRequest> requests, String authToken, FutureCallback<HttpResponse> callback) throws IOException {
        if (authToken != null && authToken.length() != 32) {
            throw new IllegalArgumentException(authToken + " is not " + 32 + " characters long.");
        }
        JsonObjectBuilder ob = Json.createObjectBuilder();
        JsonArrayBuilder ab = Json.createArrayBuilder();
        for (PiwikRequest request : requests) {
            ab.add("?" + request.getQueryString());
        }
        ob.add(REQUESTS, ab);
        if (authToken != null) {
            ob.add(AUTH_TOKEN, authToken);
        }
        CloseableHttpAsyncClient client = this.getHttpAsyncClient();
        client.start();
        HttpPost post = null;
        try {
            post = new HttpPost(this.uriBuilder.build());
            post.setEntity((HttpEntity)new StringEntity(ob.build().toString(), ContentType.APPLICATION_JSON));
            return client.execute((HttpUriRequest)post, callback);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    protected HttpClient getHttpClient() {
        return HttpClientFactory.getInstanceFor(this.proxyHost, this.proxyPort, this.timeout);
    }

    protected CloseableHttpAsyncClient getHttpAsyncClient() {
        return HttpClientFactory.getAsyncInstanceFor(this.proxyHost, this.proxyPort, this.timeout);
    }
}

