/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.core.classloader;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import org.powermock.core.ClassReplicaCreator;
import org.powermock.core.WildcardMatcher;
import org.powermock.core.classloader.ClassPathAdjuster;
import org.powermock.core.classloader.DeferSupportingClassLoader;
import org.powermock.core.classloader.annotations.UseClassPathAdjuster;
import org.powermock.core.spi.PowerMockPolicy;
import org.powermock.core.spi.support.InvocationSubstitute;
import org.powermock.core.transformers.MockTransformer;

public final class MockClassLoader
extends DeferSupportingClassLoader {
    public static final String MODIFY_ALL_CLASSES = "*";
    private static final String CGLIB_ENHANCER = "net.sf.cglib.proxy.Enhancer$EnhancerKey$$KeyFactoryByCGLIB$$";
    private static final String CGLIB_METHOD_WRAPPER = "net.sf.cglib.core.MethodWrapper$MethodWrapperKey$$KeyFactoryByCGLIB";
    private List<MockTransformer> mockTransformerChain;
    private Set<String> modify = Collections.synchronizedSet(new HashSet());
    private final String[] packagesToLoadButNotModify = new String[]{"org.junit.", "junit.", "org.easymock.", "net.sf.cglib.", "javassist.", "org.powermock.modules.junit4.internal.", "org.powermock.modules.junit4.legacy.internal.", "org.powermock.modules.junit3.internal.", "org.powermock"};
    private final String[] specificClassesToLoadButNotModify = new String[]{InvocationSubstitute.class.getName(), PowerMockPolicy.class.getName(), ClassReplicaCreator.class.getName()};
    private static final String[] packagesToBeDeferred = new String[]{"org.hamcrest.*", "java.*", "javax.accessibility.*", "sun.*", "org.junit.*", "junit.*", "org.pitest.*", "org.powermock.modules.junit4.common.internal.*", "org.powermock.modules.junit3.internal.PowerMockJUnit3RunnerDelegate*", "org.powermock.core*", "org.jacoco.agent.rt.*"};
    private ClassPool classPool = new ClassPool();

    public MockClassLoader(String[] classesToMock, String[] packagesToDefer, UseClassPathAdjuster useClassPathAdjuster) {
        super(MockClassLoader.class.getClassLoader(), MockClassLoader.getPackagesToDefer(packagesToDefer));
        this.addClassesToModify(classesToMock);
        this.classPool.appendClassPath((ClassPath)new ClassClassPath(this.getClass()));
        if (useClassPathAdjuster != null) {
            try {
                Class<? extends ClassPathAdjuster> value = useClassPathAdjuster.value();
                ClassPathAdjuster classPathAdjuster = value.newInstance();
                classPathAdjuster.adjustClassPath(this.classPool);
            }
            catch (Exception e) {
                throw new RuntimeException("Error instantiating class path adjuster", e);
            }
        }
    }

    private static String[] getPackagesToDefer(String[] additionalDeferPackages) {
        int additionalIgnorePackagesLength = additionalDeferPackages == null ? 0 : additionalDeferPackages.length;
        int defaultDeferPackagesLength = packagesToBeDeferred.length;
        int allIgnoreLength = defaultDeferPackagesLength + additionalIgnorePackagesLength;
        String[] allPackagesToBeIgnored = new String[allIgnoreLength];
        if (allIgnoreLength > defaultDeferPackagesLength) {
            System.arraycopy(packagesToBeDeferred, 0, allPackagesToBeIgnored, 0, defaultDeferPackagesLength);
            System.arraycopy(additionalDeferPackages, 0, allPackagesToBeIgnored, defaultDeferPackagesLength, additionalIgnorePackagesLength);
            return allPackagesToBeIgnored;
        }
        return packagesToBeDeferred;
    }

    public MockClassLoader(String[] classesToMock, String[] packagesToDefer) {
        this(classesToMock, packagesToDefer, null);
    }

    public MockClassLoader(String[] classesToMock, UseClassPathAdjuster useClassPathAdjuster) {
        this(classesToMock, new String[0], useClassPathAdjuster);
    }

    public MockClassLoader(String[] classesToMock) {
        this(classesToMock, new String[0], null);
    }

    public void addClassesToModify(String ... classes) {
        if (classes != null) {
            for (String clazz : classes) {
                if (this.shouldDefer(packagesToBeDeferred, clazz)) continue;
                this.modify.add(clazz);
            }
        }
    }

    @Override
    protected Class<?> loadModifiedClass(String s) throws ClassFormatError, ClassNotFoundException {
        Class<?> loadedClass = null;
        this.deferTo.loadClass(s);
        loadedClass = this.shouldModify(s) && !this.shouldLoadModified(s) ? this.loadMockClass(s) : this.loadUnmockedClass(s);
        return loadedClass;
    }

    private boolean shouldModify(String className) {
        boolean shouldIgnoreClass = this.shouldIgnore(this.deferPackages, className);
        boolean shouldModifyAll = this.shouldModifyAll();
        if (shouldModifyAll) {
            return !shouldIgnoreClass;
        }
        return WildcardMatcher.matchesAny(this.modify, className);
    }

    public boolean shouldModifyAll() {
        return this.modify.size() == 1 && this.modify.iterator().next().equals(MODIFY_ALL_CLASSES);
    }

    private Class<?> loadUnmockedClass(String name) throws ClassFormatError, ClassNotFoundException {
        byte[] bytes = null;
        try {
            if (!name.startsWith(CGLIB_ENHANCER) && !name.startsWith(CGLIB_METHOD_WRAPPER)) {
                CtClass ctClass = this.classPool.get(name);
                if (ctClass.isFrozen()) {
                    ctClass.defrost();
                }
                bytes = ctClass.toBytecode();
            }
        }
        catch (Exception e) {
            if (e instanceof NotFoundException) {
                throw new ClassNotFoundException();
            }
            throw new RuntimeException(e);
        }
        return bytes == null ? null : this.defineClass(name, bytes, 0, bytes.length);
    }

    private Class<?> loadMockClass(String name) {
        CtClass type = null;
        byte[] clazz = null;
        ClassPool.doPruning = false;
        try {
            type = this.classPool.get(name);
            for (MockTransformer transformer : this.mockTransformerChain) {
                type = transformer.transform(type);
            }
            type.detach();
            clazz = type.toBytecode();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to transform class with name " + name + ". Reason: " + e.getMessage(), e);
        }
        return this.defineClass(name, clazz, 0, clazz.length);
    }

    public void setMockTransformerChain(List<MockTransformer> mockTransformerChain) {
        this.mockTransformerChain = mockTransformerChain;
    }

    @Override
    protected boolean shouldModifyClass(String s) {
        return this.modify.contains(s);
    }

    @Override
    protected boolean shouldLoadUnmodifiedClass(String className) {
        for (String classNameToLoadButNotModify : this.specificClassesToLoadButNotModify) {
            if (!className.equals(classNameToLoadButNotModify)) continue;
            return true;
        }
        return false;
    }

    private boolean shouldLoadModified(String className) {
        if (className.startsWith("org.powermock.example")) {
            return false;
        }
        for (String packageToLoadButNotModify : this.packagesToLoadButNotModify) {
            if (!className.startsWith(packageToLoadButNotModify)) continue;
            return true;
        }
        return false;
    }
}

