/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.tests.utils.impl;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Set;
import org.powermock.core.IndicateReloadClass;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.core.classloader.annotations.PrepareOnlyThisForTest;
import org.powermock.tests.utils.impl.AbstractTestClassExtractor;

public class PrepareForTestExtractorImpl
extends AbstractTestClassExtractor {
    @Override
    protected String[] getClassesToModify(AnnotatedElement element) {
        Class<?>[] classesToMock;
        boolean prepareOnlyThisForTestAnnotationPresent;
        LinkedHashSet<String> all = new LinkedHashSet<String>();
        this.addTestCase(all, element);
        PrepareForTest prepareForTestAnnotation = element.getAnnotation(PrepareForTest.class);
        PrepareOnlyThisForTest prepareOnlyThisForTestAnnotation = element.getAnnotation(PrepareOnlyThisForTest.class);
        boolean prepareForTestAnnotationPresent = prepareForTestAnnotation != null;
        boolean bl = prepareOnlyThisForTestAnnotationPresent = prepareOnlyThisForTestAnnotation != null;
        if (!prepareForTestAnnotationPresent && !prepareOnlyThisForTestAnnotationPresent) {
            return null;
        }
        if (prepareForTestAnnotationPresent) {
            for (Class<?> classToMock : classesToMock = prepareForTestAnnotation.value()) {
                if (classToMock.equals(IndicateReloadClass.class)) continue;
                this.addClassHierarchy(all, classToMock);
            }
            this.addFullyQualifiedNames(all, prepareForTestAnnotation);
        }
        if (prepareOnlyThisForTestAnnotationPresent) {
            for (Class<?> classToMock : classesToMock = prepareOnlyThisForTestAnnotation.value()) {
                if (classToMock.equals(IndicateReloadClass.class)) continue;
                all.add(classToMock.getName());
            }
            this.addFullyQualifiedNames(all, prepareOnlyThisForTestAnnotation);
        }
        return all.toArray(new String[0]);
    }

    private void addTestCase(Set<String> all, AnnotatedElement element) {
        Class<?> testClass = null;
        if (element instanceof Class) {
            testClass = (Class<?>)element;
        } else if (element instanceof Method) {
            testClass = ((Method)element).getDeclaringClass();
        }
        this.addClassHierarchy(all, testClass);
    }

    private void addFullyQualifiedNames(Set<String> all, PrepareForTest annotation) {
        String[] fullyQualifiedNames = annotation.fullyQualifiedNames();
        this.addFullyQualifiedNames(all, fullyQualifiedNames);
    }

    private void addFullyQualifiedNames(Set<String> all, PrepareOnlyThisForTest annotation) {
        String[] fullyQualifiedNames = annotation.fullyQualifiedNames();
        this.addFullyQualifiedNames(all, fullyQualifiedNames);
    }

    private void addFullyQualifiedNames(Set<String> all, String[] fullyQualifiedNames) {
        for (String string : fullyQualifiedNames) {
            if ("".equals(string)) continue;
            all.add(string);
        }
    }

    private void addClassHierarchy(Set<String> all, Class<?> classToMock) {
        while (classToMock != null && !classToMock.equals(Object.class)) {
            this.addInnerClassesAndInterfaces(all, classToMock);
            all.add(classToMock.getName());
            classToMock = classToMock.getSuperclass();
        }
    }

    private void addInnerClassesAndInterfaces(Set<String> all, Class<?> classToMock) {
        Class<?>[] declaredClasses;
        for (Class<?> innerClass : declaredClasses = classToMock.getDeclaredClasses()) {
            all.add(innerClass.getName());
        }
    }
}

