/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.configuration.support;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.powermock.configuration.Configuration;
import org.powermock.configuration.ConfigurationReader;
import org.powermock.configuration.support.ConfigurationMapper;
import org.powermock.configuration.support.PropertiesLoader;
import org.powermock.configuration.support.ValueAliases;
import org.powermock.core.PowerMockInternalException;

public class ConfigurationReaderBuilder {
    private final Map<String, String> alias = new HashMap<String, String>();
    private String configurationFile;

    public static ConfigurationReaderBuilder newBuilder() {
        return new ConfigurationReaderBuilder();
    }

    private ConfigurationReaderBuilder() {
    }

    public ConfigurationReaderBuilder forConfigurationFile(String configurationFile) {
        this.configurationFile = configurationFile;
        return this;
    }

    public ConfigurationReaderBuilder withValueAlias(String alias, String value) {
        this.alias.put(alias, value);
        return this;
    }

    public ConfigurationReader build() {
        return new ConfigurationReaderImpl(this.configurationFile, this.alias);
    }

    private static class ConfigurationReaderImpl
    implements ConfigurationReader {
        private final String configurationFile;
        private final ValueAliases alias;

        private ConfigurationReaderImpl(String configurationFile, Map<String, String> alias) {
            this.configurationFile = configurationFile;
            this.alias = new ValueAliases(alias);
        }

        @Override
        public <T extends Configuration> T read(Class<T> configurationClass) {
            Properties properties = new PropertiesLoader().load(this.configurationFile);
            if (properties != null) {
                return this.createConfiguration(configurationClass, properties);
            }
            return null;
        }

        private <T extends Configuration> T createConfiguration(Class<T> configurationClass, Properties properties) {
            try {
                Configuration configuration = (Configuration)configurationClass.newInstance();
                this.mapConfiguration(configurationClass, configuration, properties);
                return (T)configuration;
            }
            catch (Exception e) {
                throw new PowerMockInternalException(e);
            }
        }

        private <T extends Configuration> void mapConfiguration(Class<T> configurationClass, T configuration, Properties properties) {
            new ConfigurationMapper<T>(configurationClass, configuration, this.alias).map(properties);
        }
    }
}

