/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.reflect.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.objenesis.ObjenesisStd;
import org.objenesis.instantiator.ObjectInstantiator;
import org.powermock.reflect.exceptions.ConstructorNotFoundException;
import org.powermock.reflect.exceptions.FieldNotFoundException;
import org.powermock.reflect.exceptions.MethodInvocationException;
import org.powermock.reflect.exceptions.MethodNotFoundException;
import org.powermock.reflect.exceptions.TooManyConstructorsFoundException;
import org.powermock.reflect.exceptions.TooManyFieldsFoundException;
import org.powermock.reflect.exceptions.TooManyMethodsFoundException;
import org.powermock.reflect.internal.CandidateConstructorSearcher;
import org.powermock.reflect.internal.ConstructorFinder;
import org.powermock.reflect.internal.ParameterTypesMatcher;
import org.powermock.reflect.internal.TypeUtils;
import org.powermock.reflect.internal.comparator.ComparatorFactory;
import org.powermock.reflect.internal.matcherstrategies.AllFieldsMatcherStrategy;
import org.powermock.reflect.internal.matcherstrategies.AssignableFromFieldTypeMatcherStrategy;
import org.powermock.reflect.internal.matcherstrategies.AssignableToFieldTypeMatcherStrategy;
import org.powermock.reflect.internal.matcherstrategies.FieldAnnotationMatcherStrategy;
import org.powermock.reflect.internal.matcherstrategies.FieldMatcherStrategy;
import org.powermock.reflect.internal.matcherstrategies.FieldNameMatcherStrategy;
import org.powermock.reflect.internal.primitivesupport.BoxedWrapper;
import org.powermock.reflect.internal.primitivesupport.PrimitiveWrapper;
import org.powermock.reflect.internal.proxy.ProxyFrameworks;
import org.powermock.reflect.internal.proxy.UnproxiedType;
import org.powermock.reflect.matching.FieldMatchingStrategy;
import sun.misc.Unsafe;

public class WhiteboxImpl {
    private static ProxyFrameworks proxyFrameworks = new ProxyFrameworks();
    private static ConcurrentMap<Class, Method[]> allClassMethodsCache = new ConcurrentHashMap<Class, Method[]>();

    public static Method getMethod(Class<?> type, Class<?> ... parameterTypes) {
        Class<?> thisType = type;
        if (parameterTypes == null) {
            parameterTypes = new Class[]{};
        }
        LinkedList<Method> foundMethods = new LinkedList<Method>();
        while (thisType != null) {
            Method[] methodsToTraverse = null;
            methodsToTraverse = thisType.isInterface() ? WhiteboxImpl.getAllPublicMethods(thisType) : thisType.getDeclaredMethods();
            for (Method method : methodsToTraverse) {
                if (!WhiteboxImpl.checkIfParameterTypesAreSame(method.isVarArgs(), parameterTypes, method.getParameterTypes())) continue;
                foundMethods.add(method);
                if (foundMethods.size() != 1) continue;
                method.setAccessible(true);
            }
            if (foundMethods.size() == 1) {
                return (Method)foundMethods.get(0);
            }
            if (foundMethods.size() > 1) break;
            thisType = thisType.getSuperclass();
        }
        if (foundMethods.isEmpty()) {
            throw new MethodNotFoundException("No method was found with parameter types: [ " + WhiteboxImpl.getArgumentTypesAsString(parameterTypes) + " ] in class " + WhiteboxImpl.getOriginalUnmockedType(type).getName() + ".");
        }
        WhiteboxImpl.throwExceptionWhenMultipleMethodMatchesFound("method name", foundMethods.toArray(new Method[foundMethods.size()]));
        return null;
    }

    public static Method getMethod(Class<?> type, String methodName, Class<?> ... parameterTypes) {
        Class<?> thisType = type;
        if (parameterTypes == null) {
            parameterTypes = new Class[]{};
        }
        while (thisType != null) {
            Method[] methodsToTraverse = null;
            methodsToTraverse = thisType.isInterface() ? WhiteboxImpl.getAllPublicMethods(thisType) : thisType.getDeclaredMethods();
            for (Method method : methodsToTraverse) {
                if (!methodName.equals(method.getName()) || !WhiteboxImpl.checkIfParameterTypesAreSame(method.isVarArgs(), parameterTypes, method.getParameterTypes())) continue;
                method.setAccessible(true);
                return method;
            }
            thisType = thisType.getSuperclass();
        }
        WhiteboxImpl.throwExceptionIfMethodWasNotFound(type, methodName, null, new Object[]{parameterTypes});
        return null;
    }

    public static Field getField(Class<?> type, String fieldName) {
        LinkedList<Class<Object>> examine = new LinkedList<Class<Object>>();
        examine.add(type);
        HashSet<Class> done = new HashSet<Class>();
        while (!examine.isEmpty()) {
            Field[] declaredField;
            Class thisType = (Class)examine.removeFirst();
            done.add(thisType);
            for (Field field : declaredField = thisType.getDeclaredFields()) {
                if (!fieldName.equals(field.getName())) continue;
                field.setAccessible(true);
                return field;
            }
            HashSet potential = new HashSet();
            Class clazz = thisType.getSuperclass();
            if (clazz != null) {
                potential.add(thisType.getSuperclass());
            }
            potential.addAll(Arrays.asList(thisType.getInterfaces()));
            potential.removeAll(done);
            examine.addAll(potential);
        }
        WhiteboxImpl.throwExceptionIfFieldWasNotFound(type, fieldName, null);
        return null;
    }

    public static <T> T newInstance(Class<T> classToInstantiate) {
        Object object;
        int modifiers = classToInstantiate.getModifiers();
        if (Modifier.isInterface(modifiers)) {
            object = Proxy.newProxyInstance(WhiteboxImpl.class.getClassLoader(), new Class[]{classToInstantiate}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    return TypeUtils.getDefaultValue(method.getReturnType());
                }
            });
        } else if (classToInstantiate.isArray()) {
            object = Array.newInstance(classToInstantiate.getComponentType(), 0);
        } else {
            if (Modifier.isAbstract(modifiers)) {
                throw new IllegalArgumentException("Cannot instantiate an abstract class. Please use the ConcreteClassGenerator in PowerMock support to generate a concrete class first.");
            }
            ObjenesisStd objenesis = new ObjenesisStd();
            ObjectInstantiator thingyInstantiator = objenesis.getInstantiatorOf(classToInstantiate);
            object = thingyInstantiator.newInstance();
        }
        return (T)object;
    }

    public static Constructor<?> getConstructor(Class<?> type, Class<?> ... parameterTypes) {
        Class<?> unmockedType = WhiteboxImpl.getOriginalUnmockedType(type);
        try {
            Constructor<?> constructor = unmockedType.getDeclaredConstructor(parameterTypes);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ConstructorNotFoundException(String.format("Failed to lookup constructor with parameter types [ %s ] in class %s.", WhiteboxImpl.getArgumentTypesAsString(parameterTypes), unmockedType.getName()), e);
        }
    }

    public static void setInternalState(Object object, String fieldName, Object value) {
        Field foundField = WhiteboxImpl.findFieldInHierarchy(object, fieldName);
        WhiteboxImpl.setField(object, value, foundField);
    }

    public static void setInternalState(Object object, String fieldName, Object[] value) {
        WhiteboxImpl.setInternalState(object, fieldName, (Object)value);
    }

    public static void setInternalState(Object object, Class<?> fieldType, Object value) {
        WhiteboxImpl.setField(object, value, WhiteboxImpl.findFieldInHierarchy(object, new AssignableFromFieldTypeMatcherStrategy(fieldType)));
    }

    public static void setInternalState(Object object, Object value, Object ... additionalValues) {
        WhiteboxImpl.setField(object, value, WhiteboxImpl.findFieldInHierarchy(object, new AssignableFromFieldTypeMatcherStrategy(WhiteboxImpl.getType(value))));
        if (additionalValues != null && additionalValues.length > 0) {
            for (Object additionalValue : additionalValues) {
                WhiteboxImpl.setField(object, additionalValue, WhiteboxImpl.findFieldInHierarchy(object, new AssignableFromFieldTypeMatcherStrategy(WhiteboxImpl.getType(additionalValue))));
            }
        }
    }

    public static void setInternalState(Object object, Object value, Class<?> where) {
        WhiteboxImpl.setField(object, value, WhiteboxImpl.findField(object, new AssignableFromFieldTypeMatcherStrategy(WhiteboxImpl.getType(value)), where));
    }

    public static void setInternalState(Object object, Class<?> fieldType, Object value, Class<?> where) {
        if (fieldType == null || where == null) {
            throw new IllegalArgumentException("fieldType and where cannot be null");
        }
        WhiteboxImpl.setField(object, value, WhiteboxImpl.findFieldOrThrowException(fieldType, where));
    }

    public static void setInternalState(Object object, String fieldName, Object value, Class<?> where) {
        if (object == null || fieldName == null || fieldName.equals("") || fieldName.startsWith(" ")) {
            throw new IllegalArgumentException("object, field name, and \"where\" must not be empty or null.");
        }
        Field field = WhiteboxImpl.getField(fieldName, where);
        try {
            field.set(object, value);
        }
        catch (Exception e) {
            throw new RuntimeException("Internal Error: Failed to set field in method setInternalState.", e);
        }
    }

    public static <T> T getInternalState(Object object, String fieldName) {
        Field foundField = WhiteboxImpl.findFieldInHierarchy(object, fieldName);
        try {
            return (T)foundField.get(object);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Internal error: Failed to get field in method getInternalState.", e);
        }
    }

    private static Field findFieldInHierarchy(Object object, String fieldName) {
        return WhiteboxImpl.findFieldInHierarchy(object, new FieldNameMatcherStrategy(fieldName));
    }

    private static Field findFieldInHierarchy(Object object, FieldMatcherStrategy strategy) {
        WhiteboxImpl.assertObjectInGetInternalStateIsNotNull(object);
        return WhiteboxImpl.findSingleFieldUsingStrategy(strategy, object, true, WhiteboxImpl.getType(object));
    }

    private static Field findField(Object object, FieldMatcherStrategy strategy, Class<?> where) {
        return WhiteboxImpl.findSingleFieldUsingStrategy(strategy, object, false, where);
    }

    private static Field findSingleFieldUsingStrategy(FieldMatcherStrategy strategy, Object object, boolean checkHierarchy, Class<?> startClass) {
        WhiteboxImpl.assertObjectInGetInternalStateIsNotNull(object);
        Field foundField = null;
        Class<?> originalStartClass = startClass;
        while (startClass != null) {
            Field[] declaredFields;
            for (Field field : declaredFields = startClass.getDeclaredFields()) {
                if (!strategy.matches(field) || !WhiteboxImpl.hasFieldProperModifier(object, field, false)) continue;
                if (foundField != null) {
                    throw new TooManyFieldsFoundException("Two or more fields matching " + strategy + ".");
                }
                foundField = field;
            }
            if (foundField != null || !checkHierarchy) break;
            startClass = startClass.getSuperclass();
        }
        if (foundField == null) {
            strategy.notFound(originalStartClass, !WhiteboxImpl.isClass(object));
        }
        foundField.setAccessible(true);
        return foundField;
    }

    private static Set<Field> findAllFieldsUsingStrategy(FieldMatcherStrategy strategy, Object object, boolean checkHierarchy, boolean onlyInstanceFields, Class<?> startClass) {
        WhiteboxImpl.assertObjectInGetInternalStateIsNotNull(object);
        LinkedHashSet<Field> foundFields = new LinkedHashSet<Field>();
        while (startClass != null) {
            Field[] declaredFields;
            for (Field field : declaredFields = startClass.getDeclaredFields()) {
                if (!strategy.matches(field) || !WhiteboxImpl.hasFieldProperModifier(object, field, onlyInstanceFields)) continue;
                try {
                    field.setAccessible(true);
                    foundFields.add(field);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!checkHierarchy) break;
            startClass = startClass.getSuperclass();
        }
        return Collections.unmodifiableSet(foundFields);
    }

    private static boolean hasFieldProperModifier(Object object, Field field, boolean onlyInstanceFields) {
        if (onlyInstanceFields) {
            return !Modifier.isStatic(field.getModifiers());
        }
        if (object instanceof Class) {
            return Modifier.isStatic(field.getModifiers());
        }
        return !Modifier.isStatic(field.getModifiers());
    }

    public static <T> T getInternalState(Object object, Class<T> fieldType) {
        Field foundField = WhiteboxImpl.findFieldInHierarchy(object, new AssignableToFieldTypeMatcherStrategy(fieldType));
        try {
            return (T)foundField.get(object);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Internal error: Failed to get field in method getInternalState.", e);
        }
    }

    public static <T> T getInternalState(Object object, Class<T> fieldType, Class<?> where) {
        if (object == null) {
            throw new IllegalArgumentException("object and type are not allowed to be null");
        }
        try {
            return (T)WhiteboxImpl.findFieldOrThrowException(fieldType, where).get(object);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Internal error: Failed to get field in method getInternalState.", e);
        }
    }

    public static <T> T getInternalState(Object object, String fieldName, Class<?> where) {
        if (object == null || fieldName == null || fieldName.equals("") || fieldName.startsWith(" ")) {
            throw new IllegalArgumentException("object, field name, and \"where\" must not be empty or null.");
        }
        Field field = null;
        try {
            field = where.getDeclaredField(fieldName);
            field.setAccessible(true);
            return (T)field.get(object);
        }
        catch (NoSuchFieldException e) {
            throw new FieldNotFoundException("Field '" + fieldName + "' was not found in class " + where.getName() + ".");
        }
        catch (Exception e) {
            throw new RuntimeException("Internal error: Failed to get field in method getInternalState.", e);
        }
    }

    public static synchronized <T> T invokeMethod(Object tested, Object ... arguments) throws Exception {
        return WhiteboxImpl.doInvokeMethod(tested, null, null, arguments);
    }

    public static synchronized <T> T invokeMethod(Class<?> tested, Object ... arguments) throws Exception {
        return WhiteboxImpl.doInvokeMethod(tested, null, null, arguments);
    }

    public static synchronized <T> T invokeMethod(Object tested, String methodToExecute, Object ... arguments) throws Exception {
        return WhiteboxImpl.doInvokeMethod(tested, null, methodToExecute, arguments);
    }

    public static synchronized <T> T invokeMethod(Object tested, String methodToExecute, Class<?>[] argumentTypes, Object ... arguments) throws Exception {
        Class<?> unmockedType = WhiteboxImpl.getType(tested);
        Method method = WhiteboxImpl.getMethod(unmockedType, methodToExecute, argumentTypes);
        if (method == null) {
            WhiteboxImpl.throwExceptionIfMethodWasNotFound(unmockedType, methodToExecute, null, arguments);
        }
        return WhiteboxImpl.performMethodInvocation(tested, method, arguments);
    }

    public static synchronized <T> T invokeMethod(Object tested, String methodToExecute, Class<?> definedIn, Class<?>[] argumentTypes, Object ... arguments) throws Exception {
        Method method = WhiteboxImpl.getMethod(definedIn, methodToExecute, argumentTypes);
        if (method == null) {
            WhiteboxImpl.throwExceptionIfMethodWasNotFound(definedIn, methodToExecute, null, arguments);
        }
        return WhiteboxImpl.performMethodInvocation(tested, method, arguments);
    }

    public static synchronized <T> T invokeMethod(Object tested, Class<?> declaringClass, String methodToExecute, Object ... arguments) throws Exception {
        return WhiteboxImpl.doInvokeMethod(tested, declaringClass, methodToExecute, arguments);
    }

    public static synchronized <T> T invokeMethod(Object object, Class<?> declaringClass, String methodToExecute, Class<?>[] parameterTypes, Object ... arguments) throws Exception {
        if (object == null) {
            throw new IllegalArgumentException("object cannot be null");
        }
        Method methodToInvoke = WhiteboxImpl.getMethod(declaringClass, methodToExecute, parameterTypes);
        return WhiteboxImpl.performMethodInvocation(object, methodToInvoke, arguments);
    }

    public static synchronized <T> T invokeMethod(Class<?> clazz, String methodToExecute, Object ... arguments) throws Exception {
        return WhiteboxImpl.doInvokeMethod(clazz, null, methodToExecute, arguments);
    }

    private static <T> T doInvokeMethod(Object tested, Class<?> declaringClass, String methodToExecute, Object ... arguments) throws Exception {
        Method methodToInvoke = WhiteboxImpl.findMethodOrThrowException(tested, declaringClass, methodToExecute, arguments);
        return WhiteboxImpl.performMethodInvocation(tested, methodToInvoke, arguments);
    }

    public static Method findMethodOrThrowException(Object tested, Class<?> declaringClass, String methodToExecute, Object[] arguments) {
        if (tested == null) {
            throw new IllegalArgumentException("The object to perform the operation on cannot be null.");
        }
        Class<?> testedType = null;
        testedType = WhiteboxImpl.isClass(tested) ? (Class<?>)tested : tested.getClass();
        Method[] methods = null;
        methods = declaringClass == null ? WhiteboxImpl.getAllMethods(testedType) : declaringClass.getDeclaredMethods();
        Method potentialMethodToInvoke = null;
        for (Method method : methods) {
            if (methodToExecute != null && !method.getName().equals(methodToExecute)) continue;
            Class<?>[] paramTypes = method.getParameterTypes();
            if (arguments != null && paramTypes.length == arguments.length) {
                if (paramTypes.length == 0) {
                    potentialMethodToInvoke = method;
                    break;
                }
                boolean methodFound = WhiteboxImpl.checkArgumentTypesMatchParameterTypes(method.isVarArgs(), paramTypes, arguments);
                if (!methodFound) continue;
                if (potentialMethodToInvoke == null) {
                    potentialMethodToInvoke = method;
                    continue;
                }
                if (potentialMethodToInvoke.getName().equals(method.getName())) {
                    if (WhiteboxImpl.areAllArgumentsOfSameType(arguments) && potentialMethodToInvoke.getDeclaringClass() != method.getDeclaringClass()) {
                        return potentialMethodToInvoke;
                    }
                    return WhiteboxImpl.getBestMethodCandidate(WhiteboxImpl.getType(tested), method.getName(), WhiteboxImpl.getTypes(arguments), false);
                }
                Method bestCandidateMethod = WhiteboxImpl.getMethodWithMostSpecificParameterTypes(method, potentialMethodToInvoke);
                if (bestCandidateMethod != null) {
                    potentialMethodToInvoke = bestCandidateMethod;
                    continue;
                }
                WhiteboxImpl.throwExceptionWhenMultipleMethodMatchesFound("argument parameter types", new Method[]{potentialMethodToInvoke, method});
                continue;
            }
            if (WhiteboxImpl.isPotentialVarArgsMethod(method, arguments)) {
                if (potentialMethodToInvoke == null) {
                    potentialMethodToInvoke = method;
                    break;
                }
                WhiteboxImpl.throwExceptionWhenMultipleMethodMatchesFound("argument parameter types", new Method[]{potentialMethodToInvoke, method});
                break;
            }
            if (arguments != null && paramTypes.length != arguments.length || arguments != null || paramTypes.length != 1 || paramTypes[0].isPrimitive()) continue;
            potentialMethodToInvoke = method;
        }
        WhiteboxImpl.throwExceptionIfMethodWasNotFound(WhiteboxImpl.getType(tested), methodToExecute, potentialMethodToInvoke, arguments);
        return potentialMethodToInvoke;
    }

    private static Method getMethodWithMostSpecificParameterTypes(Method firstMethodCandidate, Method secondMethodCandidate) {
        Class<?>[] firstMethodCandidateParameterTypes = firstMethodCandidate.getParameterTypes();
        Class<?>[] secondMethodCandidateParameterTypes = secondMethodCandidate.getParameterTypes();
        Method bestMatch = null;
        for (int i = 0; i < firstMethodCandidateParameterTypes.length; ++i) {
            Class<?> candidateType2;
            Class<?> candidateType1 = WhiteboxImpl.toBoxedIfPrimitive(firstMethodCandidateParameterTypes[i]);
            if (candidateType1.equals(candidateType2 = WhiteboxImpl.toBoxedIfPrimitive(secondMethodCandidateParameterTypes[i]))) continue;
            Method potentialMatch = null;
            if (candidateType1.isAssignableFrom(candidateType2)) {
                potentialMatch = secondMethodCandidate;
            } else if (candidateType2.isAssignableFrom(candidateType1)) {
                potentialMatch = firstMethodCandidate;
            }
            if (potentialMatch == null) continue;
            if (bestMatch != null && !potentialMatch.equals(bestMatch)) {
                return null;
            }
            bestMatch = potentialMatch;
        }
        return bestMatch;
    }

    private static Class<?> toBoxedIfPrimitive(Class<?> type) {
        return type.isPrimitive() ? BoxedWrapper.getBoxedFromPrimitiveType(type) : type;
    }

    private static Class<?>[] getTypes(Object[] arguments) {
        Class[] classes = new Class[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            classes[i] = WhiteboxImpl.getType(arguments[i]);
        }
        return classes;
    }

    public static Method getBestMethodCandidate(Class<?> cls, String methodName, Class<?>[] signature, boolean exactParameterTypeMatch) {
        Method foundMethod;
        Method[] methods = WhiteboxImpl.getMethods(cls, methodName, signature, exactParameterTypeMatch);
        if (methods.length == 1) {
            foundMethod = methods[0];
        } else {
            Arrays.sort(methods, ComparatorFactory.createMethodComparator());
            foundMethod = methods[0];
        }
        return foundMethod;
    }

    public static Constructor<?> findDefaultConstructorOrThrowException(Class<?> type) throws ConstructorNotFoundException {
        Constructor<?> declaredConstructor;
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        try {
            declaredConstructor = type.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new ConstructorNotFoundException(String.format("Couldn't find a default constructor in %s.", type.getName()));
        }
        return declaredConstructor;
    }

    public static Constructor<?> findConstructorOrThrowException(Class<?> type) {
        Constructor<?>[] declaredConstructors = WhiteboxImpl.filterPowerMockConstructor(type.getDeclaredConstructors());
        if (declaredConstructors.length > 1) {
            WhiteboxImpl.throwExceptionWhenMultipleConstructorMatchesFound(declaredConstructors);
        }
        return declaredConstructors[0];
    }

    static Constructor<?>[] filterPowerMockConstructor(Constructor<?>[] declaredConstructors) {
        HashSet constructors = new HashSet();
        for (Constructor<?> constructor : declaredConstructors) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (parameterTypes.length >= 1 && parameterTypes[parameterTypes.length - 1].getName().equals("org.powermock.core.IndicateReloadClass")) continue;
            constructors.add(constructor);
        }
        return constructors.toArray(new Constructor[constructors.size()]);
    }

    public static Constructor<?> findUniqueConstructorOrThrowException(Class<?> type, Object ... arguments) {
        return new ConstructorFinder(type, arguments).findConstructor();
    }

    private static Class<?>[] convertArgumentTypesToPrimitive(Class<?>[] paramTypes, Object[] arguments) {
        Class[] types = new Class[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            Class<?> argumentType = null;
            argumentType = arguments[i] == null ? paramTypes[i] : WhiteboxImpl.getType(arguments[i]);
            Class<?> primitiveWrapperType = PrimitiveWrapper.getPrimitiveFromWrapperType(argumentType);
            types[i] = primitiveWrapperType == null ? argumentType : primitiveWrapperType;
        }
        return types;
    }

    public static void throwExceptionIfMethodWasNotFound(Class<?> type, String methodName, Method methodToMock, Object ... arguments) {
        if (methodToMock == null) {
            String methodNameData = "";
            if (methodName != null) {
                methodNameData = "with name '" + methodName + "' ";
            }
            throw new MethodNotFoundException("No method found " + methodNameData + "with parameter types: [ " + WhiteboxImpl.getArgumentTypesAsString(arguments) + " ] in class " + WhiteboxImpl.getOriginalUnmockedType(type).getName() + ".");
        }
    }

    public static void throwExceptionIfFieldWasNotFound(Class<?> type, String fieldName, Field field) {
        if (field == null) {
            throw new FieldNotFoundException("No field was found with name '" + fieldName + "' in class " + WhiteboxImpl.getOriginalUnmockedType(type).getName() + ".");
        }
    }

    static void throwExceptionIfConstructorWasNotFound(Class<?> type, Constructor<?> potentialConstructor, Object ... arguments) {
        if (potentialConstructor == null) {
            String message = "No constructor found in class '" + WhiteboxImpl.getOriginalUnmockedType(type).getName() + "' with parameter types: [ " + WhiteboxImpl.getArgumentTypesAsString(arguments) + " ].";
            throw new ConstructorNotFoundException(message);
        }
    }

    static String getArgumentTypesAsString(Object ... arguments) {
        StringBuilder argumentsAsString = new StringBuilder();
        String noParameters = "<none>";
        if (arguments != null && arguments.length != 0) {
            for (int i = 0; i < arguments.length; ++i) {
                String argumentName = null;
                Object argument = arguments[i];
                if (argument instanceof Class) {
                    argumentName = ((Class)argument).getName();
                } else if (argument instanceof Class[] && arguments.length == 1) {
                    Object[] argumentArray = (Class[])argument;
                    if (argumentArray.length > 0) {
                        for (int j = 0; j < argumentArray.length; ++j) {
                            WhiteboxImpl.appendArgument(argumentsAsString, j, argumentArray[j] == null ? "null" : WhiteboxImpl.getUnproxyType(argumentArray[j]).getName(), argumentArray);
                        }
                        return argumentsAsString.toString();
                    }
                    argumentName = "<none>";
                } else {
                    argumentName = argument == null ? "null" : WhiteboxImpl.getUnproxyType(argument).getName();
                }
                WhiteboxImpl.appendArgument(argumentsAsString, i, argumentName, arguments);
            }
        } else {
            argumentsAsString.append("<none>");
        }
        return argumentsAsString.toString();
    }

    private static void appendArgument(StringBuilder argumentsAsString, int index, String argumentName, Object[] arguments) {
        argumentsAsString.append(argumentName);
        if (index != arguments.length - 1) {
            argumentsAsString.append(", ");
        }
    }

    public static <T> T invokeConstructor(Class<T> classThatContainsTheConstructorToTest, Class<?>[] parameterTypes, Object[] arguments) throws Exception {
        if (parameterTypes != null && arguments != null && parameterTypes.length != arguments.length) {
            throw new IllegalArgumentException("parameterTypes and arguments must have the same length");
        }
        Constructor<T> constructor = null;
        try {
            constructor = classThatContainsTheConstructorToTest.getDeclaredConstructor(parameterTypes);
        }
        catch (Exception e) {
            throw new ConstructorNotFoundException("Could not lookup the constructor", e);
        }
        return WhiteboxImpl.createInstance(constructor, arguments);
    }

    public static <T> T invokeConstructor(Class<T> classThatContainsTheConstructorToTest, Object ... arguments) throws Exception {
        if (classThatContainsTheConstructorToTest == null) {
            throw new IllegalArgumentException("The class should contain the constructor cannot be null.");
        }
        Class[] argumentTypes = null;
        if (arguments == null) {
            argumentTypes = new Class[]{};
        } else {
            argumentTypes = new Class[arguments.length];
            for (int i = 0; i < arguments.length; ++i) {
                argumentTypes[i] = WhiteboxImpl.getType(arguments[i]);
            }
        }
        Constructor<T> constructor = null;
        constructor = WhiteboxImpl.getBestCandidateConstructor(classThatContainsTheConstructorToTest, argumentTypes, arguments);
        return WhiteboxImpl.createInstance(constructor, arguments);
    }

    private static <T> Constructor<T> getBestCandidateConstructor(Class<T> classThatContainsTheConstructorToTest, Class<?>[] argumentTypes, Object[] arguments) {
        Constructor<T> constructor;
        Constructor<T> potentialConstructorWrapped = WhiteboxImpl.getPotentialConstructorWrapped(classThatContainsTheConstructorToTest, argumentTypes);
        Constructor<T> potentialConstructorPrimitive = WhiteboxImpl.getPotentialConstructorPrimitive(classThatContainsTheConstructorToTest, argumentTypes);
        if (potentialConstructorPrimitive == null && potentialConstructorWrapped == null) {
            constructor = WhiteboxImpl.getPotentialVarArgsConstructor(classThatContainsTheConstructorToTest, arguments);
            if (constructor == null) {
                throw new ConstructorNotFoundException("Failed to find a constructor with parameter types: [" + WhiteboxImpl.getArgumentTypesAsString(arguments) + "]");
            }
        } else if (potentialConstructorPrimitive == null) {
            constructor = potentialConstructorWrapped;
        } else if (potentialConstructorWrapped == null) {
            constructor = potentialConstructorPrimitive;
        } else if (arguments == null || arguments.length == 0 && potentialConstructorPrimitive != null) {
            constructor = potentialConstructorPrimitive;
        } else {
            throw new TooManyConstructorsFoundException("Could not determine which constructor to execute. Please specify the parameter types by hand.");
        }
        return constructor;
    }

    private static <T> Constructor<T> getPotentialConstructorWrapped(Class<T> classThatContainsTheConstructorToTest, Class<?>[] argumentTypes) {
        return new CandidateConstructorSearcher<T>(classThatContainsTheConstructorToTest, argumentTypes).findConstructor();
    }

    private static <T> Constructor<T> getPotentialConstructorPrimitive(Class<T> classThatContainsTheConstructorToTest, Class<?>[] argumentTypes) {
        Constructor<T> potentialConstructorPrimitive = null;
        try {
            Class<?>[] primitiveType = PrimitiveWrapper.toPrimitiveType(argumentTypes);
            if (!WhiteboxImpl.argumentTypesEqualsPrimitiveTypes(argumentTypes, primitiveType)) {
                potentialConstructorPrimitive = new CandidateConstructorSearcher<T>(classThatContainsTheConstructorToTest, primitiveType).findConstructor();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return potentialConstructorPrimitive;
    }

    private static boolean argumentTypesEqualsPrimitiveTypes(Class<?>[] argumentTypes, Class<?>[] primitiveType) {
        for (int index = 0; index < argumentTypes.length; ++index) {
            if (argumentTypes[index].equals(primitiveType[index])) continue;
            return false;
        }
        return true;
    }

    private static <T> Constructor<T> getPotentialVarArgsConstructor(Class<T> classThatContainsTheConstructorToTest, Object ... arguments) {
        Constructor<?>[] declaredConstructors;
        for (Constructor<?> possibleVarArgsConstructor : declaredConstructors = classThatContainsTheConstructorToTest.getDeclaredConstructors()) {
            if (!possibleVarArgsConstructor.isVarArgs()) continue;
            if (arguments == null || arguments.length == 0) {
                return possibleVarArgsConstructor;
            }
            Class<?>[] parameterTypes = possibleVarArgsConstructor.getParameterTypes();
            if (!parameterTypes[parameterTypes.length - 1].getComponentType().isAssignableFrom(WhiteboxImpl.getType(arguments[0]))) continue;
            return possibleVarArgsConstructor;
        }
        return null;
    }

    private static <T> T createInstance(Constructor<T> constructor, Object ... arguments) throws Exception {
        T createdObject;
        block6: {
            if (constructor == null) {
                throw new IllegalArgumentException("Constructor cannot be null");
            }
            constructor.setAccessible(true);
            createdObject = null;
            try {
                if (constructor.isVarArgs()) {
                    Class<?>[] parameterTypes = constructor.getParameterTypes();
                    int varArgsIndex = parameterTypes.length - 1;
                    Class<?> varArgsType = parameterTypes[varArgsIndex].getComponentType();
                    Object varArgsArrayInstance = WhiteboxImpl.createAndPopulateVarArgsArray(varArgsType, varArgsIndex, arguments);
                    Object[] completeArgumentList = new Object[parameterTypes.length];
                    System.arraycopy(arguments, 0, completeArgumentList, 0, varArgsIndex);
                    completeArgumentList[completeArgumentList.length - 1] = varArgsArrayInstance;
                    createdObject = constructor.newInstance(completeArgumentList);
                } else {
                    createdObject = constructor.newInstance(arguments);
                }
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof Exception) {
                    throw (Exception)cause;
                }
                if (!(cause instanceof Error)) break block6;
                throw (Error)cause;
            }
        }
        return createdObject;
    }

    private static Object createAndPopulateVarArgsArray(Class<?> varArgsType, int varArgsStartPosition, Object ... arguments) {
        Object arrayInstance = Array.newInstance(varArgsType, arguments.length - varArgsStartPosition);
        for (int i = varArgsStartPosition; i < arguments.length; ++i) {
            Array.set(arrayInstance, i - varArgsStartPosition, arguments[i]);
        }
        return arrayInstance;
    }

    public static Constructor<?>[] getAllConstructors(Class<?> clazz) {
        Constructor<?>[] declaredConstructors;
        for (Constructor<?> constructor : declaredConstructors = clazz.getDeclaredConstructors()) {
            if (constructor.isAccessible()) continue;
            constructor.setAccessible(true);
        }
        return declaredConstructors;
    }

    public static Method[] getAllMethods(Class<?> clazz) {
        Method[] allMethods = (Method[])allClassMethodsCache.get(clazz);
        if (allMethods == null) {
            allMethods = WhiteboxImpl.doGetAllMethods(clazz);
            allClassMethodsCache.put(clazz, allMethods);
        }
        return allMethods;
    }

    private static Method[] doGetAllMethods(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("You must specify a class in order to get the methods.");
        }
        LinkedHashSet<Method> methods = new LinkedHashSet<Method>();
        for (Class<?> thisType = clazz; thisType != null; thisType = thisType.getSuperclass()) {
            Method[] declaredMethods;
            final Class<?> type = thisType;
            for (Method method : declaredMethods = AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

                @Override
                public Method[] run() {
                    return type.getDeclaredMethods();
                }
            })) {
                if ("finalize".equals(method.getName())) continue;
                method.setAccessible(true);
                methods.add(method);
            }
            Collections.addAll(methods, type.getMethods());
        }
        return methods.toArray(new Method[methods.size()]);
    }

    private static Method[] getAllPublicMethods(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("You must specify a class in order to get the methods.");
        }
        LinkedHashSet<Method> methods = new LinkedHashSet<Method>();
        for (Method method : clazz.getMethods()) {
            method.setAccessible(true);
            methods.add(method);
        }
        return methods.toArray(new Method[0]);
    }

    public static Field[] getAllFields(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("You must specify the class that contains the fields");
        }
        LinkedHashSet<Field> fields = new LinkedHashSet<Field>();
        for (Class<?> thisType = clazz; thisType != null; thisType = thisType.getSuperclass()) {
            Field[] declaredFields;
            for (Field field : declaredFields = thisType.getDeclaredFields()) {
                field.setAccessible(true);
                fields.add(field);
            }
        }
        return fields.toArray(new Field[fields.size()]);
    }

    public static Constructor<?> getFirstParentConstructor(Class<?> klass) {
        try {
            return WhiteboxImpl.getOriginalUnmockedType(klass).getSuperclass().getDeclaredConstructors()[0];
        }
        catch (Exception e) {
            throw new ConstructorNotFoundException("Failed to lookup constructor.", e);
        }
    }

    public static <T> Method findMethod(Class<T> type, String methodName, Class<?> ... parameterTypes) {
        if (methodName == null && parameterTypes == null) {
            throw new IllegalArgumentException("You must specify a method name or parameter types.");
        }
        LinkedList<Method> matchingMethodsList = new LinkedList<Method>();
        for (Method method : WhiteboxImpl.getAllMethods(type)) {
            if (methodName != null && !method.getName().equals(methodName)) continue;
            if (parameterTypes != null && parameterTypes.length > 0) {
                Class<?>[] paramTypes = method.getParameterTypes();
                if (!WhiteboxImpl.checkIfParameterTypesAreSame(method.isVarArgs(), parameterTypes, paramTypes)) continue;
            }
            matchingMethodsList.add(method);
        }
        Method methodToMock = null;
        if (matchingMethodsList.size() > 0) {
            if (matchingMethodsList.size() == 1) {
                methodToMock = (Method)matchingMethodsList.get(0);
            } else if ((parameterTypes != null ? parameterTypes.length : 0) == 0) {
                for (Method method : matchingMethodsList) {
                    if (method.getParameterTypes().length != 0) continue;
                    methodToMock = method;
                    break;
                }
                if (methodToMock == null) {
                    WhiteboxImpl.throwExceptionWhenMultipleMethodMatchesFound("argument parameter types", matchingMethodsList.toArray(new Method[matchingMethodsList.size()]));
                }
            } else {
                WhiteboxImpl.throwExceptionWhenMultipleMethodMatchesFound("argument parameter types", matchingMethodsList.toArray(new Method[matchingMethodsList.size()]));
            }
        }
        return methodToMock;
    }

    public static <T> Class<?> getOriginalUnmockedType(Class<T> type) {
        return WhiteboxImpl.getUnproxiedType(type).getOriginalType();
    }

    public static <T> UnproxiedType getUnproxiedType(Class<T> type) {
        return proxyFrameworks.getUnproxiedType(type);
    }

    static void throwExceptionWhenMultipleMethodMatchesFound(String helpInfo, Method[] methods) {
        if (methods == null || methods.length < 2) {
            throw new IllegalArgumentException("Internal error: throwExceptionWhenMultipleMethodMatchesFound needs at least two methods.");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Several matching methods found, please specify the ");
        sb.append(helpInfo);
        sb.append(" so that PowerMock can determine which method you're referring to.\n");
        sb.append("Matching methods in class ").append(methods[0].getDeclaringClass().getName()).append(" were:\n");
        for (Method method : methods) {
            Class<?>[] parameterTypes;
            sb.append(method.getReturnType().getName()).append(" ");
            sb.append(method.getName()).append("( ");
            for (Class<?> paramType : parameterTypes = method.getParameterTypes()) {
                sb.append(paramType.getName()).append(".class ");
            }
            sb.append(")\n");
        }
        throw new TooManyMethodsFoundException(sb.toString());
    }

    static void throwExceptionWhenMultipleConstructorMatchesFound(Constructor<?>[] constructors) {
        if (constructors == null || constructors.length < 2) {
            throw new IllegalArgumentException("Internal error: throwExceptionWhenMultipleConstructorMatchesFound needs at least two constructors.");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Several matching constructors found, please specify the argument parameter types so that PowerMock can determine which method you're referring to.\n");
        sb.append("Matching constructors in class ").append(constructors[0].getDeclaringClass().getName()).append(" were:\n");
        for (Constructor<?> constructor : constructors) {
            Class<?>[] parameterTypes;
            sb.append(constructor.getName()).append("( ");
            for (Class<?> paramType : parameterTypes = constructor.getParameterTypes()) {
                sb.append(paramType.getName()).append(".class ");
            }
            sb.append(")\n");
        }
        throw new TooManyConstructorsFoundException(sb.toString());
    }

    public static Method findMethodOrThrowException(Class<?> type, String methodName, Class<?> ... parameterTypes) {
        Method methodToMock = WhiteboxImpl.findMethod(type, methodName, parameterTypes);
        WhiteboxImpl.throwExceptionIfMethodWasNotFound(type, methodName, methodToMock, parameterTypes);
        return methodToMock;
    }

    public static Method[] getMethods(Class<?> clazz, String ... methodNames) {
        if (methodNames == null || methodNames.length == 0) {
            throw new IllegalArgumentException("You must supply at least one method name.");
        }
        LinkedList<Method> methodsToMock = new LinkedList<Method>();
        Method[] allMethods = null;
        allMethods = clazz.isInterface() ? WhiteboxImpl.getAllPublicMethods(clazz) : WhiteboxImpl.getAllMethods(clazz);
        for (Method method : allMethods) {
            for (String methodName : methodNames) {
                if (!method.getName().equals(methodName)) continue;
                method.setAccessible(true);
                methodsToMock.add(method);
            }
        }
        Method[] methodArray = methodsToMock.toArray(new Method[0]);
        if (methodArray.length == 0) {
            throw new MethodNotFoundException(String.format("No methods matching the name(s) %s were found in the class hierarchy of %s.", WhiteboxImpl.concatenateStrings(methodNames), WhiteboxImpl.getType(clazz)));
        }
        return methodArray;
    }

    public static Method[] getMethods(Class<?> clazz, String methodName, Class<?>[] expectedTypes, boolean exactParameterTypeMatch) {
        Method[] methods;
        LinkedList<Method> matchingArgumentTypes = new LinkedList<Method>();
        for (Method method : methods = WhiteboxImpl.getMethods(clazz, methodName)) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (!WhiteboxImpl.checkIfParameterTypesAreSame(method.isVarArgs(), expectedTypes, parameterTypes) && (exactParameterTypeMatch || !WhiteboxImpl.checkIfParameterTypesAreSame(method.isVarArgs(), WhiteboxImpl.convertParameterTypesToPrimitive(expectedTypes), parameterTypes))) continue;
            matchingArgumentTypes.add(method);
        }
        Method[] methodArray = matchingArgumentTypes.toArray(new Method[0]);
        if (methodArray.length == 0) {
            throw new MethodNotFoundException(String.format("No methods matching the name(s) %s were found in the class hierarchy of %s.", WhiteboxImpl.concatenateStrings(methodName), WhiteboxImpl.getType(clazz)));
        }
        return matchingArgumentTypes.toArray(new Method[matchingArgumentTypes.size()]);
    }

    public static Field[] getFields(Class<?> clazz, String ... fieldNames) {
        LinkedList<Field> fields = new LinkedList<Field>();
        for (Field field : WhiteboxImpl.getAllFields(clazz)) {
            for (String fieldName : fieldNames) {
                if (!field.getName().equals(fieldName)) continue;
                fields.add(field);
            }
        }
        Field[] fieldArray = fields.toArray(new Field[fields.size()]);
        if (fieldArray.length == 0) {
            throw new FieldNotFoundException(String.format("No fields matching the name(s) %s were found in the class hierarchy of %s.", WhiteboxImpl.concatenateStrings(fieldNames), WhiteboxImpl.getType(clazz)));
        }
        return fieldArray;
    }

    public static <T> T performMethodInvocation(Object tested, Method methodToInvoke, Object ... arguments) throws Exception {
        boolean accessible = methodToInvoke.isAccessible();
        if (!accessible) {
            methodToInvoke.setAccessible(true);
        }
        try {
            Object[] objectArray;
            if (WhiteboxImpl.isPotentialVarArgsMethod(methodToInvoke, arguments)) {
                Class<?>[] parameterTypes = methodToInvoke.getParameterTypes();
                int varArgsIndex = parameterTypes.length - 1;
                Class<?> varArgsType = parameterTypes[varArgsIndex].getComponentType();
                Object varArgsArrayInstance = WhiteboxImpl.createAndPopulateVarArgsArray(varArgsType, varArgsIndex, arguments);
                Object[] completeArgumentList = new Object[parameterTypes.length];
                System.arraycopy(arguments, 0, completeArgumentList, 0, varArgsIndex);
                completeArgumentList[completeArgumentList.length - 1] = varArgsArrayInstance;
                Object object = methodToInvoke.invoke(tested, completeArgumentList);
                return (T)object;
            }
            if (arguments == null) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = arguments;
            } else {
                objectArray = arguments;
            }
            Object parameterTypes = methodToInvoke.invoke(tested, objectArray);
            return (T)parameterTypes;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new MethodInvocationException(cause);
        }
        finally {
            if (!accessible) {
                methodToInvoke.setAccessible(false);
            }
        }
    }

    public static <T> Method[] getAllMethodExcept(Class<T> type, String ... methodNames) {
        Method[] methods;
        LinkedList<Method> methodsToMock = new LinkedList<Method>();
        block0: for (Method method : methods = WhiteboxImpl.getAllMethods(type)) {
            for (String methodName : methodNames) {
                if (method.getName().equals(methodName)) continue block0;
            }
            methodsToMock.add(method);
        }
        return methodsToMock.toArray(new Method[0]);
    }

    public static <T> Method[] getAllMethodsExcept(Class<T> type, String methodNameToExclude, Class<?>[] argumentTypes) {
        Method[] methods = WhiteboxImpl.getAllMethods(type);
        ArrayList<Method> methodList = new ArrayList<Method>();
        block0: for (Method method : methods) {
            if (method.getName().equals(methodNameToExclude)) {
                if (argumentTypes == null || argumentTypes.length <= 0) continue;
                Class<?>[] args = method.getParameterTypes();
                if (args != null && args.length == argumentTypes.length) {
                    for (int i = 0; i < args.length; ++i) {
                        if (args[i].isAssignableFrom(WhiteboxImpl.getOriginalUnmockedType(argumentTypes[i]))) continue block0;
                    }
                }
            }
            methodList.add(method);
        }
        return methodList.toArray(new Method[0]);
    }

    public static boolean areAllMethodsStatic(Method ... methods) {
        for (Method method : methods) {
            if (Modifier.isStatic(method.getModifiers())) continue;
            return false;
        }
        return true;
    }

    static boolean areAllArgumentsOfSameType(Object[] arguments) {
        if (arguments == null || arguments.length <= 1) {
            return true;
        }
        int index = 0;
        Object object = null;
        while (object == null && index < arguments.length) {
            object = arguments[index++];
        }
        if (object == null) {
            return true;
        }
        Class<?> firstArgumentType = WhiteboxImpl.getType(object);
        for (int i = index; i < arguments.length; ++i) {
            Object argument = arguments[i];
            if (argument == null || WhiteboxImpl.getType(argument).isAssignableFrom(firstArgumentType)) continue;
            return false;
        }
        return true;
    }

    static boolean checkArgumentTypesMatchParameterTypes(boolean isVarArgs, Class<?>[] parameterTypes, Object[] arguments) {
        if (parameterTypes == null) {
            throw new IllegalArgumentException("parameter types cannot be null");
        }
        if (!isVarArgs && arguments.length != parameterTypes.length) {
            return false;
        }
        for (int i = 0; i < arguments.length; ++i) {
            boolean isClass;
            Object argument = arguments[i];
            if (argument == null) {
                int index = i >= parameterTypes.length ? parameterTypes.length - 1 : i;
                Class<?> type = parameterTypes[index];
                if (!type.isPrimitive()) continue;
                return false;
            }
            if (i >= parameterTypes.length) {
                if (WhiteboxImpl.isAssignableFrom(parameterTypes[parameterTypes.length - 1], WhiteboxImpl.getType(argument))) continue;
                return false;
            }
            boolean assignableFrom = WhiteboxImpl.isAssignableFrom(parameterTypes[i], WhiteboxImpl.getType(argument));
            boolean bl = isClass = parameterTypes[i].equals(Class.class) && WhiteboxImpl.isClass(argument);
            if (assignableFrom || isClass) continue;
            return false;
        }
        return true;
    }

    static boolean isAssignableFrom(Class<?> type, Class<?> from) {
        Class<?> primitiveFromWrapperType;
        Class<?> theFrom;
        Class<?> theType = WhiteboxImpl.getComponentType(type);
        boolean assignableFrom = theType.isAssignableFrom(theFrom = WhiteboxImpl.getComponentType(from));
        if (!assignableFrom && PrimitiveWrapper.hasPrimitiveCounterPart(theFrom) && (primitiveFromWrapperType = PrimitiveWrapper.getPrimitiveFromWrapperType(theFrom)) != null) {
            assignableFrom = theType.isAssignableFrom(primitiveFromWrapperType);
        }
        return assignableFrom;
    }

    private static Class<?> getComponentType(Class<?> type) {
        Class<?> theType = type;
        while (theType.isArray()) {
            theType = theType.getComponentType();
        }
        return theType;
    }

    public static Class<?> getType(Object object) {
        Class<?> type = null;
        if (WhiteboxImpl.isClass(object)) {
            type = (Class<?>)object;
        } else if (object != null) {
            type = object.getClass();
        }
        return type;
    }

    public static Class<?> getUnproxyType(Object object) {
        Class<?> type = null;
        if (WhiteboxImpl.isClass(object)) {
            type = (Class<?>)object;
        } else if (object != null) {
            type = object.getClass();
        }
        return type == null ? null : WhiteboxImpl.getOriginalUnmockedType(type);
    }

    public static Class<Object> getInnerClassType(Class<?> declaringClass, String name) throws ClassNotFoundException {
        return Class.forName(declaringClass.getName() + "$" + name);
    }

    public static Class<Object> getLocalClassType(Class<?> declaringClass, int occurrence, String name) throws ClassNotFoundException {
        return Class.forName(declaringClass.getName() + "$" + occurrence + name);
    }

    public static Class<Object> getAnonymousInnerClassType(Class<?> declaringClass, int occurrence) throws ClassNotFoundException {
        return Class.forName(declaringClass.getName() + "$" + occurrence);
    }

    public static Set<Field> getFieldsAnnotatedWith(Object object, Class<? extends Annotation> annotation, Class<? extends Annotation> ... additionalAnnotations) {
        Class[] annotations = null;
        if (additionalAnnotations == null || additionalAnnotations.length == 0) {
            annotations = new Class[]{annotation};
        } else {
            annotations = new Class[additionalAnnotations.length + 1];
            annotations[0] = annotation;
            System.arraycopy(additionalAnnotations, 0, annotations, 1, additionalAnnotations.length);
        }
        return WhiteboxImpl.getFieldsAnnotatedWith(object, annotations);
    }

    public static Set<Field> getFieldsAnnotatedWith(Object object, Class<? extends Annotation>[] annotationTypes) {
        return WhiteboxImpl.findAllFieldsUsingStrategy(new FieldAnnotationMatcherStrategy(annotationTypes), object, true, false, WhiteboxImpl.getType(object));
    }

    public static Set<Field> getFieldsOfType(Object object, Class<?> type) {
        return WhiteboxImpl.findAllFieldsUsingStrategy(new AssignableFromFieldTypeMatcherStrategy(type), object, true, false, WhiteboxImpl.getType(object));
    }

    public static Set<Field> getAllInstanceFields(Object object) {
        return WhiteboxImpl.findAllFieldsUsingStrategy(new AllFieldsMatcherStrategy(), object, true, true, WhiteboxImpl.getUnproxyType(object));
    }

    public static Set<Field> getAllStaticFields(Class<?> type) {
        return WhiteboxImpl.findAllFieldsUsingStrategy(new AllFieldsMatcherStrategy(), type, false, false, type);
    }

    public static boolean isClass(Object argument) {
        return argument instanceof Class;
    }

    public static boolean checkIfParameterTypesAreSame(boolean isVarArgs, Class<?>[] expectedParameterTypes, Class<?>[] actualParameterTypes) {
        return new ParameterTypesMatcher(isVarArgs, expectedParameterTypes, actualParameterTypes).match();
    }

    private static Field getField(String fieldName, Class<?> where) {
        if (where == null) {
            throw new IllegalArgumentException("where cannot be null");
        }
        Field field = null;
        try {
            field = where.getDeclaredField(fieldName);
            field.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new FieldNotFoundException("Field '" + fieldName + "' was not found in class " + where.getName() + ".");
        }
        return field;
    }

    private static Field findFieldOrThrowException(Class<?> fieldType, Class<?> where) {
        if (fieldType == null || where == null) {
            throw new IllegalArgumentException("fieldType and where cannot be null");
        }
        Field field = null;
        for (Field currentField : where.getDeclaredFields()) {
            currentField.setAccessible(true);
            if (!currentField.getType().equals(fieldType)) continue;
            field = currentField;
            break;
        }
        if (field == null) {
            throw new FieldNotFoundException("Cannot find a field of type " + fieldType + "in where.");
        }
        return field;
    }

    private static void setField(Object object, Object value, Field foundField) {
        boolean isStatic;
        boolean bl = isStatic = (foundField.getModifiers() & 8) == 8;
        if (isStatic) {
            WhiteboxImpl.setStaticFieldUsingUnsafe(foundField, value);
        } else {
            WhiteboxImpl.setFieldUsingUnsafe(foundField, object, value);
        }
    }

    private static void setStaticFieldUsingUnsafe(final Field field, final Object newValue) {
        try {
            boolean isFinalModifierPresent;
            field.setAccessible(true);
            int fieldModifiersMask = field.getModifiers();
            boolean bl = isFinalModifierPresent = (fieldModifiersMask & 0x10) == 16;
            if (isFinalModifierPresent) {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        try {
                            Unsafe unsafe = WhiteboxImpl.getUnsafe();
                            long offset = unsafe.staticFieldOffset(field);
                            Object base = unsafe.staticFieldBase(field);
                            WhiteboxImpl.setFieldUsingUnsafe(base, field.getType(), offset, newValue, unsafe);
                            return null;
                        }
                        catch (Throwable t) {
                            throw new RuntimeException(t);
                        }
                    }
                });
            } else {
                field.set(null, newValue);
            }
        }
        catch (SecurityException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void setFieldUsingUnsafe(final Field field, final Object object, final Object newValue) {
        block5: {
            try {
                boolean isFinalModifierPresent;
                field.setAccessible(true);
                int fieldModifiersMask = field.getModifiers();
                boolean bl = isFinalModifierPresent = (fieldModifiersMask & 0x10) == 16;
                if (isFinalModifierPresent) {
                    AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            try {
                                Unsafe unsafe = WhiteboxImpl.getUnsafe();
                                long offset = unsafe.objectFieldOffset(field);
                                WhiteboxImpl.setFieldUsingUnsafe(object, field.getType(), offset, newValue, unsafe);
                                return null;
                            }
                            catch (Throwable t) {
                                throw new RuntimeException(t);
                            }
                        }
                    });
                    break block5;
                }
                try {
                    field.set(object, newValue);
                }
                catch (IllegalAccessException ex) {
                    throw new RuntimeException(ex);
                }
            }
            catch (SecurityException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private static Unsafe getUnsafe() throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
        Field field1 = Unsafe.class.getDeclaredField("theUnsafe");
        field1.setAccessible(true);
        Unsafe unsafe = (Unsafe)field1.get(null);
        return unsafe;
    }

    private static void setFieldUsingUnsafe(Object base, Class type, long offset, Object newValue, Unsafe unsafe) {
        if (type == Integer.TYPE) {
            unsafe.putInt(base, offset, (Integer)newValue);
        } else if (type == Short.TYPE) {
            unsafe.putShort(base, offset, (Short)newValue);
        } else if (type == Long.TYPE) {
            unsafe.putLong(base, offset, (Long)newValue);
        } else if (type == Byte.TYPE) {
            unsafe.putByte(base, offset, (Byte)newValue);
        } else if (type == Boolean.TYPE) {
            unsafe.putBoolean(base, offset, (Boolean)newValue);
        } else if (type == Float.TYPE) {
            unsafe.putFloat(base, offset, ((Float)newValue).floatValue());
        } else if (type == Double.TYPE) {
            unsafe.putDouble(base, offset, (Double)newValue);
        } else if (type == Character.TYPE) {
            unsafe.putChar(base, offset, ((Character)newValue).charValue());
        } else {
            unsafe.putObject(base, offset, newValue);
        }
    }

    private static String concatenateStrings(String ... stringsToConcatenate) {
        StringBuilder builder = new StringBuilder();
        int stringsLength = stringsToConcatenate.length;
        for (int i = 0; i < stringsLength; ++i) {
            if (i == stringsLength - 1 && stringsLength != 1) {
                builder.append(" or ");
            } else if (i != 0) {
                builder.append(", ");
            }
            builder.append(stringsToConcatenate[i]);
        }
        return builder.toString();
    }

    private static boolean isPotentialVarArgsMethod(Method method, Object[] arguments) {
        return WhiteboxImpl.doesParameterTypesMatchForVarArgsInvocation(method.isVarArgs(), method.getParameterTypes(), arguments);
    }

    static boolean doesParameterTypesMatchForVarArgsInvocation(boolean isVarArgs, Class<?>[] parameterTypes, Object[] arguments) {
        if (isVarArgs && arguments != null && arguments.length >= 1 && parameterTypes != null && parameterTypes.length >= 1) {
            Class<?> componentType = parameterTypes[parameterTypes.length - 1].getComponentType();
            Object lastArgument = arguments[arguments.length - 1];
            if (lastArgument != null) {
                Class<?> lastArgumentTypeAsPrimitive = WhiteboxImpl.getTypeAsPrimitiveIfWrapped(lastArgument);
                Class<?> varArgsParameterTypeAsPrimitive = WhiteboxImpl.getTypeAsPrimitiveIfWrapped(componentType);
                isVarArgs = varArgsParameterTypeAsPrimitive.isAssignableFrom(lastArgumentTypeAsPrimitive);
            }
        }
        return isVarArgs && WhiteboxImpl.checkArgumentTypesMatchParameterTypes(isVarArgs, parameterTypes, arguments);
    }

    static Class<?> getTypeAsPrimitiveIfWrapped(Object object) {
        if (object != null) {
            Class<?> firstArgumentType = WhiteboxImpl.getType(object);
            Class<?> firstArgumentTypeAsPrimitive = PrimitiveWrapper.hasPrimitiveCounterPart(firstArgumentType) ? PrimitiveWrapper.getPrimitiveFromWrapperType(firstArgumentType) : firstArgumentType;
            return firstArgumentTypeAsPrimitive;
        }
        return null;
    }

    public static void setInternalStateFromContext(Object object, Object context, Object[] additionalContexts) {
        WhiteboxImpl.setInternalStateFromContext(object, context, FieldMatchingStrategy.MATCHING);
        if (additionalContexts != null && additionalContexts.length > 0) {
            for (Object additionContext : additionalContexts) {
                WhiteboxImpl.setInternalStateFromContext(object, additionContext, FieldMatchingStrategy.MATCHING);
            }
        }
    }

    public static void setInternalStateFromContext(Object object, Object context, FieldMatchingStrategy strategy) {
        if (WhiteboxImpl.isClass(context)) {
            WhiteboxImpl.copyState(object, WhiteboxImpl.getType(context), strategy);
        } else {
            WhiteboxImpl.copyState(object, context, strategy);
        }
    }

    public static void setInternalStateFromContext(Object object, Class<?> context, Class<?>[] additionalContexts) {
        WhiteboxImpl.setInternalStateFromContext(object, context, FieldMatchingStrategy.MATCHING);
        if (additionalContexts != null && additionalContexts.length > 0) {
            for (Class<?> additionContext : additionalContexts) {
                WhiteboxImpl.setInternalStateFromContext(object, additionContext, FieldMatchingStrategy.MATCHING);
            }
        }
    }

    static void copyState(Object object, Object context, FieldMatchingStrategy strategy) {
        if (object == null) {
            throw new IllegalArgumentException("object to set state cannot be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null");
        }
        if (strategy == null) {
            throw new IllegalArgumentException("strategy cannot be null");
        }
        Set<Field> allFields = WhiteboxImpl.isClass(context) ? WhiteboxImpl.getAllStaticFields(WhiteboxImpl.getType(context)) : WhiteboxImpl.getAllInstanceFields(context);
        for (Field field : allFields) {
            try {
                boolean isStaticField = Modifier.isStatic(field.getModifiers());
                WhiteboxImpl.setInternalState(isStaticField ? WhiteboxImpl.getType(object) : object, field.getType(), field.get(context));
            }
            catch (FieldNotFoundException e) {
                if (strategy != FieldMatchingStrategy.STRICT) continue;
                throw e;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Internal Error: Failed to get the field value in method setInternalStateFromContext.", e);
            }
        }
    }

    private static void assertObjectInGetInternalStateIsNotNull(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("The object containing the field cannot be null");
        }
    }

    private static Class<?>[] convertParameterTypesToPrimitive(Class<?>[] parameterTypes) {
        Class[] converted = new Class[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> primitiveWrapperType = PrimitiveWrapper.getPrimitiveFromWrapperType(parameterTypes[i]);
            converted[i] = primitiveWrapperType == null ? parameterTypes[i] : primitiveWrapperType;
        }
        return converted;
    }

    public static <T> void copyToMock(T from, T mock) {
        WhiteboxImpl.copy(from, mock, from.getClass());
    }

    public static <T> void copyToRealObject(T from, T to) {
        WhiteboxImpl.copy(from, to, from.getClass());
    }

    private static <T> void copy(T from, T to, Class<?> fromClazz) {
        while (fromClazz != Object.class) {
            WhiteboxImpl.copyValues(from, to, fromClazz);
            fromClazz = fromClazz.getSuperclass();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> void copyValues(T from, T mock, Class<?> classFrom) {
        Field[] fields;
        for (Field field : fields = classFrom.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            boolean accessible = field.isAccessible();
            try {
                field.setAccessible(true);
                WhiteboxImpl.copyValue(from, mock, field);
            }
            catch (Exception exception) {
            }
            finally {
                field.setAccessible(accessible);
            }
        }
    }

    private static <T> void copyValue(T from, T to, Field field) throws IllegalAccessException {
        Object value = field.get(from);
        field.set(to, value);
    }
}

