/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile;

import android.annotation.TargetApi;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.ViewGroup;
import android.webkit.ValueCallback;
import android.webkit.WebView;
import android.widget.FrameLayout;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.prebid.mobile.LogUtil;

public class Util {
    static final String MOPUB_BANNER_VIEW_CLASS = "com.mopub.mobileads.MoPubView";
    static final String MOPUB_INTERSTITIAL_CLASS = "com.mopub.mobileads.MoPubInterstitial";
    static final String AD_MANAGER_REQUEST_CLASS = "com.google.android.gms.ads.doubleclick.PublisherAdRequest";
    static final String AD_MANAGER_REQUEST_BUILDER_CLASS = "com.google.android.gms.ads.doubleclick.PublisherAdRequest$Builder";
    private static final Random RANDOM = new Random();
    private static final HashSet<String> reservedKeys = new HashSet();
    private static final int MoPubQueryStringLimit = 4000;

    private Util() {
    }

    @TargetApi(value=19)
    public static void resizeInBannerNative(final @NonNull ViewGroup adView, final ViewGroup.LayoutParams params, final @Nullable ResizeInBannerNativeListener listener) {
        if (adView.getClass() == Util.getClassFromString(MOPUB_BANNER_VIEW_CLASS)) {
            final Handler handler = new Handler(Looper.getMainLooper());
            final long startTime = System.currentTimeMillis();
            handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (System.currentTimeMillis() - startTime > 500L) {
                        listener.onPrebidAdNotFound();
                    } else if (adView.getChildCount() > 0) {
                        final WebView wv = (WebView)adView.getChildAt(0);
                        wv.evaluateJavascript("document.body.innerHTML", (ValueCallback)new ValueCallback<String>(){

                            public void onReceiveValue(@Nullable String html) {
                                if (!TextUtils.isEmpty((CharSequence)html) && html.contains("native-trk.js")) {
                                    wv.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(params.width, params.height));
                                    adView.setLayoutParams(params);
                                    listener.onResizePrebidAdSuccessful();
                                } else {
                                    listener.onPrebidAdNotFound();
                                }
                            }
                        });
                    } else {
                        handler.postDelayed((Runnable)this, 50L);
                    }
                }
            }, 50L);
        }
    }

    @NonNull
    public static String convertMapToMoPubKeywords(Map<String, String> keywordMap) {
        StringBuilder result = new StringBuilder();
        for (String key : keywordMap.keySet()) {
            result.append(key).append(":").append(keywordMap.get(key)).append(",");
        }
        if (result.length() > 0) {
            result.delete(result.length() - 1, result.length());
        }
        return result.toString();
    }

    @Nullable
    static JSONObject getObjectWithoutEmptyValues(@NonNull JSONObject jsonObject) {
        JSONObject result = null;
        try {
            JSONObject clone = new JSONObject(jsonObject.toString());
            Util.removeEntryWithoutValue(clone);
            if (clone.length() > 0) {
                result = clone;
            }
        }
        catch (JSONException e) {
            LogUtil.e("message:" + e.getMessage());
        }
        return result;
    }

    private static void removeEntryWithoutValue(@NonNull JSONObject map) throws JSONException {
        Iterator iterator = map.keys();
        while (iterator.hasNext()) {
            String stringValue;
            String key = (String)iterator.next();
            Object value = map.opt(key);
            if (value == null) continue;
            if (value instanceof JSONObject) {
                JSONObject mapValue = (JSONObject)value;
                Util.removeEntryWithoutValue(mapValue);
                if (mapValue.length() != 0) continue;
                iterator.remove();
                continue;
            }
            if (value instanceof JSONArray) {
                JSONArray arrayValue = (JSONArray)value;
                arrayValue = Util.removeEntryWithoutValue(arrayValue);
                map.put(key, (Object)arrayValue);
                if (arrayValue.length() != 0) continue;
                iterator.remove();
                continue;
            }
            if (!(value instanceof String) || (stringValue = (String)value).length() != 0) continue;
            iterator.remove();
        }
    }

    @CheckResult
    private static JSONArray removeEntryWithoutValue(@NonNull JSONArray array) throws JSONException {
        for (int i = 0; i < array.length(); ++i) {
            String stringValue;
            Object value = array.opt(i);
            if (value == null) continue;
            if (value instanceof JSONObject) {
                JSONObject mapValue = (JSONObject)value;
                Util.removeEntryWithoutValue(mapValue);
                if (mapValue.length() != 0) continue;
                array = Util.getJsonArrayWithoutEntryByIndex(array, i);
                continue;
            }
            if (value instanceof JSONArray) {
                JSONArray arrayValue = (JSONArray)value;
                arrayValue = Util.removeEntryWithoutValue(arrayValue);
                array.put(i, (Object)arrayValue);
                if (arrayValue.length() != 0) continue;
                array = Util.getJsonArrayWithoutEntryByIndex(array, i);
                continue;
            }
            if (!(value instanceof String) || (stringValue = (String)value).length() != 0) continue;
            array = Util.getJsonArrayWithoutEntryByIndex(array, i);
        }
        return array;
    }

    @CheckResult
    private static JSONArray getJsonArrayWithoutEntryByIndex(JSONArray jsonArray, int pos) throws JSONException {
        JSONArray result = new JSONArray();
        for (int i = 0; i < jsonArray.length(); ++i) {
            if (i == pos) continue;
            result.put(jsonArray.get(i));
        }
        return result;
    }

    static Class getClassFromString(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    static Object callMethodOnObject(Object object, String methodName, Object ... params) {
        try {
            int len = params.length;
            Class[] classes = new Class[len];
            for (int i = 0; i < len; ++i) {
                classes[i] = params[i].getClass();
            }
            Method method = object.getClass().getMethod(methodName, classes);
            return method.invoke(object, params);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    static String randomLowercaseAlphabetic(int count) {
        return Util.randomLowercaseAlphabetic(count, RANDOM);
    }

    static String randomLowercaseAlphabetic(int count, Random random) {
        if (count == 0) {
            return "";
        }
        if (count < 0) {
            throw new IllegalArgumentException("Invalid count value: " + count + " is less than 0.");
        }
        int start = 97;
        int end = 123;
        StringBuilder sb = new StringBuilder(count);
        int gap = end - start;
        while (count-- != 0) {
            int codePoint = random.nextInt(gap) + start;
            sb.appendCodePoint(codePoint);
        }
        return sb.toString();
    }

    static String escapeEcmaScript(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(str.length() + 50);
        int len = str.length();
        block8: for (int pos = 0; pos < len; ++pos) {
            char c = str.charAt(pos);
            switch (c) {
                case '\"': 
                case '\'': 
                case '/': 
                case '\\': {
                    sb.append('\\').append(c);
                    continue block8;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block8;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block8;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block8;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block8;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block8;
                }
                default: {
                    int cp = Character.codePointAt(str, pos);
                    if (cp < 32 || cp > 127) {
                        if (cp > 65535) {
                            char[] surrogatePair = Character.toChars(cp);
                            sb.append("\\u");
                            sb.append(Integer.toHexString(surrogatePair[0]));
                            sb.append("\\u");
                            sb.append(Integer.toHexString(surrogatePair[1]));
                        } else {
                            sb.append(String.format("\\u%04x", cp));
                        }
                        pos += Character.charCount(cp) - 1;
                        continue block8;
                    }
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    static boolean supportedAdObject(Object adObj) {
        if (adObj == null) {
            return false;
        }
        return adObj.getClass() == Util.getClassFromString(MOPUB_BANNER_VIEW_CLASS) || adObj.getClass() == Util.getClassFromString(MOPUB_INTERSTITIAL_CLASS) || adObj.getClass() == Util.getClassFromString(AD_MANAGER_REQUEST_CLASS) || adObj.getClass() == Util.getClassFromString(AD_MANAGER_REQUEST_BUILDER_CLASS) || adObj.getClass() == HashMap.class;
    }

    static void apply(HashMap<String, String> bids, Object adObj) {
        if (adObj == null) {
            return;
        }
        if (adObj.getClass() == Util.getClassFromString(MOPUB_BANNER_VIEW_CLASS) || adObj.getClass() == Util.getClassFromString(MOPUB_INTERSTITIAL_CLASS)) {
            Util.handleMoPubKeywordsUpdate(bids, adObj);
        } else if (adObj.getClass() == Util.getClassFromString(AD_MANAGER_REQUEST_CLASS)) {
            Util.handleAdManagerCustomTargeting(bids, adObj);
        } else if (adObj.getClass() == Util.getClassFromString(AD_MANAGER_REQUEST_BUILDER_CLASS)) {
            Util.handleAdManagerBuilderCustomTargeting(bids, adObj);
        } else if (adObj.getClass() == HashMap.class && bids != null && !bids.isEmpty()) {
            HashMap map = (HashMap)adObj;
            map.clear();
            map.putAll(bids);
        }
    }

    private static void handleMoPubKeywordsUpdate(HashMap<String, String> bids, Object adObj) {
        Util.removeUsedKeywordsForMoPub(adObj);
        if (bids != null && !bids.isEmpty()) {
            StringBuilder keywordsBuilder = new StringBuilder();
            for (String key : bids.keySet()) {
                Util.addReservedKeys(key);
                keywordsBuilder.append(key).append(":").append(bids.get(key)).append(",");
            }
            String pbmKeywords = keywordsBuilder.toString();
            String adViewKeywords = (String)Util.callMethodOnObject(adObj, "getKeywords", new Object[0]);
            adViewKeywords = !TextUtils.isEmpty((CharSequence)adViewKeywords) ? pbmKeywords + adViewKeywords : pbmKeywords;
            if (adViewKeywords.length() <= 4000) {
                Util.callMethodOnObject(adObj, "setKeywords", adViewKeywords);
            }
        }
    }

    private static void handleAdManagerCustomTargeting(HashMap<String, String> bids, Object publisherAdRequest) {
        Bundle bundle;
        Util.removeUsedCustomTargetingForDFP(publisherAdRequest);
        if (bids != null && !bids.isEmpty() && (bundle = (Bundle)Util.callMethodOnObject(publisherAdRequest, "getCustomTargeting", new Object[0])) != null) {
            for (String key : bids.keySet()) {
                bundle.putString(key, bids.get(key));
                Util.addReservedKeys(key);
            }
        }
    }

    private static void handleAdManagerBuilderCustomTargeting(HashMap<String, String> bids, Object publisherAdRequestBuilder) {
        Object publisherAdRequest = Util.callMethodOnObject(publisherAdRequestBuilder, "build", new Object[0]);
        Util.removeUsedCustomTargetingForDFP(publisherAdRequest);
        if (bids != null && !bids.isEmpty()) {
            for (String key : bids.keySet()) {
                Util.callMethodOnObject(publisherAdRequestBuilder, "addCustomTargeting", key, bids.get(key));
                Util.addReservedKeys(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addReservedKeys(String key) {
        HashSet<String> hashSet = reservedKeys;
        synchronized (hashSet) {
            reservedKeys.add(key);
        }
    }

    private static void removeUsedKeywordsForMoPub(Object adViewObj) {
        String adViewKeywords = (String)Util.callMethodOnObject(adViewObj, "getKeywords", new Object[0]);
        if (!TextUtils.isEmpty((CharSequence)adViewKeywords) && reservedKeys != null && !reservedKeys.isEmpty()) {
            String[] adViewKeywordsArray = adViewKeywords.split(",");
            ArrayList<String> adViewKeywordsArrayList = new ArrayList<String>(Arrays.asList(adViewKeywordsArray));
            LinkedList<String> toRemove = new LinkedList<String>();
            for (String keyword : adViewKeywordsArray) {
                String[] keywordArray;
                if (TextUtils.isEmpty((CharSequence)keyword) || !keyword.contains(":") || (keywordArray = keyword.split(":")).length <= 0 || !reservedKeys.contains(keywordArray[0])) continue;
                toRemove.add(keyword);
            }
            adViewKeywordsArrayList.removeAll(toRemove);
            adViewKeywords = TextUtils.join((CharSequence)",", adViewKeywordsArrayList);
            Util.callMethodOnObject(adViewObj, "setKeywords", adViewKeywords);
        }
    }

    private static void removeUsedCustomTargetingForDFP(Object publisherAdRequest) {
        Bundle bundle = (Bundle)Util.callMethodOnObject(publisherAdRequest, "getCustomTargeting", new Object[0]);
        if (bundle != null && reservedKeys != null) {
            for (String key : reservedKeys) {
                bundle.remove(key);
            }
        }
    }

    static <E, U> void addValue(Map<E, Set<U>> map, E key, U value) {
        Set<U> valueSet = map.get(key);
        if (valueSet == null) {
            valueSet = new HashSet<U>();
            map.put(key, valueSet);
        }
        valueSet.add(value);
    }

    @NonNull
    static <E, U> JSONObject toJson(@Nullable Map<E, ? extends Collection<U>> map) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        if (map == null) {
            return jsonObject;
        }
        for (Map.Entry<E, Collection<U>> entry : map.entrySet()) {
            jsonObject.put(entry.getKey().toString(), (Object)new JSONArray(entry.getValue()));
        }
        return jsonObject;
    }

    static <T> List<T> convertJSONArray(JSONArray jsonArray) throws Exception {
        ArrayList<Object> list = new ArrayList<Object>(jsonArray.length());
        for (int i = 0; i < jsonArray.length(); ++i) {
            list.add(jsonArray.get(i));
        }
        return list;
    }

    @Nullable
    static <T, E> List<T> convertCollection(@Nullable Collection<E> collection, Function1<T, E> callable) {
        ArrayList<T> result = null;
        if (collection != null) {
            result = new ArrayList<T>(collection.size());
            for (E element : collection) {
                result.add(callable.apply(element));
            }
        }
        return result;
    }

    public static interface Function1<R, T> {
        public R apply(T var1);
    }

    public static interface ResizeInBannerNativeListener {
        public void onResizePrebidAdSuccessful();

        public void onPrebidAdNotFound();
    }
}

