/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.exporter;

import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.el.MethodExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIPanel;
import javax.faces.component.html.HtmlCommandButton;
import javax.faces.component.html.HtmlCommandLink;
import javax.faces.component.html.HtmlOutputText;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.WorkbookUtil;
import org.apache.poi.xssf.usermodel.DefaultIndexedColorMap;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.column.Column;
import org.primefaces.component.columngroup.ColumnGroup;
import org.primefaces.component.datalist.DataList;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.rowexpansion.RowExpansion;
import org.primefaces.component.subtable.SubTable;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.extensions.component.exporter.Exporter;
import org.primefaces.extensions.util.ExtLangUtils;

public class ExcelExporter
extends Exporter {
    private XSSFWorkbook wb;
    private CellStyle cellStyle;
    private CellStyle facetStyle;
    private Color facetBackground;
    private Short facetFontSize;
    private Color facetFontColor;
    private String facetFontStyle;
    private String fontName;
    private Short cellFontSize;
    private Color cellFontColor;
    private String cellFontStyle;
    private String datasetPadding;
    private CellStyle facetStyleLeftAlign;
    private CellStyle facetStyleCenterAlign;
    private CellStyle facetStyleRightAlign;
    private CellStyle cellStyleLeftAlign;
    private CellStyle cellStyleCenterAlign;
    private CellStyle cellStyleRightAlign;

    @Override
    public void export(ActionEvent event, String tableId, FacesContext context, String filename, String tableTitle, boolean pageOnly, boolean selectionOnly, String encodingType, MethodExpression preProcessor, MethodExpression postProcessor, boolean subTable) throws IOException {
        this.wb = new XSSFWorkbook();
        String safeName = WorkbookUtil.createSafeSheetName((String)filename);
        XSSFSheet sheet = this.wb.createSheet(safeName);
        this.cellStyle = this.wb.createCellStyle();
        this.facetStyle = this.wb.createCellStyle();
        XSSFCellStyle titleStyle = this.wb.createCellStyle();
        this.facetStyleLeftAlign = this.wb.createCellStyle();
        this.facetStyleCenterAlign = this.wb.createCellStyle();
        this.facetStyleRightAlign = this.wb.createCellStyle();
        this.cellStyleLeftAlign = this.wb.createCellStyle();
        this.cellStyleCenterAlign = this.wb.createCellStyle();
        this.cellStyleRightAlign = this.wb.createCellStyle();
        this.createCustomFonts();
        if (preProcessor != null) {
            preProcessor.invoke(context.getELContext(), new Object[]{this.wb});
        }
        int maxColumns = 0;
        String tokenString = ExtLangUtils.normalizeSpace(tableId.replace(',', ' '));
        StringTokenizer st = new StringTokenizer(tokenString, " ");
        while (st.hasMoreElements()) {
            String tableName = (String)st.nextElement();
            UIComponent component = SearchExpressionFacade.resolveComponent((FacesContext)context, (UIComponent)event.getComponent(), (String)tableName);
            if (component == null) {
                throw new FacesException("Cannot find component \"" + tableName + "\" in view.");
            }
            if (!(component instanceof DataTable) && !(component instanceof DataList)) {
                throw new FacesException("Unsupported datasource target:\"" + component.getClass().getName() + "\", exporter must target a PrimeFaces DataTable/DataList.");
            }
            if (!component.isRendered()) continue;
            if (tableTitle != null && !tableTitle.isEmpty() && !tableId.contains(",")) {
                Row titleRow;
                int lastRowNum = sheet.getLastRowNum();
                if (lastRowNum < 0) {
                    lastRowNum = 0;
                }
                short cellIndex = (titleRow = sheet.createRow(lastRowNum)).getLastCellNum() == -1 ? (short)0 : titleRow.getLastCellNum();
                Cell cell = titleRow.createCell((int)cellIndex);
                cell.setCellValue((RichTextString)new XSSFRichTextString(tableTitle));
                XSSFFont titleFont = this.wb.createFont();
                titleFont.setBold(true);
                titleStyle.setFont((Font)titleFont);
                cell.setCellStyle((CellStyle)titleStyle);
                sheet.createRow(lastRowNum + 3);
            }
            if (component instanceof DataList) {
                DataList list = (DataList)component;
                if (list.getHeader() != null) {
                    this.tableFacet(context, (Sheet)sheet, list);
                }
                if (pageOnly) {
                    this.exportPageOnly(list, (Sheet)sheet);
                } else {
                    this.exportAll(list, (Sheet)sheet);
                }
            } else {
                DataTable table = (DataTable)component;
                int columnsCount = ExcelExporter.getColumnsCount(table);
                if (table.getHeader() != null && !subTable) {
                    this.tableFacet(context, (Sheet)sheet, table, columnsCount, Exporter.ColumnType.HEADER.facet());
                }
                if (!subTable) {
                    this.tableColumnGroup((Sheet)sheet, table, Exporter.ColumnType.HEADER.facet());
                }
                this.addColumnFacets(table, (Sheet)sheet, Exporter.ColumnType.HEADER);
                if (pageOnly) {
                    this.exportPageOnly(table, (Sheet)sheet);
                } else if (selectionOnly) {
                    this.exportSelectionOnly(context, table, (Sheet)sheet);
                } else {
                    this.exportAll(context, table, (Sheet)sheet, subTable);
                }
                if (table.hasFooterColumn() && !subTable) {
                    this.addColumnFacets(table, (Sheet)sheet, Exporter.ColumnType.FOOTER);
                }
                if (!subTable) {
                    this.tableColumnGroup((Sheet)sheet, table, Exporter.ColumnType.FOOTER.facet());
                }
                table.setRowIndex(-1);
                int cols = table.getColumnsCount();
                if (maxColumns < cols) {
                    maxColumns = cols;
                }
            }
            sheet.createRow(sheet.getLastRowNum() + Integer.parseInt(this.datasetPadding));
        }
        if (postProcessor != null) {
            postProcessor.invoke(context.getELContext(), new Object[]{this.wb});
        }
        if (!subTable) {
            for (int i = 0; i < maxColumns; ++i) {
                sheet.autoSizeColumn((int)((short)i));
            }
        }
        PrintSetup printSetup = sheet.getPrintSetup();
        printSetup.setLandscape(true);
        printSetup.setPaperSize((short)9);
        sheet.setPrintGridlines(true);
        ExcelExporter.writeExcelToResponse(context.getExternalContext(), (Workbook)this.wb, filename);
    }

    protected void exportAll(FacesContext context, DataTable table, Sheet sheet, boolean subTable) {
        int first = table.getFirst();
        int rowCount = table.getRowCount();
        boolean lazy = table.isLazy();
        int i = 0;
        if (subTable) {
            int subTableCount = table.getRowCount();
            SubTable subtable = table.getSubTable();
            int subTableColumnsCount = ExcelExporter.getColumnsCount(subtable);
            if (table.getHeader() != null) {
                this.tableFacet(context, sheet, table, subTableColumnsCount, Exporter.ColumnType.HEADER.facet());
            }
            this.tableColumnGroup(sheet, table, Exporter.ColumnType.HEADER.facet());
            while (subTableCount > 0) {
                --subTableCount;
                table.setRowIndex(i);
                ++i;
                if (subtable.getHeader() != null) {
                    this.tableFacet(context, sheet, subtable, subTableColumnsCount, Exporter.ColumnType.HEADER.facet());
                }
                if (ExcelExporter.hasHeaderColumn(subtable)) {
                    this.addColumnFacets(subtable, sheet, Exporter.ColumnType.HEADER);
                }
                this.exportAll(subtable, sheet);
                if (ExcelExporter.hasFooterColumn(subtable)) {
                    this.addColumnFacets(subtable, sheet, Exporter.ColumnType.FOOTER);
                }
                if (subtable.getFooter() != null) {
                    this.tableFacet(context, sheet, subtable, subTableColumnsCount, Exporter.ColumnType.FOOTER.facet());
                }
                subtable.setRowIndex(-1);
                subtable = table.getSubTable();
            }
            this.tableColumnGroup(sheet, table, Exporter.ColumnType.FOOTER.facet());
            if (table.hasFooterColumn()) {
                this.tableFacet(context, sheet, table, subTableColumnsCount, Exporter.ColumnType.FOOTER.facet());
            }
        } else if (lazy) {
            if (rowCount > 0) {
                table.setFirst(0);
                table.setRows(rowCount);
                table.clearLazyCache();
                table.loadLazyData();
            }
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                this.exportRow(table, sheet, rowIndex);
            }
            table.setFirst(first);
            table.setRowIndex(-1);
            table.clearLazyCache();
            table.loadLazyData();
        } else {
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                this.exportRow(table, sheet, rowIndex);
            }
            table.setFirst(first);
        }
    }

    protected void exportAll(SubTable table, Sheet sheet) {
        int rowCount = table.getRowCount();
        this.tableColumnGroup(sheet, table, Exporter.ColumnType.HEADER.facet());
        if (ExcelExporter.hasHeaderColumn(table)) {
            this.addColumnFacets(table, sheet, Exporter.ColumnType.HEADER);
        }
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            this.exportRow(table, sheet, rowIndex);
        }
        if (ExcelExporter.hasFooterColumn(table)) {
            this.addColumnFacets(table, sheet, Exporter.ColumnType.FOOTER);
        }
        this.tableColumnGroup(sheet, table, Exporter.ColumnType.FOOTER.facet());
    }

    protected void exportAll(DataList list, Sheet sheet) {
        int first = list.getFirst();
        int rowCount = list.getRowCount();
        int rows = list.getRows();
        boolean lazy = list.isLazy();
        if (lazy) {
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                if (rowIndex % rows == 0) {
                    list.setFirst(rowIndex);
                    list.loadLazyData();
                }
                this.exportRow(list, sheet, rowIndex);
            }
            list.setFirst(first);
            list.loadLazyData();
        } else {
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                this.exportRow(list, sheet, rowIndex);
            }
            list.setFirst(first);
        }
    }

    protected void exportPageOnly(DataTable table, Sheet sheet) {
        int first = table.getFirst();
        int rowsToExport = first + table.getRows();
        for (int rowIndex = first; rowIndex < rowsToExport; ++rowIndex) {
            this.exportRow(table, sheet, rowIndex);
        }
    }

    protected void exportPageOnly(DataList list, Sheet sheet) {
        int first = list.getFirst();
        int rowsToExport = first + list.getRows();
        for (int rowIndex = first; rowIndex < rowsToExport; ++rowIndex) {
            this.exportRow(list, sheet, rowIndex);
        }
    }

    protected void exportSelectionOnly(FacesContext context, DataTable table, Sheet sheet) {
        Object selection = table.getSelection();
        String var = table.getVar();
        if (selection != null) {
            Map requestMap = context.getExternalContext().getRequestMap();
            if (selection.getClass().isArray()) {
                int size = Array.getLength(selection);
                for (int i = 0; i < size; ++i) {
                    requestMap.put(var, Array.get(selection, i));
                    this.exportCells(table, sheet);
                }
            } else if (Collection.class.isAssignableFrom(selection.getClass())) {
                Collection collection = (Collection)selection;
                for (Object o : collection) {
                    requestMap.put(var, o);
                    this.exportCells(table, sheet);
                }
            } else {
                requestMap.put(var, selection);
                this.exportCells(table, sheet);
            }
        }
    }

    protected void tableFacet(FacesContext context, Sheet sheet, DataTable table, int columnCount, String facetType) {
        Map map = table.getFacets();
        UIComponent component = (UIComponent)map.get(facetType);
        if (component != null) {
            String headerValue;
            if (component instanceof HtmlCommandButton) {
                headerValue = this.exportValue(context, component);
            } else if (component instanceof HtmlCommandLink) {
                headerValue = this.exportValue(context, component);
            } else if (component instanceof UIPanel) {
                StringBuilder header = new StringBuilder("");
                for (UIComponent child : component.getChildren()) {
                    headerValue = this.exportValue(context, child);
                    header.append(headerValue);
                }
                headerValue = header.toString();
            } else {
                headerValue = ExcelExporter.exportFacetValue(context, component);
            }
            int sheetRowIndex = sheet.getLastRowNum() + 1;
            Row row = sheet.createRow(sheetRowIndex);
            Cell cell = row.createCell(0);
            cell.setCellValue(headerValue);
            cell.setCellStyle(this.facetStyle);
            sheet.addMergedRegion(new CellRangeAddress(sheetRowIndex, sheetRowIndex, 0, columnCount - 1));
        }
    }

    protected void tableFacet(FacesContext context, Sheet sheet, SubTable table, int columnCount, String facetType) {
        Map map = table.getFacets();
        UIComponent component = (UIComponent)map.get(facetType);
        if (component != null) {
            String headerValue;
            if (component instanceof HtmlCommandButton) {
                headerValue = this.exportValue(context, component);
            } else if (component instanceof HtmlCommandLink) {
                headerValue = this.exportValue(context, component);
            } else if (component instanceof UIPanel) {
                StringBuilder header = new StringBuilder("");
                for (UIComponent child : component.getChildren()) {
                    headerValue = this.exportValue(context, child);
                    header.append(headerValue);
                }
                headerValue = header.toString();
            } else {
                headerValue = ExcelExporter.exportFacetValue(context, component);
            }
            int sheetRowIndex = sheet.getLastRowNum() + 1;
            Row row = sheet.createRow(sheetRowIndex);
            Cell cell = row.createCell(0);
            cell.setCellValue(headerValue);
            cell.setCellStyle(this.facetStyle);
            sheet.addMergedRegion(new CellRangeAddress(sheetRowIndex, sheetRowIndex, 0, columnCount - 1));
        }
    }

    protected void tableFacet(FacesContext context, Sheet sheet, DataList list) {
        Map map = list.getFacets();
        UIComponent component = (UIComponent)map.get(Exporter.ColumnType.HEADER.facet());
        if (component != null) {
            String headerValue = component instanceof HtmlCommandButton ? this.exportValue(context, component) : (component instanceof HtmlCommandLink ? this.exportValue(context, component) : ExcelExporter.exportFacetValue(context, component));
            int sheetRowIndex = sheet.getLastRowNum() + 1;
            Row row = sheet.createRow(sheetRowIndex);
            Cell cell = row.createCell(0);
            cell.setCellValue(headerValue);
            cell.setCellStyle(this.facetStyle);
            sheet.addMergedRegion(new CellRangeAddress(sheetRowIndex, sheetRowIndex, 0, 1));
        }
    }

    private static int calculateColumnOffset(Sheet sheet, int row, int col) {
        for (int j = 0; j < sheet.getNumMergedRegions(); ++j) {
            CellRangeAddress merged = sheet.getMergedRegion(j);
            if (!merged.isInRange(row, col)) continue;
            col = merged.getLastColumn() + 1;
        }
        return col;
    }

    private void putText(Row xlRow, short col, String text) {
        Cell cell = xlRow.createCell((int)col);
        cell.setCellValue(text);
        cell.setCellStyle(this.facetStyleCenterAlign);
    }

    protected void tableColumnGroup(Sheet sheet, DataTable table, String facetType) {
        this.facetStyleCenterAlign.setAlignment(HorizontalAlignment.CENTER);
        this.facetStyleCenterAlign.setVerticalAlignment(VerticalAlignment.CENTER);
        this.facetStyleCenterAlign.setWrapText(true);
        ColumnGroup cg = table.getColumnGroup(facetType);
        List headerComponentList = null;
        if (cg != null) {
            headerComponentList = cg.getChildren();
        }
        if (headerComponentList != null) {
            for (UIComponent component : headerComponentList) {
                if (!(component instanceof org.primefaces.component.row.Row)) continue;
                org.primefaces.component.row.Row row = (org.primefaces.component.row.Row)component;
                int rowIndex = sheet.getLastRowNum() + 1;
                Row xlRow = sheet.createRow(rowIndex);
                int colIndex = 0;
                for (UIComponent rowComponent : row.getChildren()) {
                    UIColumn column = (UIColumn)rowComponent;
                    if (!column.isRendered() || !column.isExportable()) continue;
                    String text = facetType.equalsIgnoreCase(Exporter.ColumnType.HEADER.facet()) ? column.getHeaderText() : column.getFooterText();
                    int rowSpan = column.getRowspan() - 1;
                    int colSpan = column.getColspan() - 1;
                    if (rowSpan > 0 && colSpan > 0) {
                        colIndex = ExcelExporter.calculateColumnOffset(sheet, rowIndex, colIndex);
                        sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex + rowSpan, colIndex, colIndex + colSpan));
                        this.putText(xlRow, (short)colIndex, text);
                        colIndex += colSpan;
                    } else if (rowSpan > 0) {
                        sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex + rowSpan, colIndex, colIndex));
                        this.putText(xlRow, (short)colIndex, text);
                    } else if (colSpan > 0) {
                        colIndex = ExcelExporter.calculateColumnOffset(sheet, rowIndex, colIndex);
                        sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex, colIndex, colIndex + colSpan));
                        this.putText(xlRow, (short)colIndex, text);
                        colIndex += colSpan;
                    } else {
                        colIndex = ExcelExporter.calculateColumnOffset(sheet, rowIndex, colIndex);
                        this.putText(xlRow, (short)colIndex, text);
                    }
                    ++colIndex;
                }
            }
        }
    }

    protected void tableColumnGroup(Sheet sheet, SubTable table, String facetType) {
        ColumnGroup cg = table.getColumnGroup(facetType);
        List headerComponentList = null;
        if (cg != null) {
            headerComponentList = cg.getChildren();
        }
        if (headerComponentList != null) {
            for (UIComponent component : headerComponentList) {
                if (!(component instanceof org.primefaces.component.row.Row)) continue;
                org.primefaces.component.row.Row row = (org.primefaces.component.row.Row)component;
                int sheetRowIndex = sheet.getPhysicalNumberOfRows() > 0 ? sheet.getLastRowNum() + 1 : 0;
                Row xlRow = sheet.createRow(sheetRowIndex);
                int i = 0;
                for (UIComponent rowComponent : row.getChildren()) {
                    int j;
                    Cell cell;
                    UIColumn column = (UIColumn)rowComponent;
                    String value = facetType.equalsIgnoreCase(Exporter.ColumnType.HEADER.facet()) ? column.getHeaderText() : column.getFooterText();
                    int rowSpan = column.getRowspan();
                    int colSpan = column.getColspan();
                    if (rowSpan > 1 || colSpan > 1) {
                        if (rowSpan > 1) {
                            cell = xlRow.createCell((int)((short)i));
                            boolean rowSpanFlag = false;
                            for (int j2 = 0; j2 < sheet.getNumMergedRegions(); ++j2) {
                                CellRangeAddress merged = sheet.getMergedRegion(j2);
                                if (!merged.isInRange(sheetRowIndex, i)) continue;
                                rowSpanFlag = true;
                            }
                            if (!rowSpanFlag) {
                                cell.setCellStyle(this.cellStyle);
                                cell.setCellValue(value);
                                sheet.addMergedRegion(new CellRangeAddress(sheetRowIndex, sheetRowIndex + rowSpan - 1, i, i));
                            }
                        }
                        if (colSpan > 1) {
                            cell = xlRow.createCell((int)((short)i));
                            for (j = 0; j < sheet.getNumMergedRegions(); ++j) {
                                CellRangeAddress merged = sheet.getMergedRegion(j);
                                if (!merged.isInRange(sheetRowIndex, i)) continue;
                                cell = xlRow.createCell((int)((short)(++i)));
                            }
                            cell.setCellStyle(this.cellStyle);
                            cell.setCellValue(value);
                            sheet.addMergedRegion(new CellRangeAddress(sheetRowIndex, sheetRowIndex, i, i + colSpan - 1));
                            i = i + colSpan - 1;
                        }
                    } else {
                        cell = xlRow.createCell((int)((short)i));
                        for (j = 0; j < sheet.getNumMergedRegions(); ++j) {
                            CellRangeAddress merged = sheet.getMergedRegion(j);
                            if (!merged.isInRange(sheetRowIndex, i)) continue;
                            cell = xlRow.createCell((int)((short)(++i)));
                        }
                        cell.setCellValue(value);
                        cell.setCellStyle(this.facetStyle);
                    }
                    ++i;
                }
            }
        }
    }

    protected void exportRow(DataTable table, Sheet sheet, int rowIndex) {
        table.setRowIndex(rowIndex);
        if (!table.isRowAvailable()) {
            return;
        }
        this.exportCells(table, sheet);
    }

    protected void exportRow(SubTable table, Sheet sheet, int rowIndex) {
        table.setRowIndex(rowIndex);
        if (!table.isRowAvailable()) {
            return;
        }
        this.exportCells(table, sheet);
    }

    protected void exportRow(DataList list, Sheet sheet, int rowIndex) {
        list.setRowIndex(rowIndex);
        if (!list.isRowAvailable()) {
            return;
        }
        this.exportCells(list, sheet);
    }

    protected void exportCells(DataTable table, Sheet sheet) {
        RowExpansion rowExpansion;
        int sheetRowIndex = sheet.getLastRowNum() + 1;
        Row row = sheet.createRow(sheetRowIndex);
        this.facetStyleLeftAlign.setAlignment(HorizontalAlignment.LEFT);
        this.facetStyleCenterAlign.setAlignment(HorizontalAlignment.CENTER);
        this.facetStyleCenterAlign.setVerticalAlignment(VerticalAlignment.CENTER);
        this.facetStyleCenterAlign.setWrapText(true);
        this.facetStyleRightAlign.setAlignment(HorizontalAlignment.RIGHT);
        this.cellStyleLeftAlign.setAlignment(HorizontalAlignment.LEFT);
        this.cellStyleCenterAlign.setAlignment(HorizontalAlignment.CENTER);
        this.cellStyleRightAlign.setAlignment(HorizontalAlignment.RIGHT);
        for (UIColumn col : table.getColumns()) {
            if (col instanceof DynamicColumn) {
                ((DynamicColumn)col).applyStatelessModel();
            }
            if (!col.isRendered() || !col.isExportable()) continue;
            this.addColumnValue(row, col.getChildren(), col);
        }
        FacesContext context = null;
        if (table.getRowIndex() == 0) {
            for (UIComponent component : table.getChildren()) {
                if (!(component instanceof RowExpansion) || (rowExpansion = (RowExpansion)component).getChildren() == null) continue;
                if (rowExpansion.getChildren().get(0) instanceof DataTable) {
                    DataTable childTable = (DataTable)rowExpansion.getChildren().get(0);
                    childTable.setRowIndex(-1);
                }
                if (!(rowExpansion.getChildren().get(0) instanceof DataList)) continue;
                DataList childList = (DataList)rowExpansion.getChildren().get(0);
                childList.setRowIndex(-1);
            }
        }
        for (UIComponent component : table.getChildren()) {
            int i;
            if (!(component instanceof RowExpansion) || (rowExpansion = (RowExpansion)component).getChildren() == null) continue;
            for (i = 0; i < rowExpansion.getChildren().size(); ++i) {
                UIComponent child = (UIComponent)rowExpansion.getChildren().get(i);
                if (!(child instanceof DataList)) continue;
                DataList list = (DataList)child;
                if (list.getHeader() != null) {
                    this.tableFacet(null, sheet, list);
                }
                this.exportAll(list, sheet);
            }
            for (i = 0; i < rowExpansion.getChildren().size(); ++i) {
                DataTable childTable;
                int columnsCount;
                if (!(rowExpansion.getChildren().get(i) instanceof DataTable) || (columnsCount = ExcelExporter.getColumnsCount(childTable = (DataTable)rowExpansion.getChildren().get(i))) <= 0) continue;
                if (childTable.getHeader() != null) {
                    this.tableFacet(null, sheet, childTable, columnsCount, Exporter.ColumnType.HEADER.facet());
                }
                this.tableColumnGroup(sheet, childTable, Exporter.ColumnType.HEADER.facet());
                this.addColumnFacets(childTable, sheet, Exporter.ColumnType.HEADER);
                this.exportAll(context, childTable, sheet, false);
                if (childTable.hasFooterColumn()) {
                    this.addColumnFacets(childTable, sheet, Exporter.ColumnType.FOOTER);
                }
                this.tableColumnGroup(sheet, childTable, Exporter.ColumnType.FOOTER.facet());
                childTable.setRowIndex(-1);
            }
        }
    }

    protected void exportCells(SubTable table, Sheet sheet) {
        int sheetRowIndex = sheet.getLastRowNum() + 1;
        Row row = sheet.createRow(sheetRowIndex);
        this.facetStyleLeftAlign.setAlignment(HorizontalAlignment.LEFT);
        this.facetStyleCenterAlign.setAlignment(HorizontalAlignment.CENTER);
        this.facetStyleCenterAlign.setVerticalAlignment(VerticalAlignment.CENTER);
        this.facetStyleCenterAlign.setWrapText(true);
        this.facetStyleRightAlign.setAlignment(HorizontalAlignment.RIGHT);
        this.cellStyleLeftAlign.setAlignment(HorizontalAlignment.LEFT);
        this.cellStyleCenterAlign.setAlignment(HorizontalAlignment.CENTER);
        this.cellStyleRightAlign.setAlignment(HorizontalAlignment.RIGHT);
        for (UIColumn col : table.getColumns()) {
            if (col instanceof DynamicColumn) {
                ((DynamicColumn)col).applyStatelessModel();
            }
            if (!col.isRendered() || !col.isExportable()) continue;
            this.addColumnValue(row, col.getChildren(), col);
        }
    }

    protected void exportCells(DataList list, Sheet sheet) {
        int sheetRowIndex = sheet.getLastRowNum() + 1;
        Row row = sheet.createRow(sheetRowIndex);
        this.facetStyleLeftAlign.setAlignment(HorizontalAlignment.LEFT);
        this.facetStyleCenterAlign.setAlignment(HorizontalAlignment.CENTER);
        this.facetStyleCenterAlign.setVerticalAlignment(VerticalAlignment.CENTER);
        this.facetStyleCenterAlign.setWrapText(true);
        this.facetStyleRightAlign.setAlignment(HorizontalAlignment.RIGHT);
        this.cellStyleLeftAlign.setAlignment(HorizontalAlignment.LEFT);
        this.cellStyleCenterAlign.setAlignment(HorizontalAlignment.CENTER);
        this.cellStyleRightAlign.setAlignment(HorizontalAlignment.RIGHT);
        for (UIComponent component : list.getChildren()) {
            if (component instanceof Column) {
                UIColumn column = (UIColumn)component;
                for (UIComponent childComponent : column.getChildren()) {
                    short cellIndex = row.getLastCellNum() == -1 ? (short)0 : row.getLastCellNum();
                    Cell cell = row.createCell((int)cellIndex);
                    if (!component.isRendered()) continue;
                    String value = this.exportValue(FacesContext.getCurrentInstance(), childComponent);
                    cell.setCellValue((RichTextString)new XSSFRichTextString(value));
                    cell.setCellStyle(this.cellStyle);
                }
                continue;
            }
            short cellIndex = row.getLastCellNum() == -1 ? (short)0 : row.getLastCellNum();
            Cell cell = row.createCell((int)cellIndex);
            if (!component.isRendered()) continue;
            String value = this.exportValue(FacesContext.getCurrentInstance(), component);
            cell.setCellValue((RichTextString)new XSSFRichTextString(value));
            cell.setCellStyle(this.cellStyle);
        }
    }

    protected void addColumnFacets(DataTable table, Sheet sheet, Exporter.ColumnType columnType) {
        int sheetRowIndex = sheet.getLastRowNum() + 1;
        Row rowHeader = null;
        for (UIColumn col : table.getColumns()) {
            if (col instanceof DynamicColumn) {
                ((DynamicColumn)col).applyStatelessModel();
            }
            if (!col.isRendered() || !col.isExportable() || col.getFacet(columnType.facet()) == null) continue;
            if (rowHeader == null) {
                rowHeader = sheet.createRow(sheetRowIndex);
            }
            this.addColumnValue(rowHeader, col.getFacet(columnType.facet()));
        }
    }

    protected void addColumnFacets(SubTable table, Sheet sheet, Exporter.ColumnType columnType) {
        int sheetRowIndex = sheet.getPhysicalNumberOfRows() > 0 ? sheet.getLastRowNum() + 1 : 0;
        Row rowHeader = sheet.createRow(sheetRowIndex);
        for (UIColumn col : table.getColumns()) {
            if (col instanceof DynamicColumn) {
                ((DynamicColumn)col).applyStatelessModel();
            }
            if (!col.isRendered() || !col.isExportable()) continue;
            this.addColumnValue(rowHeader, col.getFacet(columnType.facet()));
        }
    }

    protected void addColumnValue(Row row, UIComponent component) {
        short cellIndex = row.getLastCellNum() == -1 ? (short)0 : row.getLastCellNum();
        Cell cell = row.createCell((int)cellIndex);
        String value = component == null ? "" : this.exportValue(FacesContext.getCurrentInstance(), component);
        cell.setCellValue((RichTextString)new XSSFRichTextString(value));
        this.addColumnAlignments(component, cell);
    }

    protected void addColumnValue(Row row, List<UIComponent> components, UIColumn column) {
        short cellIndex = row.getLastCellNum() == -1 ? (short)0 : row.getLastCellNum();
        Cell cell = row.createCell((int)cellIndex);
        FacesContext context = FacesContext.getCurrentInstance();
        if (column.getExportFunction() != null) {
            cell.setCellValue((RichTextString)new XSSFRichTextString(ExcelExporter.exportColumnByFunction(context, column)));
        } else {
            StringBuilder builder = new StringBuilder();
            for (UIComponent component : components) {
                String value;
                if (!component.isRendered() || (value = this.exportValue(context, component)) == null) continue;
                builder.append(value);
            }
            cell.setCellValue((RichTextString)new XSSFRichTextString(builder.toString()));
            for (UIComponent component : components) {
                this.addColumnAlignments(component, cell);
            }
        }
    }

    protected void addColumnAlignments(UIComponent component, Cell cell) {
        if (component instanceof HtmlOutputText) {
            HtmlOutputText output = (HtmlOutputText)component;
            if (output.getStyle() != null && output.getStyle().contains("left")) {
                cell.setCellStyle(this.cellStyleLeftAlign);
            }
            if (output.getStyle() != null && output.getStyle().contains("right")) {
                cell.setCellStyle(this.cellStyleRightAlign);
            }
            if (output.getStyle() != null && output.getStyle().contains("center")) {
                cell.setCellStyle(this.cellStyleCenterAlign);
            }
        }
    }

    @Override
    public void customFormat(String facetBackground, String facetFontSize, String facetFontColor, String facetFontStyle, String fontName, String cellFontSize, String cellFontColor, String cellFontStyle, String datasetPadding, String orientation) {
        if (facetBackground != null) {
            this.facetBackground = Color.decode(facetBackground);
        }
        if (facetFontColor != null) {
            this.facetFontColor = Color.decode(facetFontColor);
        }
        if (fontName != null) {
            this.fontName = fontName;
        }
        if (cellFontColor != null) {
            this.cellFontColor = Color.decode(cellFontColor);
        }
        this.facetFontSize = Short.valueOf(facetFontSize);
        this.facetFontStyle = facetFontStyle;
        this.cellFontSize = Short.valueOf(cellFontSize);
        this.cellFontStyle = cellFontStyle;
        this.datasetPadding = datasetPadding;
    }

    protected void createCustomFonts() {
        XSSFFont facetFont = this.wb.createFont();
        XSSFFont cellFont = this.wb.createFont();
        DefaultIndexedColorMap colorMap = new DefaultIndexedColorMap();
        if (this.cellFontColor != null) {
            XSSFColor cellColor = new XSSFColor(this.cellFontColor, (IndexedColorMap)colorMap);
            cellFont.setColor(cellColor);
        }
        if (this.cellFontSize != null) {
            cellFont.setFontHeightInPoints(this.cellFontSize.shortValue());
        }
        if (this.cellFontStyle.equalsIgnoreCase("BOLD")) {
            cellFont.setBold(true);
        }
        if (this.cellFontStyle.equalsIgnoreCase("ITALIC")) {
            cellFont.setItalic(true);
        }
        if (this.facetFontStyle.equalsIgnoreCase("BOLD")) {
            facetFont.setBold(true);
        }
        if (this.facetFontStyle.equalsIgnoreCase("ITALIC")) {
            facetFont.setItalic(true);
        }
        if (this.fontName != null) {
            cellFont.setFontName(this.fontName);
            facetFont.setFontName(this.fontName);
        }
        if (this.facetBackground != null) {
            XSSFColor backgroundColor = new XSSFColor(this.facetBackground, (IndexedColorMap)colorMap);
            ((XSSFCellStyle)this.facetStyle).setFillForegroundColor(backgroundColor);
            ((XSSFCellStyle)this.facetStyleLeftAlign).setFillForegroundColor(backgroundColor);
            ((XSSFCellStyle)this.facetStyleCenterAlign).setFillForegroundColor(backgroundColor);
            ((XSSFCellStyle)this.facetStyleRightAlign).setFillForegroundColor(backgroundColor);
            this.facetStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.facetStyleLeftAlign.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.facetStyleCenterAlign.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.facetStyleRightAlign.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        }
        if (this.facetFontColor != null) {
            XSSFColor facetColor = new XSSFColor(this.facetFontColor, (IndexedColorMap)colorMap);
            facetFont.setColor(facetColor);
        }
        if (this.facetFontSize != null) {
            facetFont.setFontHeightInPoints(this.facetFontSize.shortValue());
        }
        this.cellStyle.setFont((Font)cellFont);
        this.cellStyleLeftAlign.setFont((Font)cellFont);
        this.cellStyleCenterAlign.setFont((Font)cellFont);
        this.cellStyleRightAlign.setFont((Font)cellFont);
        this.facetStyle.setFont((Font)facetFont);
        this.facetStyleLeftAlign.setFont((Font)facetFont);
        this.facetStyleCenterAlign.setFont((Font)facetFont);
        this.facetStyleRightAlign.setFont((Font)facetFont);
    }

    protected static void writeExcelToResponse(ExternalContext externalContext, Workbook generatedExcel, String filename) throws IOException {
        externalContext.setResponseContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        externalContext.setResponseHeader("Expires", "0");
        externalContext.setResponseHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        externalContext.setResponseHeader("Pragma", "public");
        externalContext.setResponseHeader("Content-disposition", "attachment;filename=" + filename + ".xlsx");
        externalContext.addResponseCookie("primefaces.download", "true", Collections.emptyMap());
        OutputStream out = externalContext.getResponseOutputStream();
        generatedExcel.write(out);
        externalContext.responseFlushBuffer();
    }
}

