/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.timeago;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.extensions.component.timeago.TimeAgo;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class TimeAgoRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        TimeAgo timeAgo = (TimeAgo)component;
        Object value = timeAgo.getValue();
        if (value == null) {
            return;
        }
        this.encodeMarkup(context, timeAgo);
        this.encodeScript(context, timeAgo);
    }

    protected void encodeMarkup(FacesContext context, TimeAgo timeAgo) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = timeAgo.getClientId(context);
        String styleClass = timeAgo.getStyleClass();
        styleClass = styleClass == null ? "ui-timeago ui-widget" : "ui-timeago ui-widget " + styleClass;
        writer.startElement("span", (UIComponent)timeAgo);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (timeAgo.getStyle() != null) {
            writer.writeAttribute("style", (Object)timeAgo.getStyle(), "style");
        }
        this.encodeTime(context, timeAgo);
        writer.endElement("span");
    }

    protected void encodeTime(FacesContext context, TimeAgo timeAgo) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String formattedForJs = timeAgo.formattedForJs();
        writer.startElement("time", null);
        writer.writeAttribute("datetime", (Object)formattedForJs, null);
        writer.writeText((Object)(timeAgo.getTitlePattern() == null ? formattedForJs : timeAgo.formattedForTitle()), null);
        writer.endElement("time");
    }

    protected void encodeScript(FacesContext context, TimeAgo timeAgo) throws IOException {
        String locale = timeAgo.calculateLocale().getLanguage();
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("ExtTimeAgo", timeAgo.resolveWidgetVar(), timeAgo.getClientId(context));
        if (locale != null) {
            wb.attr("locale", locale);
        }
        wb.finish();
    }
}

