/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac;

import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import lombok.javac.Comment;

public class CommentCatcher {
    private final JavaCompiler compiler;
    private final Map<JCTree.JCCompilationUnit, List<Comment>> commentsMap;

    public static CommentCatcher create(Context context) {
        CommentCatcher.registerCommentsCollectingScannerFactory(context);
        JavaCompiler compiler = new JavaCompiler(context);
        WeakHashMap<JCTree.JCCompilationUnit, List<Comment>> commentsMap = new WeakHashMap<JCTree.JCCompilationUnit, List<Comment>>();
        CommentCatcher.setInCompiler(compiler, context, commentsMap);
        compiler.keepComments = true;
        compiler.genEndPos = true;
        return new CommentCatcher(compiler, commentsMap);
    }

    private CommentCatcher(JavaCompiler compiler, Map<JCTree.JCCompilationUnit, List<Comment>> commentsMap) {
        this.compiler = compiler;
        this.commentsMap = commentsMap;
    }

    public JavaCompiler getCompiler() {
        return this.compiler;
    }

    public List<Comment> getComments(JCTree.JCCompilationUnit ast) {
        List<Comment> list = this.commentsMap.get(ast);
        return list == null ? Collections.emptyList() : list;
    }

    private static void registerCommentsCollectingScannerFactory(Context context) {
        try {
            if (JavaCompiler.version().startsWith("1.6")) {
                Class.forName("lombok.javac.java6.CommentCollectingScannerFactory").getMethod("preRegister", Context.class).invoke(null, context);
            } else {
                Class.forName("lombok.javac.java7.CommentCollectingScannerFactory").getMethod("preRegister", Context.class).invoke(null, context);
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private static void setInCompiler(JavaCompiler compiler, Context context, Map<JCTree.JCCompilationUnit, List<Comment>> commentsMap) {
        try {
            if (JavaCompiler.version().startsWith("1.6")) {
                Class<?> parserFactory = Class.forName("lombok.javac.java6.CommentCollectingParserFactory");
                parserFactory.getMethod("setInCompiler", JavaCompiler.class, Context.class, Map.class).invoke(null, compiler, context, commentsMap);
            } else {
                Class<?> parserFactory = Class.forName("lombok.javac.java7.CommentCollectingParserFactory");
                parserFactory.getMethod("setInCompiler", JavaCompiler.class, Context.class, Map.class).invoke(null, compiler, context, commentsMap);
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }
}

