/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac.handlers;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.List;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import lombok.SneakyThrows;
import lombok.core.AnnotationValues;
import lombok.javac.JavacAnnotationHandler;
import lombok.javac.JavacNode;
import lombok.javac.handlers.JavacHandlerUtil;

public class HandleSneakyThrows
extends JavacAnnotationHandler<SneakyThrows> {
    @Override
    public void handle(AnnotationValues<SneakyThrows> annotation, JCTree.JCAnnotation ast, JavacNode annotationNode) {
        JavacHandlerUtil.deleteAnnotationIfNeccessary(annotationNode, SneakyThrows.class);
        Collection<String> exceptionNames = annotation.getRawExpressions("value");
        if (exceptionNames.isEmpty()) {
            exceptionNames = Collections.singleton("java.lang.Throwable");
        }
        ArrayList<String> exceptions = new ArrayList<String>();
        for (String exception : exceptionNames) {
            if (exception.endsWith(".class")) {
                exception = exception.substring(0, exception.length() - 6);
            }
            exceptions.add(exception);
        }
        JavacNode owner = (JavacNode)annotationNode.up();
        switch (owner.getKind()) {
            case METHOD: {
                this.handleMethod(annotationNode, (JCTree.JCMethodDecl)owner.get(), exceptions);
                break;
            }
            default: {
                annotationNode.addError("@SneakyThrows is legal only on methods and constructors.");
            }
        }
    }

    private void handleMethod(JavacNode annotation, JCTree.JCMethodDecl method, Collection<String> exceptions) {
        JavacNode methodNode = (JavacNode)annotation.up();
        if ((method.mods.flags & 0x400L) != 0L) {
            annotation.addError("@SneakyThrows can only be used on concrete methods.");
            return;
        }
        if (method.body == null) {
            return;
        }
        List<JCTree.JCStatement> contents = method.body.stats;
        for (String exception : exceptions) {
            contents = List.of(this.buildTryCatchBlock(methodNode, contents, exception, (JCTree)annotation.get()));
        }
        method.body.stats = contents;
        methodNode.rebuild();
    }

    private JCTree.JCStatement buildTryCatchBlock(JavacNode node, List<JCTree.JCStatement> contents, String exception, JCTree source) {
        TreeMaker maker = node.getTreeMaker();
        JCTree.JCBlock tryBlock = JavacHandlerUtil.setGeneratedBy(maker.Block(0L, contents), source);
        JCTree.JCExpression varType = JavacHandlerUtil.chainDots(node, exception.split("\\."));
        JCTree.JCVariableDecl catchParam = maker.VarDef(maker.Modifiers(16L), node.toName("$ex"), varType, null);
        JCTree.JCExpression lombokLombokSneakyThrowNameRef = JavacHandlerUtil.chainDots(node, "lombok", "Lombok", "sneakyThrow");
        JCTree.JCBlock catchBody = maker.Block(0L, List.of(maker.Throw(maker.Apply(List.<JCTree.JCExpression>nil(), lombokLombokSneakyThrowNameRef, List.of(maker.Ident(node.toName("$ex")))))));
        return JavacHandlerUtil.setGeneratedBy(maker.Try(tryBlock, List.of(JavacHandlerUtil.recursiveSetGeneratedBy(maker.Catch(catchParam, catchBody), source)), null), source);
    }
}

