/*
 * Decompiled with CFR 0.152.
 */
package lombok.eclipse.handlers;

import java.util.Arrays;
import lombok.NonNull;
import lombok.core.AST;
import lombok.core.AnnotationValues;
import lombok.eclipse.DeferUntilPostDiet;
import lombok.eclipse.Eclipse;
import lombok.eclipse.EclipseAnnotationHandler;
import lombok.eclipse.EclipseNode;
import lombok.eclipse.handlers.EclipseHandlerUtil;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.EqualExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.IfStatement;
import org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.ThrowStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DeferUntilPostDiet
public class NonNullHandler
extends EclipseAnnotationHandler<NonNull> {
    @Override
    public void handle(AnnotationValues<NonNull> annotation, Annotation ast, EclipseNode annotationNode) {
        AbstractMethodDeclaration declaration;
        Argument arg;
        if (((EclipseNode)annotationNode.up()).getKind() == AST.Kind.FIELD) {
            try {
                if (Eclipse.isPrimitive(((AbstractVariableDeclaration)((EclipseNode)annotationNode.up()).get()).type)) {
                    annotationNode.addWarning("@NonNull is meaningless on a primitive.");
                }
            }
            catch (Exception ignore) {
                // empty catch block
            }
            return;
        }
        if (((EclipseNode)annotationNode.up()).getKind() != AST.Kind.ARGUMENT) {
            return;
        }
        try {
            arg = (Argument)((EclipseNode)annotationNode.up()).get();
            declaration = (AbstractMethodDeclaration)((EclipseNode)((EclipseNode)annotationNode.up()).up()).get();
        }
        catch (Exception e) {
            return;
        }
        if (EclipseHandlerUtil.isGenerated((ASTNode)declaration)) {
            return;
        }
        Statement nullCheck = EclipseHandlerUtil.generateNullCheck((AbstractVariableDeclaration)arg, (ASTNode)ast);
        if (nullCheck == null) {
            annotationNode.addWarning("@NonNull is meaningless on a primitive.");
            return;
        }
        if (declaration.statements == null) {
            declaration.statements = new Statement[]{nullCheck};
        } else {
            Statement stat;
            char[] varNameOfNullCheck;
            char[] expectedName = arg.name;
            Statement[] arr$ = declaration.statements;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (varNameOfNullCheck = this.returnVarNameIfNullCheck(stat = arr$[i$])) != null; ++i$) {
                if (!Arrays.equals(expectedName, varNameOfNullCheck)) continue;
                return;
            }
            Statement[] newStatements = new Statement[declaration.statements.length + 1];
            int skipOver = 0;
            for (Statement stat2 : declaration.statements) {
                if (!EclipseHandlerUtil.isGenerated((ASTNode)stat2)) break;
                ++skipOver;
            }
            System.arraycopy(declaration.statements, 0, newStatements, 0, skipOver);
            System.arraycopy(declaration.statements, skipOver, newStatements, skipOver + 1, declaration.statements.length - skipOver);
            newStatements[skipOver] = nullCheck;
            declaration.statements = newStatements;
        }
        ((EclipseNode)((EclipseNode)annotationNode.up()).up()).rebuild();
    }

    private char[] returnVarNameIfNullCheck(Statement stat) {
        if (!(stat instanceof IfStatement)) {
            return null;
        }
        Statement then = ((IfStatement)stat).thenStatement;
        if (then instanceof Block) {
            Statement[] blockStatements = ((Block)then).statements;
            if (blockStatements == null || blockStatements.length == 0) {
                return null;
            }
            then = blockStatements[0];
        }
        if (!(then instanceof ThrowStatement)) {
            return null;
        }
        Expression cond = ((IfStatement)stat).condition;
        if (!(cond instanceof EqualExpression)) {
            return null;
        }
        EqualExpression bin = (EqualExpression)cond;
        int operatorId = (bin.bits & 0xFC0) >> 6;
        if (operatorId != 18) {
            return null;
        }
        if (!(bin.left instanceof SingleNameReference)) {
            return null;
        }
        if (!(bin.right instanceof NullLiteral)) {
            return null;
        }
        return ((SingleNameReference)bin.left).token;
    }
}

