/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac;

import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import lombok.javac.CommentInfo;
import lombok.javac.Javac;

public class CommentCatcher {
    private final JavaCompiler compiler;
    private final Map<JCTree.JCCompilationUnit, List<CommentInfo>> commentsMap;

    public static CommentCatcher create(Context context) {
        CommentCatcher.registerCommentsCollectingScannerFactory(context);
        JavaCompiler compiler = new JavaCompiler(context);
        WeakHashMap<JCTree.JCCompilationUnit, List<CommentInfo>> commentsMap = new WeakHashMap<JCTree.JCCompilationUnit, List<CommentInfo>>();
        CommentCatcher.setInCompiler(compiler, context, commentsMap);
        compiler.keepComments = true;
        compiler.genEndPos = true;
        return new CommentCatcher(compiler, commentsMap);
    }

    private CommentCatcher(JavaCompiler compiler, Map<JCTree.JCCompilationUnit, List<CommentInfo>> commentsMap) {
        this.compiler = compiler;
        this.commentsMap = commentsMap;
    }

    public JavaCompiler getCompiler() {
        return this.compiler;
    }

    public List<CommentInfo> getComments(JCTree.JCCompilationUnit ast) {
        List<CommentInfo> list = this.commentsMap.get(ast);
        return list == null ? List.nil() : list;
    }

    private static void registerCommentsCollectingScannerFactory(Context context) {
        try {
            if (Javac.getJavaCompilerVersion() <= 6) {
                Class.forName("lombok.javac.java6.CommentCollectingScannerFactory").getMethod("preRegister", Context.class).invoke(null, context);
            } else {
                Class.forName("lombok.javac.java7.CommentCollectingScannerFactory").getMethod("preRegister", Context.class).invoke(null, context);
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private static void setInCompiler(JavaCompiler compiler, Context context, Map<JCTree.JCCompilationUnit, List<CommentInfo>> commentsMap) {
        try {
            if (Javac.getJavaCompilerVersion() <= 6) {
                Class<?> parserFactory = Class.forName("lombok.javac.java6.CommentCollectingParserFactory");
                parserFactory.getMethod("setInCompiler", JavaCompiler.class, Context.class, Map.class).invoke(null, compiler, context, commentsMap);
            } else {
                Class<?> parserFactory = Class.forName("lombok.javac.java7.CommentCollectingParserFactory");
                parserFactory.getMethod("setInCompiler", JavaCompiler.class, Context.class, Map.class).invoke(null, compiler, context, commentsMap);
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }
}

