/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac;

import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.TypeTags;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Javac {
    private static final Pattern PRIMITIVE_TYPE_NAME_PATTERN = Pattern.compile("^(boolean|byte|short|int|long|float|double|char)$");
    private static final Pattern VERSION_PARSER = Pattern.compile("^(\\d{1,6})\\.(\\d{1,6}).*$");
    public static final int CTC_BOOLEAN = Javac.getCtcInt(TypeTags.class, "BOOLEAN");
    public static final int CTC_INT = Javac.getCtcInt(TypeTags.class, "INT");
    public static final int CTC_DOUBLE = Javac.getCtcInt(TypeTags.class, "DOUBLE");
    public static final int CTC_FLOAT = Javac.getCtcInt(TypeTags.class, "FLOAT");
    public static final int CTC_SHORT = Javac.getCtcInt(TypeTags.class, "SHORT");
    public static final int CTC_BYTE = Javac.getCtcInt(TypeTags.class, "BYTE");
    public static final int CTC_LONG = Javac.getCtcInt(TypeTags.class, "LONG");
    public static final int CTC_CHAR = Javac.getCtcInt(TypeTags.class, "CHAR");
    public static final int CTC_VOID = Javac.getCtcInt(TypeTags.class, "VOID");
    public static final int CTC_NONE = Javac.getCtcInt(TypeTags.class, "NONE");
    public static final int CTC_NOT_EQUAL = Javac.getCtcInt(JCTree.class, "NE");
    public static final int CTC_NOT = Javac.getCtcInt(JCTree.class, "NOT");
    public static final int CTC_BITXOR = Javac.getCtcInt(JCTree.class, "BITXOR");
    public static final int CTC_UNSIGNED_SHIFT_RIGHT = Javac.getCtcInt(JCTree.class, "USR");
    public static final int CTC_MUL = Javac.getCtcInt(JCTree.class, "MUL");
    public static final int CTC_PLUS = Javac.getCtcInt(JCTree.class, "PLUS");
    public static final int CTC_BOT = Javac.getCtcInt(TypeTags.class, "BOT");
    public static final int CTC_EQUAL = Javac.getCtcInt(JCTree.class, "EQ");
    private static final Field JCTREE_TAG;
    private static final Method JCTREE_GETTAG;
    private static Method method;

    private Javac() {
    }

    public static int getJavaCompilerVersion() {
        Matcher m = VERSION_PARSER.matcher(JavaCompiler.version());
        if (m.matches()) {
            int major = Integer.parseInt(m.group(1));
            int minor = Integer.parseInt(m.group(2));
            if (major == 1) {
                return minor;
            }
        }
        return 6;
    }

    public static boolean isPrimitive(JCTree.JCExpression ref) {
        String typeName = ref.toString();
        return PRIMITIVE_TYPE_NAME_PATTERN.matcher(typeName).matches();
    }

    public static Object calculateGuess(JCTree.JCExpression expr) {
        if (expr instanceof JCTree.JCLiteral) {
            JCTree.JCLiteral lit = (JCTree.JCLiteral)expr;
            if (lit.getKind() == Tree.Kind.BOOLEAN_LITERAL) {
                return ((Number)lit.value).intValue() != 0;
            }
            return lit.value;
        }
        if (expr instanceof JCTree.JCIdent || expr instanceof JCTree.JCFieldAccess) {
            String x = expr.toString();
            if (x.endsWith(".class")) {
                x = x.substring(0, x.length() - 6);
            } else {
                int idx = x.lastIndexOf(46);
                if (idx > -1) {
                    x = x.substring(idx + 1);
                }
            }
            return x;
        }
        return null;
    }

    public static int getCtcInt(Class<?> ctcLocation, String identifier) {
        try {
            return (Integer)ctcLocation.getField(identifier).get(null);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static int getTag(JCTree node) {
        if (JCTREE_GETTAG != null) {
            try {
                return (Integer)JCTREE_GETTAG.invoke((Object)node, new Object[0]);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            return (Integer)JCTREE_TAG.get(node);
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't get node tag");
        }
    }

    public static JCTree.JCClassDecl ClassDef(TreeMaker maker, JCTree.JCModifiers mods, Name name, List<JCTree.JCTypeParameter> typarams, JCTree.JCExpression extending, List<JCTree.JCExpression> implementing, List<JCTree> defs) {
        if (method == null) {
            try {
                method = TreeMaker.class.getDeclaredMethod("ClassDef", JCTree.JCModifiers.class, Name.class, List.class, JCTree.JCExpression.class, List.class, List.class);
            }
            catch (NoSuchMethodException ignore) {
                // empty catch block
            }
        }
        if (method == null) {
            try {
                method = TreeMaker.class.getDeclaredMethod("ClassDef", JCTree.JCModifiers.class, Name.class, List.class, JCTree.class, List.class, List.class);
            }
            catch (NoSuchMethodException ignore) {
                // empty catch block
            }
        }
        if (method == null) {
            throw new IllegalStateException("Lombok bug #20130617-1310: ClassDef doesn't look like anything we thought it would look like.");
        }
        if (!Modifier.isPublic(method.getModifiers()) && !method.isAccessible()) {
            method.setAccessible(true);
        }
        try {
            return (JCTree.JCClassDecl)method.invoke((Object)maker, mods, name, typarams, extending, implementing, defs);
        }
        catch (InvocationTargetException e) {
            throw Javac.sneakyThrow(e.getCause());
        }
        catch (IllegalAccessException e) {
            throw Javac.sneakyThrow(e.getCause());
        }
    }

    private static RuntimeException sneakyThrow(Throwable t) {
        if (t == null) {
            throw new NullPointerException("t");
        }
        Javac.sneakyThrow0(t);
        return null;
    }

    private static <T extends Throwable> void sneakyThrow0(Throwable t) throws T {
        throw t;
    }

    static {
        Field f = null;
        try {
            f = JCTree.class.getDeclaredField("tag");
        }
        catch (NoSuchFieldException e) {
            // empty catch block
        }
        JCTREE_TAG = f;
        Method m = null;
        try {
            m = JCTree.class.getDeclaredMethod("getTag", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        JCTREE_GETTAG = m;
    }
}

