/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac.handlers;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.NoArgsConstructor;
import lombok.RequiredArgsConstructor;
import lombok.core.AST;
import lombok.core.AnnotationValues;
import lombok.core.TransformationsUtil;
import lombok.experimental.Builder;
import lombok.javac.JavacAnnotationHandler;
import lombok.javac.JavacNode;
import lombok.javac.handlers.JavacHandlerUtil;

public class HandleConstructor {
    private static List<JavacNode> findRequiredFields(JavacNode typeNode) {
        ListBuffer fields = ListBuffer.lb();
        for (JavacNode child : typeNode.down()) {
            boolean isNonNull;
            long fieldFlags;
            if (child.getKind() != AST.Kind.FIELD) continue;
            JCTree.JCVariableDecl fieldDecl = (JCTree.JCVariableDecl)child.get();
            if (fieldDecl.name.toString().startsWith("$") || ((fieldFlags = fieldDecl.mods.flags) & 8L) != 0L) continue;
            boolean isFinal = (fieldFlags & 0x10L) != 0L;
            boolean bl = isNonNull = !JavacHandlerUtil.findAnnotations(child, TransformationsUtil.NON_NULL_PATTERN).isEmpty();
            if (!isFinal && !isNonNull || fieldDecl.init != null) continue;
            fields.append(child);
        }
        return fields.toList();
    }

    static List<JavacNode> findAllFields(JavacNode typeNode) {
        ListBuffer fields = ListBuffer.lb();
        for (JavacNode child : typeNode.down()) {
            boolean isFinal;
            long fieldFlags;
            if (child.getKind() != AST.Kind.FIELD) continue;
            JCTree.JCVariableDecl fieldDecl = (JCTree.JCVariableDecl)child.get();
            if (fieldDecl.name.toString().startsWith("$") || ((fieldFlags = fieldDecl.mods.flags) & 8L) != 0L) continue;
            boolean bl = isFinal = (fieldFlags & 0x10L) != 0L;
            if (isFinal && fieldDecl.init != null) continue;
            fields.append(child);
        }
        return fields.toList();
    }

    static boolean checkLegality(JavacNode typeNode, JavacNode errorNode, String name) {
        boolean notAClass;
        JCTree.JCClassDecl typeDecl = null;
        if (typeNode.get() instanceof JCTree.JCClassDecl) {
            typeDecl = (JCTree.JCClassDecl)typeNode.get();
        }
        long modifiers = typeDecl == null ? 0L : typeDecl.mods.flags;
        boolean bl = notAClass = (modifiers & 0x2200L) != 0L;
        if (typeDecl == null || notAClass) {
            errorNode.addError(name + " is only supported on a class or an enum.");
            return false;
        }
        return true;
    }

    public void generateRequiredArgsConstructor(JavacNode typeNode, AccessLevel level, String staticName, SkipIfConstructorExists skipIfConstructorExists, JavacNode source) {
        this.generateConstructor(typeNode, level, List.<JCTree.JCAnnotation>nil(), HandleConstructor.findRequiredFields(typeNode), staticName, skipIfConstructorExists, false, source);
    }

    public void generateAllArgsConstructor(JavacNode typeNode, AccessLevel level, String staticName, SkipIfConstructorExists skipIfConstructorExists, JavacNode source) {
        this.generateConstructor(typeNode, level, List.<JCTree.JCAnnotation>nil(), HandleConstructor.findAllFields(typeNode), staticName, skipIfConstructorExists, false, source);
    }

    public void generateConstructor(JavacNode typeNode, AccessLevel level, List<JCTree.JCAnnotation> onConstructor, List<JavacNode> fields, String staticName, SkipIfConstructorExists skipIfConstructorExists, boolean suppressConstructorProperties, JavacNode source) {
        boolean staticConstrRequired;
        boolean bl = staticConstrRequired = staticName != null && !staticName.equals("");
        if (skipIfConstructorExists != SkipIfConstructorExists.NO && JavacHandlerUtil.constructorExists(typeNode) != JavacHandlerUtil.MemberExistsResult.NOT_EXISTS) {
            return;
        }
        if (skipIfConstructorExists != SkipIfConstructorExists.NO) {
            for (JavacNode child : typeNode.down()) {
                boolean skipGeneration;
                if (child.getKind() != AST.Kind.ANNOTATION) continue;
                boolean bl2 = skipGeneration = JavacHandlerUtil.annotationTypeMatches(NoArgsConstructor.class, child) || JavacHandlerUtil.annotationTypeMatches(AllArgsConstructor.class, child) || JavacHandlerUtil.annotationTypeMatches(RequiredArgsConstructor.class, child);
                if (!skipGeneration && skipIfConstructorExists == SkipIfConstructorExists.YES) {
                    skipGeneration = JavacHandlerUtil.annotationTypeMatches(Builder.class, child);
                }
                if (!skipGeneration) continue;
                if (staticConstrRequired) {
                    source.addWarning("Ignoring static constructor name: explicit @XxxArgsConstructor annotation present; its `staticName` parameter will be used.");
                }
                return;
            }
        }
        JCTree.JCMethodDecl constr = HandleConstructor.createConstructor(staticConstrRequired ? AccessLevel.PRIVATE : level, onConstructor, typeNode, fields, suppressConstructorProperties, (JCTree)source.get());
        JavacHandlerUtil.injectMethod(typeNode, constr);
        if (staticConstrRequired) {
            JCTree.JCMethodDecl staticConstr = this.createStaticConstructor(staticName, level, typeNode, fields, (JCTree)source.get());
            JavacHandlerUtil.injectMethod(typeNode, staticConstr);
        }
    }

    private static void addConstructorProperties(JCTree.JCModifiers mods, JavacNode node, List<JavacNode> fields) {
        if (fields.isEmpty()) {
            return;
        }
        TreeMaker maker = node.getTreeMaker();
        JCTree.JCExpression constructorPropertiesType = JavacHandlerUtil.chainDots(node, "java", "beans", "ConstructorProperties");
        ListBuffer fieldNames = ListBuffer.lb();
        for (JavacNode field : fields) {
            fieldNames.append(maker.Literal(field.getName()));
        }
        JCTree.JCNewArray fieldNamesArray = maker.NewArray(null, List.<JCTree.JCExpression>nil(), fieldNames.toList());
        JCTree.JCAnnotation annotation = maker.Annotation(constructorPropertiesType, List.of(fieldNamesArray));
        mods.annotations = mods.annotations.append(annotation);
    }

    static JCTree.JCMethodDecl createConstructor(AccessLevel level, List<JCTree.JCAnnotation> onConstructor, JavacNode typeNode, List<JavacNode> fields, boolean suppressConstructorProperties, JCTree source) {
        boolean isEnum;
        TreeMaker maker = typeNode.getTreeMaker();
        boolean bl = isEnum = (((JCTree.JCClassDecl)typeNode.get()).mods.flags & 0x4000L) != 0L;
        if (isEnum) {
            level = AccessLevel.PRIVATE;
        }
        ListBuffer nullChecks = ListBuffer.lb();
        ListBuffer assigns = ListBuffer.lb();
        ListBuffer params = ListBuffer.lb();
        for (JavacNode fieldNode : fields) {
            JCTree.JCStatement nullCheck;
            JCTree.JCVariableDecl field = (JCTree.JCVariableDecl)fieldNode.get();
            List<JCTree.JCAnnotation> nonNulls = JavacHandlerUtil.findAnnotations(fieldNode, TransformationsUtil.NON_NULL_PATTERN);
            List<JCTree.JCAnnotation> nullables = JavacHandlerUtil.findAnnotations(fieldNode, TransformationsUtil.NULLABLE_PATTERN);
            JCTree.JCVariableDecl param = maker.VarDef(maker.Modifiers(16L, nonNulls.appendList(nullables)), field.name, field.vartype, null);
            params.append(param);
            JCTree.JCFieldAccess thisX = maker.Select((JCTree.JCExpression)maker.Ident(fieldNode.toName("this")), field.name);
            JCTree.JCAssign assign = maker.Assign(thisX, maker.Ident(field.name));
            assigns.append(maker.Exec(assign));
            if (nonNulls.isEmpty() || (nullCheck = JavacHandlerUtil.generateNullCheck(maker, fieldNode)) == null) continue;
            nullChecks.append(nullCheck);
        }
        JCTree.JCModifiers mods = maker.Modifiers(JavacHandlerUtil.toJavacModifier(level), List.<JCTree.JCAnnotation>nil());
        if (!suppressConstructorProperties && level != AccessLevel.PRIVATE && !HandleConstructor.isLocalType(typeNode)) {
            HandleConstructor.addConstructorProperties(mods, typeNode, fields);
        }
        if (onConstructor != null) {
            mods.annotations = mods.annotations.appendList(JavacHandlerUtil.copyAnnotations(onConstructor));
        }
        return JavacHandlerUtil.recursiveSetGeneratedBy(maker.MethodDef(mods, typeNode.toName("<init>"), null, List.<JCTree.JCTypeParameter>nil(), params.toList(), List.<JCTree.JCExpression>nil(), maker.Block(0L, nullChecks.appendList(assigns).toList()), null), source);
    }

    private static boolean isLocalType(JavacNode type) {
        AST.Kind kind = ((JavacNode)type.up()).getKind();
        if (kind == AST.Kind.COMPILATION_UNIT) {
            return false;
        }
        if (kind == AST.Kind.TYPE) {
            return HandleConstructor.isLocalType((JavacNode)type.up());
        }
        return true;
    }

    private JCTree.JCMethodDecl createStaticConstructor(String name, AccessLevel level, JavacNode typeNode, List<JavacNode> fields, JCTree source) {
        JCTree.JCExpression constructorType;
        JCTree.JCExpression returnType;
        TreeMaker maker = typeNode.getTreeMaker();
        JCTree.JCClassDecl type = (JCTree.JCClassDecl)typeNode.get();
        JCTree.JCModifiers mods = maker.Modifiers(8 | JavacHandlerUtil.toJavacModifier(level));
        ListBuffer typeParams = ListBuffer.lb();
        ListBuffer params = ListBuffer.lb();
        ListBuffer typeArgs1 = ListBuffer.lb();
        ListBuffer typeArgs2 = ListBuffer.lb();
        ListBuffer args = ListBuffer.lb();
        if (!type.typarams.isEmpty()) {
            for (JCTree.JCTypeParameter param : type.typarams) {
                typeArgs1.append(maker.Ident(param.name));
                typeArgs2.append(maker.Ident(param.name));
                typeParams.append(maker.TypeParameter(param.name, param.bounds));
            }
            returnType = maker.TypeApply(maker.Ident(type.name), typeArgs1.toList());
            constructorType = maker.TypeApply(maker.Ident(type.name), typeArgs2.toList());
        } else {
            returnType = maker.Ident(type.name);
            constructorType = maker.Ident(type.name);
        }
        for (JavacNode fieldNode : fields) {
            JCTree.JCVariableDecl field = (JCTree.JCVariableDecl)fieldNode.get();
            JCTree.JCExpression pType = JavacHandlerUtil.cloneType(maker, field.vartype, source);
            List<JCTree.JCAnnotation> nonNulls = JavacHandlerUtil.findAnnotations(fieldNode, TransformationsUtil.NON_NULL_PATTERN);
            List<JCTree.JCAnnotation> nullables = JavacHandlerUtil.findAnnotations(fieldNode, TransformationsUtil.NULLABLE_PATTERN);
            JCTree.JCVariableDecl param = maker.VarDef(maker.Modifiers(16L, nonNulls.appendList(nullables)), field.name, pType, null);
            params.append(param);
            args.append(maker.Ident(field.name));
        }
        JCTree.JCReturn returnStatement = maker.Return(maker.NewClass(null, List.<JCTree.JCExpression>nil(), constructorType, args.toList(), null));
        JCTree.JCBlock body = maker.Block(0L, List.of(returnStatement));
        return JavacHandlerUtil.recursiveSetGeneratedBy(maker.MethodDef(mods, typeNode.toName(name), returnType, typeParams.toList(), params.toList(), List.<JCTree.JCExpression>nil(), body, null), source);
    }

    public static enum SkipIfConstructorExists {
        YES,
        NO,
        I_AM_BUILDER;

    }

    public static class HandleAllArgsConstructor
    extends JavacAnnotationHandler<AllArgsConstructor> {
        @Override
        public void handle(AnnotationValues<AllArgsConstructor> annotation, JCTree.JCAnnotation ast, JavacNode annotationNode) {
            JavacHandlerUtil.deleteAnnotationIfNeccessary(annotationNode, AllArgsConstructor.class);
            JavacHandlerUtil.deleteImportFromCompilationUnit(annotationNode, "lombok.AccessLevel");
            JavacNode typeNode = (JavacNode)annotationNode.up();
            if (!HandleConstructor.checkLegality(typeNode, annotationNode, AllArgsConstructor.class.getSimpleName())) {
                return;
            }
            List<JCTree.JCAnnotation> onConstructor = JavacHandlerUtil.unboxAndRemoveAnnotationParameter(ast, "onConstructor", "@AllArgsConstructor(onConstructor=", annotationNode);
            AllArgsConstructor ann = annotation.getInstance();
            AccessLevel level = ann.access();
            String staticName = ann.staticName();
            boolean suppressConstructorProperties = ann.suppressConstructorProperties();
            if (level == AccessLevel.NONE) {
                return;
            }
            new HandleConstructor().generateConstructor(typeNode, level, onConstructor, HandleConstructor.findAllFields(typeNode), staticName, SkipIfConstructorExists.NO, suppressConstructorProperties, annotationNode);
        }
    }

    public static class HandleRequiredArgsConstructor
    extends JavacAnnotationHandler<RequiredArgsConstructor> {
        @Override
        public void handle(AnnotationValues<RequiredArgsConstructor> annotation, JCTree.JCAnnotation ast, JavacNode annotationNode) {
            JavacHandlerUtil.deleteAnnotationIfNeccessary(annotationNode, RequiredArgsConstructor.class);
            JavacHandlerUtil.deleteImportFromCompilationUnit(annotationNode, "lombok.AccessLevel");
            JavacNode typeNode = (JavacNode)annotationNode.up();
            if (!HandleConstructor.checkLegality(typeNode, annotationNode, RequiredArgsConstructor.class.getSimpleName())) {
                return;
            }
            List<JCTree.JCAnnotation> onConstructor = JavacHandlerUtil.unboxAndRemoveAnnotationParameter(ast, "onConstructor", "@RequiredArgsConstructor(onConstructor=", annotationNode);
            RequiredArgsConstructor ann = annotation.getInstance();
            AccessLevel level = ann.access();
            String staticName = ann.staticName();
            boolean suppressConstructorProperties = ann.suppressConstructorProperties();
            if (level == AccessLevel.NONE) {
                return;
            }
            new HandleConstructor().generateConstructor(typeNode, level, onConstructor, HandleConstructor.findRequiredFields(typeNode), staticName, SkipIfConstructorExists.NO, suppressConstructorProperties, annotationNode);
        }
    }

    public static class HandleNoArgsConstructor
    extends JavacAnnotationHandler<NoArgsConstructor> {
        @Override
        public void handle(AnnotationValues<NoArgsConstructor> annotation, JCTree.JCAnnotation ast, JavacNode annotationNode) {
            JavacHandlerUtil.deleteAnnotationIfNeccessary(annotationNode, NoArgsConstructor.class);
            JavacHandlerUtil.deleteImportFromCompilationUnit(annotationNode, "lombok.AccessLevel");
            JavacNode typeNode = (JavacNode)annotationNode.up();
            if (!HandleConstructor.checkLegality(typeNode, annotationNode, NoArgsConstructor.class.getSimpleName())) {
                return;
            }
            List<JCTree.JCAnnotation> onConstructor = JavacHandlerUtil.unboxAndRemoveAnnotationParameter(ast, "onConstructor", "@NoArgsConstructor(onConstructor=", annotationNode);
            NoArgsConstructor ann = annotation.getInstance();
            AccessLevel level = ann.access();
            String staticName = ann.staticName();
            if (level == AccessLevel.NONE) {
                return;
            }
            List<JavacNode> fields = List.nil();
            new HandleConstructor().generateConstructor(typeNode, level, onConstructor, fields, staticName, SkipIfConstructorExists.NO, false, annotationNode);
        }
    }
}

