/*
 * Decompiled with CFR 0.152.
 */
package lombok.eclipse;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import lombok.core.AST;
import lombok.core.AnnotationValues;
import lombok.core.TypeLibrary;
import lombok.core.TypeResolver;
import lombok.eclipse.EclipseAST;
import lombok.eclipse.EclipseNode;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ClassLiteralAccess;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Literal;
import org.eclipse.jdt.internal.compiler.ast.MarkerAnnotation;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.ast.NormalAnnotation;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.SingleMemberAnnotation;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.Wildcard;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Eclipse {
    public static final int ECLIPSE_DO_NOT_TOUCH_FLAG = 0x800000;
    private static final String DEFAULT_BUNDLE = "org.eclipse.jdt.core";
    private static Field generatedByField;

    private Eclipse() {
    }

    public static void error(CompilationUnitDeclaration cud, String message) {
        Eclipse.error(cud, message, DEFAULT_BUNDLE, null);
    }

    public static void error(CompilationUnitDeclaration cud, String message, Throwable error) {
        Eclipse.error(cud, message, DEFAULT_BUNDLE, error);
    }

    public static void error(CompilationUnitDeclaration cud, String message, String bundleName) {
        Eclipse.error(cud, message, bundleName, null);
    }

    public static void error(CompilationUnitDeclaration cud, String message, String bundleName, Throwable error) {
        try {
            new EclipseWorkspaceLogger().error(message, bundleName, error);
        }
        catch (NoClassDefFoundError e) {
            new TerminalLogger().error(message, bundleName, error);
        }
        if (cud != null) {
            EclipseAST.addProblemToCompilationResult(cud, false, message + " - See error log.", 0, 0);
        }
    }

    public static String toQualifiedName(char[][] typeName) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (char[] c : typeName) {
            sb.append(first ? "" : ".").append(c);
            first = false;
        }
        return sb.toString();
    }

    public static char[][] fromQualifiedName(String typeName) {
        String[] split = typeName.split("\\.");
        char[][] result = new char[split.length][];
        for (int i = 0; i < split.length; ++i) {
            result[i] = split[i].toCharArray();
        }
        return result;
    }

    public static TypeParameter[] copyTypeParams(TypeParameter[] params, ASTNode source) {
        if (params == null) {
            return null;
        }
        TypeParameter[] out = new TypeParameter[params.length];
        int idx = 0;
        for (TypeParameter param : params) {
            TypeParameter o = new TypeParameter();
            Eclipse.setGeneratedBy((ASTNode)o, source);
            o.annotations = param.annotations;
            o.bits = param.bits;
            o.modifiers = param.modifiers;
            o.name = param.name;
            o.type = Eclipse.copyType(param.type, source);
            o.sourceStart = param.sourceStart;
            o.sourceEnd = param.sourceEnd;
            o.declarationEnd = param.declarationEnd;
            o.declarationSourceStart = param.declarationSourceStart;
            o.declarationSourceEnd = param.declarationSourceEnd;
            if (param.bounds != null) {
                TypeReference[] b = new TypeReference[param.bounds.length];
                int idx2 = 0;
                for (TypeReference ref : param.bounds) {
                    b[idx2++] = Eclipse.copyType(ref, source);
                }
                o.bounds = b;
            }
            out[idx++] = o;
        }
        return out;
    }

    public static TypeReference[] copyTypes(TypeReference[] refs, ASTNode source) {
        if (refs == null) {
            return null;
        }
        TypeReference[] outs = new TypeReference[refs.length];
        int idx = 0;
        for (TypeReference ref : refs) {
            outs[idx++] = Eclipse.copyType(ref, source);
        }
        return outs;
    }

    public static TypeReference copyType(TypeReference ref, ASTNode source) {
        if (ref instanceof ParameterizedQualifiedTypeReference) {
            ParameterizedQualifiedTypeReference iRef = (ParameterizedQualifiedTypeReference)ref;
            TypeReference[][] args = null;
            if (iRef.typeArguments != null) {
                args = new TypeReference[iRef.typeArguments.length][];
                int idx = 0;
                for (TypeReference[] inRefArray : iRef.typeArguments) {
                    if (inRefArray == null) {
                        args[idx++] = null;
                        continue;
                    }
                    TypeReference[] outRefArray = new TypeReference[inRefArray.length];
                    int idx2 = 0;
                    for (TypeReference inRef : inRefArray) {
                        outRefArray[idx2++] = Eclipse.copyType(inRef, source);
                    }
                    args[idx++] = outRefArray;
                }
            }
            ParameterizedQualifiedTypeReference typeRef = new ParameterizedQualifiedTypeReference(iRef.tokens, args, iRef.dimensions(), iRef.sourcePositions);
            Eclipse.setGeneratedBy((ASTNode)typeRef, source);
            return typeRef;
        }
        if (ref instanceof ArrayQualifiedTypeReference) {
            ArrayQualifiedTypeReference iRef = (ArrayQualifiedTypeReference)ref;
            ArrayQualifiedTypeReference typeRef = new ArrayQualifiedTypeReference(iRef.tokens, iRef.dimensions(), iRef.sourcePositions);
            Eclipse.setGeneratedBy((ASTNode)typeRef, source);
            return typeRef;
        }
        if (ref instanceof QualifiedTypeReference) {
            QualifiedTypeReference iRef = (QualifiedTypeReference)ref;
            QualifiedTypeReference typeRef = new QualifiedTypeReference(iRef.tokens, iRef.sourcePositions);
            Eclipse.setGeneratedBy((ASTNode)typeRef, source);
            return typeRef;
        }
        if (ref instanceof ParameterizedSingleTypeReference) {
            ParameterizedSingleTypeReference iRef = (ParameterizedSingleTypeReference)ref;
            TypeReference[] args = null;
            if (iRef.typeArguments != null) {
                args = new TypeReference[iRef.typeArguments.length];
                int idx = 0;
                for (TypeReference inRef : iRef.typeArguments) {
                    args[idx++] = inRef == null ? null : Eclipse.copyType(inRef, source);
                }
            }
            ParameterizedSingleTypeReference typeRef = new ParameterizedSingleTypeReference(iRef.token, args, iRef.dimensions(), (long)iRef.sourceStart << 32 | (long)iRef.sourceEnd);
            Eclipse.setGeneratedBy((ASTNode)typeRef, source);
            return typeRef;
        }
        if (ref instanceof ArrayTypeReference) {
            ArrayTypeReference iRef = (ArrayTypeReference)ref;
            ArrayTypeReference typeRef = new ArrayTypeReference(iRef.token, iRef.dimensions(), (long)iRef.sourceStart << 32 | (long)iRef.sourceEnd);
            Eclipse.setGeneratedBy((ASTNode)typeRef, source);
            return typeRef;
        }
        if (ref instanceof Wildcard) {
            Wildcard original = (Wildcard)ref;
            Wildcard wildcard = new Wildcard(original.kind);
            wildcard.sourceStart = original.sourceStart;
            wildcard.sourceEnd = original.sourceEnd;
            if (original.bound != null) {
                wildcard.bound = Eclipse.copyType(original.bound, source);
            }
            Eclipse.setGeneratedBy((ASTNode)wildcard, source);
            return wildcard;
        }
        if (ref instanceof SingleTypeReference) {
            SingleTypeReference iRef = (SingleTypeReference)ref;
            SingleTypeReference typeRef = new SingleTypeReference(iRef.token, (long)iRef.sourceStart << 32 | (long)iRef.sourceEnd);
            Eclipse.setGeneratedBy((ASTNode)typeRef, source);
            return typeRef;
        }
        return ref;
    }

    public static Annotation[] copyAnnotations(Annotation[] annotations, ASTNode source) {
        return Eclipse.copyAnnotations(annotations, null, source);
    }

    public static Annotation[] copyAnnotations(Annotation[] annotations1, Annotation[] annotations2, ASTNode source) {
        if (annotations1 == null && annotations2 == null) {
            return null;
        }
        if (annotations1 == null) {
            annotations1 = new Annotation[]{};
        }
        if (annotations2 == null) {
            annotations2 = new Annotation[]{};
        }
        Annotation[] outs = new Annotation[annotations1.length + annotations2.length];
        int idx = 0;
        for (Annotation annotation : annotations1) {
            outs[idx++] = Eclipse.copyAnnotation(annotation, source);
        }
        for (Annotation annotation : annotations2) {
            outs[idx++] = Eclipse.copyAnnotation(annotation, source);
        }
        return outs;
    }

    public static Annotation copyAnnotation(Annotation annotation, ASTNode source) {
        int pS = source.sourceStart;
        int pE = source.sourceEnd;
        if (annotation instanceof MarkerAnnotation) {
            MarkerAnnotation ann = new MarkerAnnotation(Eclipse.copyType(annotation.type, source), pS);
            Eclipse.setGeneratedBy((ASTNode)ann, source);
            ann.sourceEnd = ann.statementEnd = pE;
            ann.declarationSourceEnd = ann.statementEnd;
            return ann;
        }
        if (annotation instanceof SingleMemberAnnotation) {
            SingleMemberAnnotation ann = new SingleMemberAnnotation(Eclipse.copyType(annotation.type, source), pS);
            Eclipse.setGeneratedBy((ASTNode)ann, source);
            ann.sourceEnd = ann.statementEnd = pE;
            ann.declarationSourceEnd = ann.statementEnd;
            ann.memberValue = ((SingleMemberAnnotation)annotation).memberValue;
            return ann;
        }
        if (annotation instanceof NormalAnnotation) {
            NormalAnnotation ann = new NormalAnnotation(Eclipse.copyType(annotation.type, source), pS);
            Eclipse.setGeneratedBy((ASTNode)ann, source);
            ann.statementEnd = ann.sourceEnd = pE;
            ann.declarationSourceEnd = ann.sourceEnd;
            ann.memberValuePairs = ((NormalAnnotation)annotation).memberValuePairs;
            return ann;
        }
        return annotation;
    }

    public static boolean annotationTypeMatches(Class<? extends java.lang.annotation.Annotation> type, EclipseNode node) {
        if (node.getKind() != AST.Kind.ANNOTATION) {
            return false;
        }
        TypeReference typeRef = ((Annotation)node.get()).type;
        if (typeRef == null || typeRef.getTypeName() == null) {
            return false;
        }
        String typeName = Eclipse.toQualifiedName(typeRef.getTypeName());
        TypeLibrary library = new TypeLibrary();
        library.addType(type.getName());
        TypeResolver resolver = new TypeResolver(library, node.getPackageDeclaration(), node.getImportStatements());
        Collection<String> typeMatches = resolver.findTypeMatches(node, typeName);
        for (String match : typeMatches) {
            if (!match.equals(type.getName())) continue;
            return true;
        }
        return false;
    }

    public static <A extends java.lang.annotation.Annotation> AnnotationValues<A> createAnnotation(Class<A> type, final EclipseNode annotationNode) {
        final Annotation annotation = (Annotation)annotationNode.get();
        HashMap<String, AnnotationValues.AnnotationValue> values = new HashMap<String, AnnotationValues.AnnotationValue>();
        MemberValuePair[] pairs = annotation.memberValuePairs();
        for (Method m : type.getDeclaredMethods()) {
            boolean isExplicit;
            if (!Modifier.isPublic(m.getModifiers())) continue;
            String name = m.getName();
            ArrayList<String> raws = new ArrayList<String>();
            ArrayList<Object> guesses = new ArrayList<Object>();
            Expression fullExpression = null;
            Expression[] expressions = null;
            if (pairs != null) {
                for (MemberValuePair pair : pairs) {
                    String mName;
                    char[] n = pair.name;
                    String string = mName = n == null ? "value" : new String(pair.name);
                    if (!mName.equals(name)) continue;
                    fullExpression = pair.value;
                }
            }
            boolean bl = isExplicit = fullExpression != null;
            if (isExplicit && (expressions = fullExpression instanceof ArrayInitializer ? ((ArrayInitializer)fullExpression).expressions : new Expression[]{fullExpression}) != null) {
                for (Expression ex : expressions) {
                    StringBuffer sb = new StringBuffer();
                    ex.print(0, sb);
                    raws.add(sb.toString());
                    guesses.add(Eclipse.calculateValue(ex));
                }
            }
            final Expression fullExpr = fullExpression;
            final Expression[] exprs = expressions;
            values.put(name, new AnnotationValues.AnnotationValue(annotationNode, raws, guesses, isExplicit){

                public void setError(String message, int valueIdx) {
                    Expression ex;
                    if (valueIdx == -1) {
                        ex = fullExpr;
                    } else {
                        Expression expression = ex = exprs != null ? exprs[valueIdx] : null;
                    }
                    if (ex == null) {
                        ex = annotation;
                    }
                    int sourceStart = ex.sourceStart;
                    int sourceEnd = ex.sourceEnd;
                    annotationNode.addError(message, sourceStart, sourceEnd);
                }

                public void setWarning(String message, int valueIdx) {
                    Expression ex;
                    if (valueIdx == -1) {
                        ex = fullExpr;
                    } else {
                        Expression expression = ex = exprs != null ? exprs[valueIdx] : null;
                    }
                    if (ex == null) {
                        ex = annotation;
                    }
                    int sourceStart = ex.sourceStart;
                    int sourceEnd = ex.sourceEnd;
                    annotationNode.addWarning(message, sourceStart, sourceEnd);
                }
            });
        }
        return new AnnotationValues<A>(type, values, annotationNode);
    }

    private static Object calculateValue(Expression e) {
        if (e instanceof Literal) {
            ((Literal)e).computeConstant();
            switch (e.constant.typeID()) {
                case 10: {
                    return e.constant.intValue();
                }
                case 3: {
                    return e.constant.byteValue();
                }
                case 4: {
                    return e.constant.shortValue();
                }
                case 2: {
                    return Character.valueOf(e.constant.charValue());
                }
                case 9: {
                    return Float.valueOf(e.constant.floatValue());
                }
                case 8: {
                    return e.constant.doubleValue();
                }
                case 5: {
                    return e.constant.booleanValue();
                }
                case 7: {
                    return e.constant.longValue();
                }
                case 11: {
                    return e.constant.stringValue();
                }
            }
            return null;
        }
        if (e instanceof ClassLiteralAccess) {
            return Eclipse.toQualifiedName(((ClassLiteralAccess)e).type.getTypeName());
        }
        if (e instanceof SingleNameReference) {
            return new String(((SingleNameReference)e).token);
        }
        if (e instanceof QualifiedNameReference) {
            String qName = Eclipse.toQualifiedName(((QualifiedNameReference)e).tokens);
            int idx = qName.lastIndexOf(46);
            return idx == -1 ? qName : qName.substring(idx + 1);
        }
        return null;
    }

    public static ASTNode getGeneratedBy(ASTNode node) {
        try {
            return (ASTNode)generatedByField.get(node);
        }
        catch (Exception t) {
            return null;
        }
    }

    public static boolean isGenerated(ASTNode node) {
        return Eclipse.getGeneratedBy(node) != null;
    }

    public static ASTNode setGeneratedBy(ASTNode node, ASTNode source) {
        try {
            generatedByField.set(node, source);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return node;
    }

    static {
        try {
            generatedByField = ASTNode.class.getDeclaredField("$generatedBy");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static class EclipseWorkspaceLogger {
        private EclipseWorkspaceLogger() {
        }

        void error(String message, String bundleName, Throwable error) {
            Bundle bundle = Platform.getBundle((String)bundleName);
            if (bundle == null) {
                System.err.printf("Can't find bundle %s while trying to report error:\n%s\n", bundleName, message);
                return;
            }
            ILog log = Platform.getLog((Bundle)bundle);
            log.log((IStatus)new Status(4, bundleName, message, error));
        }
    }

    private static class TerminalLogger {
        private TerminalLogger() {
        }

        void error(String message, String bundleName, Throwable error) {
            System.err.println(message);
            error.printStackTrace();
        }
    }
}

