/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac.handlers;

import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.util.Collection;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeVisitor;
import lombok.AccessLevel;
import lombok.Setter;
import lombok.core.AST;
import lombok.core.AnnotationValues;
import lombok.core.handlers.TransformationsUtil;
import lombok.javac.Javac;
import lombok.javac.JavacAnnotationHandler;
import lombok.javac.JavacNode;
import lombok.javac.handlers.JavacHandlerUtil;

public class HandleSetter
implements JavacAnnotationHandler<Setter> {
    public boolean generateSetterForType(JavacNode typeNode, JavacNode errorNode, AccessLevel level, boolean checkForTypeLevelSetter) {
        boolean notAClass;
        if (checkForTypeLevelSetter && typeNode != null) {
            for (JavacNode child : typeNode.down()) {
                if (child.getKind() != AST.Kind.ANNOTATION || !Javac.annotationTypeMatches(Setter.class, child)) continue;
                return true;
            }
        }
        JCTree.JCClassDecl typeDecl = null;
        if (typeNode.get() instanceof JCTree.JCClassDecl) {
            typeDecl = (JCTree.JCClassDecl)typeNode.get();
        }
        long modifiers = typeDecl == null ? 0L : typeDecl.mods.flags;
        boolean bl = notAClass = (modifiers & 0x6200L) != 0L;
        if (typeDecl == null || notAClass) {
            errorNode.addError("@Setter is only supported on a class or a field.");
            return false;
        }
        for (JavacNode field : typeNode.down()) {
            if (field.getKind() != AST.Kind.FIELD) continue;
            JCTree.JCVariableDecl fieldDecl = (JCTree.JCVariableDecl)field.get();
            if (fieldDecl.name.toString().startsWith("$") || (fieldDecl.mods.flags & 8L) != 0L || (fieldDecl.mods.flags & 0x10L) != 0L) continue;
            this.generateSetterForField(field, (JCDiagnostic.DiagnosticPosition)errorNode.get(), level);
        }
        return true;
    }

    public void generateSetterForField(JavacNode fieldNode, JCDiagnostic.DiagnosticPosition pos, AccessLevel level) {
        for (JavacNode child : fieldNode.down()) {
            if (child.getKind() != AST.Kind.ANNOTATION || !Javac.annotationTypeMatches(Setter.class, child)) continue;
            return;
        }
        this.createSetterForField(level, fieldNode, fieldNode, false);
    }

    @Override
    public boolean handle(AnnotationValues<Setter> annotation, JCTree.JCAnnotation ast, JavacNode annotationNode) {
        Collection<JavacNode> fields = annotationNode.upFromAnnotationToFields();
        JavacHandlerUtil.markAnnotationAsProcessed(annotationNode, Setter.class);
        JavacHandlerUtil.deleteImportFromCompilationUnit(annotationNode, "lombok.AccessLevel");
        JavacNode node = (JavacNode)annotationNode.up();
        AccessLevel level = annotation.getInstance().value();
        if (level == AccessLevel.NONE) {
            return true;
        }
        if (node == null) {
            return false;
        }
        if (node.getKind() == AST.Kind.FIELD) {
            return this.createSetterForFields(level, fields, annotationNode, true);
        }
        if (node.getKind() == AST.Kind.TYPE) {
            return this.generateSetterForType(node, annotationNode, level, false);
        }
        return false;
    }

    private boolean createSetterForFields(AccessLevel level, Collection<JavacNode> fieldNodes, JavacNode errorNode, boolean whineIfExists) {
        for (JavacNode fieldNode : fieldNodes) {
            this.createSetterForField(level, fieldNode, errorNode, whineIfExists);
        }
        return true;
    }

    private boolean createSetterForField(AccessLevel level, JavacNode fieldNode, JavacNode errorNode, boolean whineIfExists) {
        if (fieldNode.getKind() != AST.Kind.FIELD) {
            fieldNode.addError("@Setter is only supported on a class or a field.");
            return true;
        }
        JCTree.JCVariableDecl fieldDecl = (JCTree.JCVariableDecl)fieldNode.get();
        String methodName = JavacHandlerUtil.toSetterName(fieldDecl);
        switch (JavacHandlerUtil.methodExists(methodName, fieldNode, false)) {
            case EXISTS_BY_LOMBOK: {
                return true;
            }
            case EXISTS_BY_USER: {
                if (whineIfExists) {
                    errorNode.addWarning(String.format("Not generating %s(%s %s): A method with that name already exists", methodName, fieldDecl.vartype, fieldDecl.name));
                }
                return true;
            }
        }
        long access = (long)JavacHandlerUtil.toJavacModifier(level) | fieldDecl.mods.flags & 8L;
        JavacHandlerUtil.injectMethod((JavacNode)fieldNode.up(), this.createSetter(access, fieldNode, fieldNode.getTreeMaker()));
        return true;
    }

    private JCTree.JCMethodDecl createSetter(long access, JavacNode field, TreeMaker treeMaker) {
        JCTree.JCStatement nullCheck;
        JCTree.JCVariableDecl fieldDecl = (JCTree.JCVariableDecl)field.get();
        JCTree.JCFieldAccess thisX = treeMaker.Select((JCTree.JCExpression)treeMaker.Ident(field.toName("this")), fieldDecl.name);
        JCTree.JCAssign assign = treeMaker.Assign(thisX, treeMaker.Ident(fieldDecl.name));
        List<JCTree.JCAnnotation> nonNulls = JavacHandlerUtil.findAnnotations(field, TransformationsUtil.NON_NULL_PATTERN);
        List<JCTree.JCAnnotation> nullables = JavacHandlerUtil.findAnnotations(field, TransformationsUtil.NULLABLE_PATTERN);
        List<JCTree.JCStatement> statements = nonNulls.isEmpty() ? List.of(treeMaker.Exec(assign)) : ((nullCheck = JavacHandlerUtil.generateNullCheck(treeMaker, field)) != null ? List.of(nullCheck, treeMaker.Exec(assign)) : List.of(treeMaker.Exec(assign)));
        JCTree.JCBlock methodBody = treeMaker.Block(0L, statements);
        Name methodName = field.toName(JavacHandlerUtil.toSetterName(fieldDecl));
        JCTree.JCVariableDecl param = treeMaker.VarDef(treeMaker.Modifiers(16L, nonNulls.appendList(nullables)), fieldDecl.name, fieldDecl.vartype, null);
        JCTree.JCExpression methodType = treeMaker.Type(new JCNoType(9));
        List<JCTree.JCTypeParameter> methodGenericParams = List.nil();
        List<JCTree.JCVariableDecl> parameters = List.of(param);
        List<JCTree.JCExpression> throwsClauses = List.nil();
        JCTree.JCExpression annotationMethodDefaultValue = null;
        return treeMaker.MethodDef(treeMaker.Modifiers(access, List.<JCTree.JCAnnotation>nil()), methodName, methodType, methodGenericParams, parameters, throwsClauses, methodBody, annotationMethodDefaultValue);
    }

    private static class JCNoType
    extends Type
    implements NoType {
        public JCNoType(int tag) {
            super(tag, null);
        }

        @Override
        public TypeKind getKind() {
            switch (this.tag) {
                case 9: {
                    return TypeKind.VOID;
                }
                case 18: {
                    return TypeKind.NONE;
                }
            }
            throw new AssertionError((Object)("Unexpected tag: " + this.tag));
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitNoType(this, p);
        }
    }
}

