/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.trident.swing;

import java.awt.Component;
import java.awt.Rectangle;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.callback.TimelineCallbackAdapter;

public class SwingRepaintCallback
extends TimelineCallbackAdapter {
    private Component comp;
    private Rectangle rect;

    public SwingRepaintCallback(Component comp) {
        this(comp, null);
    }

    public SwingRepaintCallback(Component comp, Rectangle rect) {
        if (comp == null) {
            throw new NullPointerException("Component must be non-null");
        }
        this.comp = comp;
        this.rect = rect;
    }

    public void onTimelinePulse(float durationFraction, float timelinePosition) {
        if (this.rect == null) {
            this.comp.repaint();
        } else {
            this.comp.repaint(this.rect.x, this.rect.y, this.rect.width, this.rect.height);
        }
    }

    public void onTimelineStateChanged(Timeline.TimelineState oldState, Timeline.TimelineState newState, float durationFraction, float timelinePosition) {
        if (this.rect == null) {
            this.comp.repaint();
        } else {
            this.comp.repaint(this.rect.x, this.rect.y, this.rect.width, this.rect.height);
        }
    }
}

