/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import quickfix.Application;
import quickfix.ConfigError;
import quickfix.LogFactory;
import quickfix.MessageFactory;
import quickfix.MessageStoreFactory;
import quickfix.RuntimeError;
import quickfix.Session;
import quickfix.SessionFactory;
import quickfix.SessionSettings;
import quickfix.mina.EventHandlingStrategy;
import quickfix.mina.SingleThreadedEventHandlingStrategy;
import quickfix.mina.acceptor.AbstractSocketAcceptor;

public class SocketAcceptor
extends AbstractSocketAcceptor {
    private volatile Boolean isStarted = Boolean.FALSE;
    private final SingleThreadedEventHandlingStrategy eventHandlingStrategy;

    public SocketAcceptor(Application application, MessageStoreFactory messageStoreFactory, SessionSettings settings, LogFactory logFactory, MessageFactory messageFactory, int queueCapacity) throws ConfigError {
        super(application, messageStoreFactory, settings, logFactory, messageFactory);
        this.eventHandlingStrategy = new SingleThreadedEventHandlingStrategy(this, queueCapacity);
    }

    public SocketAcceptor(Application application, MessageStoreFactory messageStoreFactory, SessionSettings settings, LogFactory logFactory, MessageFactory messageFactory) throws ConfigError {
        super(application, messageStoreFactory, settings, logFactory, messageFactory);
        this.eventHandlingStrategy = new SingleThreadedEventHandlingStrategy(this, 10000);
    }

    public SocketAcceptor(Application application, MessageStoreFactory messageStoreFactory, SessionSettings settings, MessageFactory messageFactory, int queueCapacity) throws ConfigError {
        super(application, messageStoreFactory, settings, messageFactory);
        this.eventHandlingStrategy = new SingleThreadedEventHandlingStrategy(this, queueCapacity);
    }

    public SocketAcceptor(Application application, MessageStoreFactory messageStoreFactory, SessionSettings settings, MessageFactory messageFactory) throws ConfigError {
        super(application, messageStoreFactory, settings, messageFactory);
        this.eventHandlingStrategy = new SingleThreadedEventHandlingStrategy(this, 10000);
    }

    public SocketAcceptor(SessionFactory sessionFactory, SessionSettings settings, int queueCapacity) throws ConfigError {
        super(settings, sessionFactory);
        this.eventHandlingStrategy = new SingleThreadedEventHandlingStrategy(this, queueCapacity);
    }

    public SocketAcceptor(SessionFactory sessionFactory, SessionSettings settings) throws ConfigError {
        super(settings, sessionFactory);
        this.eventHandlingStrategy = new SingleThreadedEventHandlingStrategy(this, 10000);
    }

    @Override
    @Deprecated
    public void block() throws ConfigError, RuntimeError {
        this.initialize(false);
    }

    @Override
    public void start() throws ConfigError, RuntimeError {
        this.initialize(true);
    }

    private void initialize(boolean blockInThread) throws ConfigError {
        if (this.isStarted.equals(Boolean.FALSE)) {
            this.eventHandlingStrategy.setExecutor(this.longLivedExecutor);
            this.startAcceptingConnections();
            this.isStarted = Boolean.TRUE;
            if (blockInThread) {
                this.eventHandlingStrategy.blockInThread();
            } else {
                this.eventHandlingStrategy.block();
            }
        } else {
            this.log.warn("Ignored attempt to start already running SocketAcceptor.");
        }
    }

    @Override
    public void stop() {
        this.stop(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(boolean forceDisconnect) {
        if (this.isStarted.equals(Boolean.TRUE)) {
            try {
                try {
                    this.logoutAllSessions(forceDisconnect);
                    this.stopAcceptingConnections();
                }
                catch (ConfigError e) {
                    this.log.error("Error when stopping acceptor.", (Throwable)e);
                }
                this.stopSessionTimer();
            }
            finally {
                Session.unregisterSessions(this.getSessions());
                this.eventHandlingStrategy.stopHandlingMessages();
                this.isStarted = Boolean.FALSE;
            }
        }
    }

    @Override
    protected EventHandlingStrategy getEventHandlingStrategy() {
        return this.eventHandlingStrategy;
    }
}

