/*
 * Decompiled with CFR 0.152.
 */
package quickfix.mina.message;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecException;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.demux.MessageDecoder;
import org.apache.mina.filter.codec.demux.MessageDecoderResult;
import org.quickfixj.CharsetSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import quickfix.mina.CriticalProtocolCodecException;
import quickfix.mina.message.PatternMatcher;

public class FIXMessageDecoder
implements MessageDecoder {
    private static final char SOH = '\u0001';
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final PatternMatcher HEADER_PATTERN;
    private final PatternMatcher CHECKSUM_PATTERN;
    private final PatternMatcher LOGON_PATTERN;
    private static final int SEEKING_HEADER = 1;
    private static final int PARSING_LENGTH = 2;
    private static final int READING_BODY = 3;
    private static final int PARSING_CHECKSUM = 4;
    private static final int MAX_UNDECODED_DATA_LENGTH = 4096;
    private int state;
    private int bodyLength;
    private int position;
    private final String charsetEncoding;

    private void resetState() {
        this.state = 1;
        this.bodyLength = 0;
        this.position = 0;
    }

    public FIXMessageDecoder() throws UnsupportedEncodingException {
        this(CharsetSupport.getCharset());
    }

    public FIXMessageDecoder(String charset) throws UnsupportedEncodingException {
        this(charset, String.valueOf('\u0001'));
    }

    public FIXMessageDecoder(String charset, String delimiter) throws UnsupportedEncodingException {
        this.charsetEncoding = CharsetSupport.validate(charset);
        this.HEADER_PATTERN = new PatternMatcher("8=FIXt.?.?" + delimiter + "9=");
        this.CHECKSUM_PATTERN = new PatternMatcher("10=???" + delimiter);
        this.LOGON_PATTERN = new PatternMatcher(delimiter + "35=A" + delimiter);
        this.resetState();
    }

    public MessageDecoderResult decodable(IoSession session, IoBuffer in) {
        boolean hasHeader;
        boolean bl = hasHeader = this.HEADER_PATTERN.find(in, in.position()) != -1L;
        return hasHeader ? MessageDecoderResult.OK : (in.remaining() > 4096 ? MessageDecoderResult.NOT_OK : MessageDecoderResult.NEED_DATA);
    }

    public MessageDecoderResult decode(IoSession session, IoBuffer in, ProtocolDecoderOutput out) throws ProtocolCodecException {
        int messageCount = 0;
        while (this.parseMessage(in, out)) {
            ++messageCount;
        }
        if (messageCount > 0) {
            if (this.state == 1) {
                this.position = 0;
            }
            return MessageDecoderResult.OK;
        }
        this.position -= in.position();
        return MessageDecoderResult.NEED_DATA;
    }

    private boolean parseMessage(IoBuffer in, ProtocolDecoderOutput out) throws ProtocolCodecException {
        try {
            boolean messageFound = false;
            while (in.hasRemaining() && !messageFound) {
                if (this.state == 1) {
                    long headerPos = this.HEADER_PATTERN.find(in, this.position);
                    if (headerPos == -1L) break;
                    int headerOffset = (int)headerPos;
                    int headerLength = (int)(headerPos >>> 32);
                    in.position(headerOffset);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("detected header: " + this.getBufferDebugInfo(in));
                    }
                    this.position = headerOffset + headerLength;
                    this.state = 2;
                }
                if (this.state == 2) {
                    byte ch = 0;
                    while (this.position < in.limit()) {
                        if ((ch = in.get(this.position++)) < 48 || ch > 57) {
                            if (this.bodyLength != 0) break;
                            this.handleError(in, in.position() + 1, "Encountered invalid body length: " + (char)ch, false);
                            break;
                        }
                        this.bodyLength = this.bodyLength * 10 + (ch - 48);
                    }
                    if (this.state == 1) continue;
                    if (ch == 1) {
                        this.state = 3;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("body length = " + this.bodyLength + ": " + this.getBufferDebugInfo(in));
                        }
                    } else {
                        if (this.position >= in.limit()) break;
                        String messageString = this.getMessageStringForError(in);
                        this.handleError(in, in.position() + 1, "Length format error in message (last character: " + (char)ch + "): " + messageString, false);
                        continue;
                    }
                }
                if (this.state == 3) {
                    if (in.limit() - this.position < this.bodyLength) break;
                    this.position += this.bodyLength;
                    this.state = 4;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("message body found: " + this.getBufferDebugInfo(in));
                    }
                }
                if (this.state != 4) continue;
                if (this.CHECKSUM_PATTERN.match(in, this.position) > 0) {
                    if (in.get(this.position - 1) != 1) {
                        this.handleError(in, this.position, "checksum field not preceded by SOH, bad length?", this.isLogon(in));
                        continue;
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("found checksum: " + this.getBufferDebugInfo(in));
                    }
                    this.position += this.CHECKSUM_PATTERN.getMinLength();
                } else {
                    if (this.position + this.CHECKSUM_PATTERN.getMinLength() > in.limit()) break;
                    int recoveryPosition = this.position + 1;
                    this.handleError(in, recoveryPosition, "did not find checksum field, bad length?", this.isLogon(in));
                    continue;
                }
                String messageString = this.getMessageString(in);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("parsed message: " + this.getBufferDebugInfo(in) + " " + messageString);
                }
                out.write((Object)messageString);
                this.state = 1;
                this.bodyLength = 0;
                messageFound = true;
            }
            return messageFound;
        }
        catch (Throwable t) {
            this.resetState();
            if (t instanceof ProtocolCodecException) {
                throw (ProtocolCodecException)t;
            }
            throw new ProtocolCodecException(t);
        }
    }

    private String getBufferDebugInfo(IoBuffer in) {
        return "pos=" + in.position() + ",lim=" + in.limit() + ",rem=" + in.remaining() + ",offset=" + this.position + ",state=" + this.state;
    }

    private String getMessageString(IoBuffer buffer) throws UnsupportedEncodingException {
        byte[] data = new byte[this.position - buffer.position()];
        buffer.get(data);
        return new String(data, this.charsetEncoding);
    }

    private String getMessageStringForError(IoBuffer buffer) throws UnsupportedEncodingException {
        int initialPosition = buffer.position();
        byte[] data = new byte[buffer.limit() - initialPosition];
        buffer.get(data);
        buffer.position(this.position - initialPosition);
        return new String(data, this.charsetEncoding);
    }

    private void handleError(IoBuffer buffer, int recoveryPosition, String text, boolean disconnect) throws ProtocolCodecException {
        buffer.position(recoveryPosition);
        this.position = recoveryPosition;
        this.state = 1;
        this.bodyLength = 0;
        if (disconnect) {
            throw new CriticalProtocolCodecException(text);
        }
        this.log.error(text);
    }

    private boolean isLogon(IoBuffer buffer) {
        return this.LOGON_PATTERN.find(buffer, buffer.position()) != -1L;
    }

    public void finishDecode(IoSession session, ProtocolDecoderOutput out) throws Exception {
    }

    public List<String> extractMessages(File file) throws IOException, ProtocolCodecException {
        final ArrayList<String> messages = new ArrayList<String>();
        this.extractMessages(file, new MessageListener(){

            @Override
            public void onMessage(String message) {
                messages.add(message);
            }
        });
        return messages;
    }

    public void extractMessages(File file, final MessageListener listener) throws IOException, ProtocolCodecException {
        try (RandomAccessFile fileIn = new RandomAccessFile(file, "r");){
            FileChannel readOnlyChannel = fileIn.getChannel();
            MappedByteBuffer memoryMappedBuffer = readOnlyChannel.map(FileChannel.MapMode.READ_ONLY, 0L, (int)readOnlyChannel.size());
            this.decode(null, IoBuffer.wrap((ByteBuffer)memoryMappedBuffer), new ProtocolDecoderOutput(){

                public void write(Object message) {
                    listener.onMessage((String)message);
                }

                public void flush(IoFilter.NextFilter nextFilter, IoSession ioSession) {
                }
            });
        }
    }

    public static interface MessageListener {
        public void onMessage(String var1);
    }
}

