/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.
 *
 * Copyright 2019-2021 the original author or authors.
 */

package org.quickperf.jvm.config.library;

import org.quickperf.RecorderExecutionOrder;
import org.quickperf.config.library.AnnotationConfig;
import org.quickperf.config.library.QuickPerfConfigLoader;
import org.quickperf.jvm.jfr.JfrEventsRecorder;

import java.util.Arrays;
import java.util.Collection;

public class JfrConfigLoader implements QuickPerfConfigLoader {

    public Collection<AnnotationConfig> loadAnnotationConfigs() {
        return Arrays.asList(
                  JfrAnnotationsConfigs.PROFILE_JVM_WITH_JFR
                , JfrAnnotationsConfigs.CHECK_JVM
                , JfrAnnotationsConfigs.PROFILE_QUICK_PERF_WITH_JFR
        );
    }

    public Collection<RecorderExecutionOrder> loadRecorderExecutionOrdersBeforeTestMethod() {
        return Arrays.asList(
                new RecorderExecutionOrder(JfrEventsRecorder.class, 6000)
        );
    }

    public Collection<RecorderExecutionOrder> loadRecorderExecutionOrdersAfterTestMethod() {
        return Arrays.asList(
                new RecorderExecutionOrder(JfrEventsRecorder.class, 3030)
        );
    }

}
