/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.
 *
 * Copyright 2019-2021 the original author or authors.
 */

package org.quickperf.jvm.jmcrule;

import org.jsoup.Jsoup;
import org.jsoup.examples.HtmlToPlainText;
import org.jsoup.nodes.Document;

class HtmlToPlainTextTransformer {

    public static final HtmlToPlainTextTransformer INSTANCE = new HtmlToPlainTextTransformer();

    public String convertHtmlToPlainText(String html) {
        HtmlToPlainText htmlToPlainText = new HtmlToPlainText();
        Document jsoupDocument = Jsoup.parse(html);
        jsoupDocument.select("p").prepend("<br>");
        return htmlToPlainText.getPlainText(jsoupDocument);
    }

}
