/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.jvm.config.library;

import java.util.ArrayList;
import java.util.List;
import org.quickperf.WorkingFolder;
import org.quickperf.jvm.JVM;
import org.quickperf.jvm.config.library.JfrJvmOptions;
import org.quickperf.jvm.jfr.annotation.ProfileQuickPerfInTestJvm;
import org.quickperf.testlauncher.AnnotationToJvmOptionConverter;
import org.quickperf.testlauncher.JvmOption;

class QuickPerfProfilingAnnotToJvmOptionConverter
implements AnnotationToJvmOptionConverter<ProfileQuickPerfInTestJvm> {
    static final AnnotationToJvmOptionConverter INSTANCE = new QuickPerfProfilingAnnotToJvmOptionConverter();
    private static final List<JvmOption> PROFILING_OPTIONS = QuickPerfProfilingAnnotToJvmOptionConverter.buildProfilingOptions();

    private QuickPerfProfilingAnnotToJvmOptionConverter() {
    }

    private static List<JvmOption> buildProfilingOptions() {
        List<JvmOption> jfrJvmOptions = JfrJvmOptions.INSTANCE.getValues();
        ArrayList<JvmOption> jvmOptions = new ArrayList<JvmOption>(jfrJvmOptions);
        String jfrOptionName = "FlightRecorderOptions";
        String defaultRecording = "defaultrecording=true,";
        String pathName = "dumponexitpath";
        if (JVM.INSTANCE.version.isGreaterThanOrEqualTo9()) {
            jfrOptionName = "StartFlightRecording";
            defaultRecording = "";
            pathName = "filename";
        }
        JvmOption flightRecorderOptions = new JvmOption("-XX:" + jfrOptionName + "=" + defaultRecording + "disk=true,settings=profile,dumponexit=true," + pathName + "=dumponexit.jfr");
        jvmOptions.add(flightRecorderOptions);
        return jvmOptions;
    }

    public List<JvmOption> convertToJvmOptions(ProfileQuickPerfInTestJvm annotation, WorkingFolder workingFolder) {
        return PROFILING_OPTIONS;
    }
}

