/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.jvm.jfr;

import java.io.File;
import java.io.IOException;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.flightrecorder.CouldNotLoadRecordingException;
import org.openjdk.jmc.flightrecorder.JfrLoaderToolkit;
import org.quickperf.WorkingFolder;
import org.quickperf.jvm.jfr.UnableToProfileJvmWithJdkFlightRecorder;

class JFREventsLoader {
    JFREventsLoader() {
    }

    IItemCollection loadJfrEventsFrom(WorkingFolder workingFolder) {
        String jfrFilePath = workingFolder.getPath() + File.separator + "jvm-profiling.jfr";
        if (this.unableToProfileWithJdkFlightRecorder(jfrFilePath)) {
            throw new UnableToProfileJvmWithJdkFlightRecorder();
        }
        return this.load(jfrFilePath);
    }

    private boolean unableToProfileWithJdkFlightRecorder(String jfrFilePath) {
        File jfrFile = new File(jfrFilePath);
        return !jfrFile.exists();
    }

    private IItemCollection load(String jfrFilePath) {
        try {
            File jfrFile = new File(jfrFilePath);
            IItemCollection jfrEvents = JfrLoaderToolkit.loadEvents((File)jfrFile);
            String pointingRight = "\ud83d\udc49";
            System.out.println("[QUICK PERF] JVM was profiled with JDK Flight Recorder (JFR)." + System.lineSeparator() + "The recording file is available here: " + jfrFilePath + System.lineSeparator() + "You can open it with JDK Mission Control (JMC)." + System.lineSeparator() + "Where to find JDK Mission Control? " + pointingRight + " https://tinyurl.com/jdkmc");
            return jfrEvents;
        }
        catch (IOException | CouldNotLoadRecordingException e) {
            throw new IllegalStateException("Can't read JFR file.", e);
        }
    }
}

