/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.jvm.jfr;

import org.openjdk.jmc.common.item.IItemCollection;
import org.quickperf.TestExecutionContext;
import org.quickperf.WorkingFolder;
import org.quickperf.jvm.jfr.JFREventsLoader;
import org.quickperf.jvm.jfr.JfrRecording;
import org.quickperf.jvm.jfr.profiler.JdkFlightRecorderProfilerFactory;
import org.quickperf.jvm.jfr.profiler.JvmProfiler;
import org.quickperf.perfrecording.RecordablePerformance;

public class JfrEventsRecorder
implements RecordablePerformance<JfrRecording> {
    private final JvmProfiler jfrProfiler = JdkFlightRecorderProfilerFactory.getJdkFlightRecorderProfiler();
    private JfrRecording jfrRecording;

    public void startRecording(TestExecutionContext testExecutionContext) {
        WorkingFolder workingFolder = testExecutionContext.getWorkingFolder();
        this.jfrProfiler.startProfiling(workingFolder.getPath());
    }

    public void stopRecording(TestExecutionContext testExecutionContext) {
        WorkingFolder workingFolder = testExecutionContext.getWorkingFolder();
        this.jfrProfiler.stopProfiling(workingFolder.getPath());
    }

    public JfrRecording findRecord(TestExecutionContext testExecutionContext) {
        if (this.jfrRecording != null) {
            return this.jfrRecording;
        }
        JFREventsLoader jfrEventsLoader = new JFREventsLoader();
        WorkingFolder workingFolder = testExecutionContext.getWorkingFolder();
        IItemCollection jfrEvents = jfrEventsLoader.loadJfrEventsFrom(workingFolder);
        this.jfrRecording = new JfrRecording(jfrEvents);
        return this.jfrRecording;
    }

    public void cleanResources() {
    }
}

