/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.jvm.jfr.profiler;

import java.io.File;
import java.lang.management.ManagementFactory;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.quickperf.jvm.jfr.profiler.JvmProfiler;

class JdkFlightRecorderProfilerFromJava9
implements JvmProfiler {
    private final MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
    private final ObjectName objectName = this.getObjectName();

    JdkFlightRecorderProfilerFromJava9() {
    }

    private ObjectName getObjectName() {
        try {
            return new ObjectName("jdk.management.jfr:type=FlightRecorder");
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void startProfiling(String workingFolderPath) {
        try {
            Long recordingId = (Long)this.mBeanServer.invoke(this.objectName, "newRecording", new Object[0], new String[0]);
            Object[] setConfigArgs = new Object[]{recordingId, "profile"};
            this.mBeanServer.invoke(this.objectName, "setPredefinedConfiguration", setConfigArgs, new String[]{Long.TYPE.getName(), String.class.getName()});
            Object[] startRecordingArgs = new Object[]{recordingId};
            this.mBeanServer.invoke(this.objectName, "startRecording", startRecordingArgs, new String[]{Long.TYPE.getName()});
        }
        catch (InstanceNotFoundException | MBeanException | ReflectionException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void stopProfiling(String workingFolderPath) {
        String jfrPath = workingFolderPath + File.separator + "jvm-profiling.jfr";
        try {
            long recordingId = (Long)this.mBeanServer.invoke(this.objectName, "takeSnapshot", new Object[0], new String[0]);
            Object[] copyToArgs = new Object[]{recordingId, jfrPath};
            this.mBeanServer.invoke(this.objectName, "copyTo", copyToArgs, new String[]{Long.TYPE.getName(), String.class.getName()});
        }
        catch (InstanceNotFoundException | MBeanException | ReflectionException e) {
            throw new IllegalStateException(e);
        }
    }
}

