/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.jvm.jfr.profiler;

import java.io.File;
import java.lang.management.ManagementFactory;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.quickperf.jvm.jfr.profiler.JvmProfiler;

class OracleJdkFlightRecorderProfilerBeforeJava9
implements JvmProfiler {
    private final String name = "1";
    private final MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
    private final ObjectName objectName = this.getObjectName();

    OracleJdkFlightRecorderProfilerBeforeJava9() {
    }

    private ObjectName getObjectName() {
        try {
            return new ObjectName("com.sun.management:type=DiagnosticCommand");
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void startProfiling(String workingFolderPath) {
        try {
            Object[] jfrStartArgs = new Object[]{new String[]{"name=1", "settings=profile.jfc"}};
            this.mBeanServer.invoke(this.objectName, "jfrStart", jfrStartArgs, new String[]{String[].class.getName()});
        }
        catch (InstanceNotFoundException | MBeanException | ReflectionException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void stopProfiling(String workingFolderPath) {
        try {
            Object[] jfrStopArgs = new Object[]{new String[]{"name=1", "filename=" + workingFolderPath + File.separator + "jvm-profiling.jfr", "compress=false"}};
            this.mBeanServer.invoke(this.objectName, "jfrStop", jfrStopArgs, new String[]{String[].class.getName()});
        }
        catch (InstanceNotFoundException | MBeanException | ReflectionException e) {
            throw new IllegalStateException(e);
        }
    }
}

