/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.jvm.jmc.value;

import org.openjdk.jmc.common.item.IAggregator;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.quickperf.jvm.jmc.value.allocationrate.AllocationRate;
import org.quickperf.jvm.jmc.value.allocationrate.AllocationRateFormatter;
import org.quickperf.jvm.jmc.value.allocationrate.AllocationRateRetriever;

public enum ProfilingInfo {
    TOTAL_GC_PAUSE{

        @Override
        public String formatAsString(IItemCollection jfrEvents) {
            return this.formatAsString(jfrEvents, JdkAggregators.TOTAL_GC_PAUSE, IQuantity.class);
        }

        @Override
        public String getLabel() {
            return this.getLabel(JdkAggregators.TOTAL_GC_PAUSE, IQuantity.class);
        }
    }
    ,
    LONGEST_GC_PAUSE{

        @Override
        public String formatAsString(IItemCollection jfrEvents) {
            return this.formatAsString(jfrEvents, JdkAggregators.LONGEST_GC_PAUSE, IQuantity.class);
        }

        @Override
        public String getLabel() {
            return this.getLabel(JdkAggregators.LONGEST_GC_PAUSE, IQuantity.class);
        }
    }
    ,
    ALLOCATION_TOTAL{

        @Override
        public String formatAsString(IItemCollection jfrEvents) {
            return this.formatAsString(jfrEvents, JdkAggregators.ALLOCATION_TOTAL, IQuantity.class);
        }

        @Override
        public String getLabel() {
            return this.getLabel(JdkAggregators.ALLOCATION_TOTAL, IQuantity.class);
        }
    }
    ,
    ALLOC_INSIDE_TLAB_SUM{

        @Override
        public String formatAsString(IItemCollection jfrEvents) {
            return this.formatAsString(jfrEvents, JdkAggregators.ALLOC_INSIDE_TLAB_SUM, IQuantity.class);
        }

        @Override
        public String getLabel() {
            return this.getLabel(JdkAggregators.ALLOC_INSIDE_TLAB_SUM, IQuantity.class);
        }
    }
    ,
    ALLOC_OUTSIDE_TLAB_SUM{

        @Override
        public String formatAsString(IItemCollection jfrEvents) {
            return this.formatAsString(jfrEvents, JdkAggregators.ALLOC_OUTSIDE_TLAB_SUM, IQuantity.class);
        }

        @Override
        public String getLabel() {
            return this.getLabel(JdkAggregators.ALLOC_OUTSIDE_TLAB_SUM, IQuantity.class);
        }
    }
    ,
    EXCEPTIONS_COUNT{

        @Override
        public String formatAsString(IItemCollection jfrEvents) {
            return this.formatAsString(jfrEvents, JdkAggregators.EXCEPTIONS_COUNT, IQuantity.class);
        }

        @Override
        public String getLabel() {
            return this.getLabel(JdkAggregators.EXCEPTIONS_COUNT, IQuantity.class);
        }
    }
    ,
    ERROR_COUNT{

        @Override
        public String formatAsString(IItemCollection jfrEvents) {
            return this.formatAsString(jfrEvents, JdkAggregators.ERROR_COUNT, IQuantity.class);
        }

        @Override
        public String getLabel() {
            return this.getLabel(JdkAggregators.ERROR_COUNT, IQuantity.class);
        }
    }
    ,
    THROWABLES_COUNT{

        @Override
        public String formatAsString(IItemCollection jfrEvents) {
            return this.formatAsString(jfrEvents, JdkAggregators.THROWABLES_COUNT, IQuantity.class);
        }

        @Override
        public String getLabel() {
            return this.getLabel(JdkAggregators.THROWABLES_COUNT, IQuantity.class);
        }
    }
    ,
    COMPILATIONS_COUNT{

        @Override
        public String formatAsString(IItemCollection jfrEvents) {
            return this.formatAsString(jfrEvents, JdkAggregators.COMPILATIONS_COUNT, IQuantity.class);
        }

        @Override
        public String getLabel() {
            return this.getLabel(JdkAggregators.COMPILATIONS_COUNT, IQuantity.class);
        }
    }
    ,
    LONGEST_COMPILATION{

        @Override
        public String formatAsString(IItemCollection jfrEvents) {
            return this.formatAsString(jfrEvents, JdkAggregators.LONGEST_COMPILATION, IQuantity.class);
        }

        @Override
        public String getLabel() {
            return this.getLabel(JdkAggregators.LONGEST_COMPILATION, IQuantity.class);
        }
    }
    ,
    CODE_CACHE_FULL_COUNT{

        @Override
        public String formatAsString(IItemCollection jfrEvents) {
            return this.formatAsString(jfrEvents, JdkAggregators.CODE_CACHE_FULL_COUNT, IQuantity.class);
        }

        @Override
        public String getLabel() {
            return this.getLabel(JdkAggregators.CODE_CACHE_FULL_COUNT, IQuantity.class);
        }
    }
    ,
    JVM_NAME{

        @Override
        public String formatAsString(IItemCollection jfrEvents) {
            return this.formatAsString(jfrEvents, JdkAggregators.JVM_NAME, String.class);
        }

        @Override
        public String getLabel() {
            return this.getLabel(JdkAggregators.JVM_NAME, String.class);
        }
    }
    ,
    JVM_VERSION{

        @Override
        public String formatAsString(IItemCollection jfrEvents) {
            return this.formatAsString(jfrEvents, JdkAggregators.JVM_VERSION, String.class);
        }

        @Override
        public String getLabel() {
            return this.getLabel(JdkAggregators.JVM_VERSION, String.class);
        }
    }
    ,
    JVM_ARGUMENTS{

        @Override
        public String formatAsString(IItemCollection jfrEvents) {
            return this.formatAsString(jfrEvents, JdkAggregators.JVM_ARGUMENTS, String.class);
        }

        @Override
        public String getLabel() {
            return this.getLabel(JdkAggregators.JVM_ARGUMENTS, String.class);
        }
    }
    ,
    MIN_HW_THREADS{

        @Override
        public String formatAsString(IItemCollection jfrEvents) {
            return this.formatAsString(jfrEvents, JdkAggregators.MIN_HW_THREADS, IQuantity.class);
        }

        @Override
        public String getLabel() {
            return this.getLabel(JdkAggregators.MIN_HW_THREADS, IQuantity.class);
        }
    }
    ,
    MIN_NUMBER_OF_CORES{

        @Override
        public String formatAsString(IItemCollection jfrEvents) {
            return this.formatAsString(jfrEvents, JdkAggregators.MIN_NUMBER_OF_CORES, IQuantity.class);
        }

        @Override
        public String getLabel() {
            return this.getLabel(JdkAggregators.MIN_NUMBER_OF_CORES, IQuantity.class);
        }
    }
    ,
    MIN_NUMBER_OF_SOCKETS{

        @Override
        public String formatAsString(IItemCollection jfrEvents) {
            return this.formatAsString(jfrEvents, JdkAggregators.MIN_NUMBER_OF_SOCKETS, IQuantity.class);
        }

        @Override
        public String getLabel() {
            return this.getLabel(JdkAggregators.MIN_NUMBER_OF_SOCKETS, IQuantity.class);
        }
    }
    ,
    CPU_DESCRIPTION{

        @Override
        public String formatAsString(IItemCollection jfrEvents) {
            return this.formatAsString(jfrEvents, JdkAggregators.CPU_DESCRIPTION, String.class);
        }

        @Override
        public String getLabel() {
            return this.getLabel(JdkAggregators.CPU_DESCRIPTION, String.class);
        }
    }
    ,
    OS_VERSION{

        @Override
        public String formatAsString(IItemCollection jfrEvents) {
            return this.formatAsString(jfrEvents, JdkAggregators.OS_VERSION, String.class);
        }

        @Override
        public String getLabel() {
            return this.getLabel(JdkAggregators.OS_VERSION, String.class);
        }
    }
    ,
    ALLOCATION_RATE{

        @Override
        public String formatAsString(IItemCollection jfrEvents) {
            AllocationRate allocationRate = AllocationRateRetriever.INSTANCE.retrieveAllocationRateFrom(jfrEvents);
            return AllocationRateFormatter.INSTANCE.format(allocationRate);
        }

        @Override
        public String getLabel() {
            return "Allocation Rate";
        }
    };


    public abstract String formatAsString(IItemCollection var1);

    public abstract String getLabel();

    String getLabel(IAggregator aggregator, Class<?> type) {
        if (type.isAssignableFrom(IQuantity.class)) {
            return this.getLabelFrom(aggregator);
        }
        if (type.isAssignableFrom(String.class)) {
            return aggregator.getName();
        }
        throw new IllegalStateException(type + " type is not managed.");
    }

    private String getLabelFrom(IAggregator aggregator) {
        String label = aggregator.getDescription();
        if (label == null) {
            label = aggregator.getName();
        }
        return label;
    }

    public String formatAsString(IItemCollection jfrEvents, IAggregator aggregator, Class<?> type) {
        Object aggregateAsObject = jfrEvents.getAggregate(aggregator);
        if (type.isAssignableFrom(IQuantity.class)) {
            IQuantity quantity = (IQuantity)aggregateAsObject;
            return this.getStringValueOf(quantity);
        }
        if (type.isAssignableFrom(String.class)) {
            String stringValue = (String)aggregateAsObject;
            return this.formatDescription(stringValue);
        }
        throw new IllegalStateException(type + " type is not managed.");
    }

    private String getStringValueOf(IQuantity quantity) {
        if (quantity != null) {
            return quantity.displayUsing("auto");
        }
        return "0";
    }

    private String[] splitInLines(String stringValue) {
        return stringValue.split("\\r|\\n");
    }

    private String formatDescription(String description) {
        boolean oneLine;
        String[] descriptionLines = this.splitInLines(description);
        boolean bl = oneLine = descriptionLines.length == 1;
        if (oneLine) {
            return description;
        }
        return this.formatDescOfSeveralLines(descriptionLines);
    }

    private String formatDescOfSeveralLines(String[] descriptionLines) {
        StringBuilder formattedDescription = new StringBuilder();
        for (int i = 0; i < descriptionLines.length; ++i) {
            if (i != 0) {
                formattedDescription.append(System.lineSeparator());
            }
            String descriptionLine = descriptionLines[i];
            formattedDescription.append("\t\t" + descriptionLine);
        }
        return formattedDescription.toString();
    }
}

