/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.jvm.jmc.value.allocationrate;

import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemIterable;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.QuantityConversionException;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.quickperf.jvm.jmc.value.allocationrate.AllocationRate;

public class AllocationRateRetriever {
    public static final AllocationRateRetriever INSTANCE = new AllocationRateRetriever();

    private AllocationRateRetriever() {
    }

    public AllocationRate retrieveAllocationRateFrom(IItemCollection jfrEvents) {
        long allocationDurationInMs;
        try {
            allocationDurationInMs = this.computeAllocationDurationInMs(jfrEvents);
        }
        catch (QuantityConversionException e) {
            return AllocationRate.NONE;
        }
        if (allocationDurationInMs == 0L) {
            return AllocationRate.NONE;
        }
        long totalAllocationInBytes = this.computeTotalAllocationInBytes(jfrEvents);
        return new AllocationRate(totalAllocationInBytes, allocationDurationInMs);
    }

    private long computeTotalAllocationInBytes(IItemCollection jfrEvents) {
        IQuantity totalAlloc = (IQuantity)jfrEvents.getAggregate(JdkAggregators.ALLOCATION_TOTAL);
        return totalAlloc == null ? 0L : totalAlloc.longValue();
    }

    private long computeAllocationDurationInMs(IItemCollection jfrEvents) throws QuantityConversionException {
        IItemCollection insideTlab = jfrEvents.apply(JdkFilters.ALLOC_INSIDE_TLAB);
        IItemCollection outsideTlab = jfrEvents.apply(JdkFilters.ALLOC_OUTSIDE_TLAB);
        return this.searchMaxTimeStampInMs(insideTlab, outsideTlab) - this.searchMinTimeStampInMs(insideTlab, outsideTlab);
    }

    private long searchMaxTimeStampInMs(IItemCollection insideTlab, IItemCollection outsideTlab) throws QuantityConversionException {
        long insideTlabMaxTimeStamp = this.computeMaxTimeStampInMs(insideTlab);
        long outsideTlabMaxTimeStamp = this.computeMaxTimeStampInMs(outsideTlab);
        return Math.max(insideTlabMaxTimeStamp, outsideTlabMaxTimeStamp);
    }

    private long searchMinTimeStampInMs(IItemCollection insideTlab, IItemCollection outsideTlab) throws QuantityConversionException {
        long insideTlabMinTimeStamp = this.computeMinTimeStampInMs(insideTlab);
        long outsideTlabMinTimeStamp = this.computeMinTimeStampInMs(outsideTlab);
        return Math.min(insideTlabMinTimeStamp, outsideTlabMinTimeStamp);
    }

    private long computeMinTimeStampInMs(IItemCollection allocationEvents) throws ArithmeticException, QuantityConversionException {
        long minTimeStamp = Long.MAX_VALUE;
        for (IItemIterable jfrEventCollection : allocationEvents) {
            for (IItem item : jfrEventCollection) {
                long currentTimeStamp = this.getTimeStampInMs(item);
                minTimeStamp = Math.min(minTimeStamp, currentTimeStamp);
            }
        }
        return minTimeStamp;
    }

    private long computeMaxTimeStampInMs(IItemCollection allocationEvents) throws ArithmeticException, QuantityConversionException {
        long maxTimeStamp = 0L;
        for (IItemIterable jfrEventCollection : allocationEvents) {
            for (IItem item : jfrEventCollection) {
                long currentTimeStamp = this.getTimeStampInMs(item);
                maxTimeStamp = Math.max(maxTimeStamp, currentTimeStamp);
            }
        }
        return maxTimeStamp;
    }

    private long getTimeStampInMs(IItem allocationEvent) throws ArithmeticException, QuantityConversionException {
        IType type = allocationEvent.getType();
        IMemberAccessor endTimeAccessor = JfrAttributes.END_TIME.getAccessor(type);
        IQuantity quantityEndTime = (IQuantity)endTimeAccessor.getMember((Object)allocationEvent);
        return quantityEndTime.longValueIn((IUnit)UnitLookup.EPOCH_MS);
    }
}

