/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.jvm.jmcrule;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.Result;
import org.openjdk.jmc.flightrecorder.rules.RuleRegistry;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.quickperf.ExtractablePerformanceMeasure;
import org.quickperf.jvm.jfr.JfrRecording;
import org.quickperf.jvm.jmcrule.HtmlToPlainTextTransformer;
import org.quickperf.jvm.jmcrule.JmcRulesMeasure;
import org.quickperf.unit.Count;

public class JmcRuleCountMeasureExtractor
implements ExtractablePerformanceMeasure<JfrRecording, JmcRulesMeasure> {
    public static final JmcRuleCountMeasureExtractor INSTANCE = new JmcRuleCountMeasureExtractor();

    private JmcRuleCountMeasureExtractor() {
    }

    public JmcRulesMeasure extractPerfMeasureFrom(JfrRecording jfrRecording) {
        IItemCollection jfrEvents = jfrRecording.getJfrEvents();
        List<Result> ruleEvaluations = this.evaluateJmcRules(jfrEvents);
        List<Count> jmcRules = this.buildJmcRuleCountsFrom(ruleEvaluations);
        return new JmcRulesMeasure(jmcRules);
    }

    private List<Result> evaluateJmcRules(IItemCollection jfrEvents) {
        ArrayList<Result> ruleEvaluations = new ArrayList<Result>();
        for (IRule rule : RuleRegistry.getRules()) {
            Result result;
            RunnableFuture future = rule.evaluate(jfrEvents, IPreferenceValueProvider.DEFAULT_VALUES);
            future.run();
            try {
                result = (Result)future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IllegalStateException(e);
            }
            ruleEvaluations.add(result);
        }
        return ruleEvaluations;
    }

    private List<Count> buildJmcRuleCountsFrom(List<Result> ruleEvaluations) {
        ArrayList<Count> jmcRules = new ArrayList<Count>();
        for (Result ruleEvaluation : ruleEvaluations) {
            Count ruleScore = this.buildJmcRuleCountFrom(ruleEvaluation);
            if (this.ruleToExclude(ruleScore)) continue;
            jmcRules.add(ruleScore);
        }
        return jmcRules;
    }

    private boolean ruleToExclude(Count ruleScore) {
        String ruleDescription = ruleScore.getComment();
        return ruleDescription.contains("Rule: TLAB Allocation Ratio") || ruleDescription.contains("Rule: Competing Processes") || ruleDescription.contains("Rule: Command Line Options Check") || ruleDescription.contains("Rule: Metaspace Live Set Trend");
    }

    private Count buildJmcRuleCountFrom(Result result) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("Rule: " + result.getRule().getName());
        printWriter.println("Severity: " + Severity.get((double)result.getScore()));
        long score = (long)result.getScore();
        printWriter.println("Score: " + score);
        String longDescriptionAsHtml = result.getLongDescription();
        String textDesc = HtmlToPlainTextTransformer.INSTANCE.convertHtmlToPlainText(longDescriptionAsHtml);
        printWriter.println("Message: " + textDesc);
        String description = stringWriter.toString();
        return new Count(Long.valueOf(score), description);
    }
}

