/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.jvm.jmcrule;

import java.util.ArrayList;
import java.util.List;
import org.quickperf.issue.PerfIssue;
import org.quickperf.issue.VerifiablePerformanceIssue;
import org.quickperf.jvm.jfr.annotation.ExpectNoJvmIssue;
import org.quickperf.jvm.jmcrule.JmcRulesMeasure;
import org.quickperf.unit.Count;

public class JmcRulesPerfVerifier
implements VerifiablePerformanceIssue<ExpectNoJvmIssue, JmcRulesMeasure> {
    public static final VerifiablePerformanceIssue INSTANCE = new JmcRulesPerfVerifier();

    private JmcRulesPerfVerifier() {
    }

    public PerfIssue verifyPerfIssue(ExpectNoJvmIssue annotation, JmcRulesMeasure jmcRules) {
        int maxExpectedScore = annotation.score();
        Object jmcRulesAsCount = jmcRules.getValue();
        if (this.atLeastOneRuleHasScoreGreaterThanExpected((List<Count>)jmcRulesAsCount, maxExpectedScore)) {
            List<Count> jmcRulesWithValueGreaterThanExpected = this.retrieveJmcRulesWithValueGreaterThanExpected((List<Count>)jmcRulesAsCount, maxExpectedScore);
            return this.buildPerfIssueFrom(jmcRulesWithValueGreaterThanExpected, maxExpectedScore);
        }
        return PerfIssue.NONE;
    }

    private boolean atLeastOneRuleHasScoreGreaterThanExpected(List<Count> jmcRulesAsCount, int maxExpectedScore) {
        for (Count jmcRule : jmcRulesAsCount) {
            if (jmcRule.getValue() < (long)maxExpectedScore) continue;
            return true;
        }
        return false;
    }

    private PerfIssue buildPerfIssueFrom(List<Count> jmcRulesWithValueGreaterThanExpected, int maxExpectedScore) {
        String assertionMessage = "JMC rules are expected to have score less than <" + maxExpectedScore + ">.";
        StringBuilder perfIssueDesc = new StringBuilder(assertionMessage);
        perfIssueDesc.append(System.lineSeparator());
        perfIssueDesc.append(System.lineSeparator());
        for (Count jmcRule : jmcRulesWithValueGreaterThanExpected) {
            perfIssueDesc.append(jmcRule.getComment());
            perfIssueDesc.append(System.lineSeparator());
        }
        return new PerfIssue(perfIssueDesc.toString());
    }

    private List<Count> retrieveJmcRulesWithValueGreaterThanExpected(List<Count> jmcRulesAsCount, int maxExpectedScore) {
        ArrayList<Count> jmcRulesWithValueGreaterThanExpected = new ArrayList<Count>();
        for (Count jmcRule : jmcRulesAsCount) {
            if (jmcRule.getValue() < (long)maxExpectedScore) continue;
            jmcRulesWithValueGreaterThanExpected.add(jmcRule);
        }
        return jmcRulesWithValueGreaterThanExpected;
    }
}

