/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.builder;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.raml.parser.builder.DefaultTupleBuilder;
import org.raml.parser.builder.PojoTupleBuilder;
import org.raml.parser.builder.ScalarTupleBuilder;
import org.raml.parser.builder.TupleBuilder;
import org.raml.parser.resolver.DefaultScalarTupleHandler;
import org.raml.parser.resolver.TupleHandler;
import org.raml.parser.utils.ReflectionUtils;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.ScalarNode;

public class MapTupleBuilder
extends DefaultTupleBuilder<ScalarNode, Node> {
    private Class valueClass;
    private String fieldName;
    private TupleHandler innerTupleHandler;

    public MapTupleBuilder(Class<?> valueClass) {
        this(null, valueClass);
    }

    public MapTupleBuilder(String fieldName, Class<?> valueClass) {
        super(new DefaultScalarTupleHandler(fieldName));
        this.fieldName = fieldName;
        this.valueClass = valueClass;
    }

    private void addBuilders() {
        DefaultTupleBuilder tupleBuilder = ReflectionUtils.isPojo(this.getValueClass()) ? new PojoTupleBuilder(this.getValueClass()) : new ScalarTupleBuilder(null, this.getValueClass());
        if (this.innerTupleHandler != null) {
            tupleBuilder.setHandler(this.innerTupleHandler);
        }
        HashMap builderMap = new HashMap();
        builderMap.put(this.fieldName, tupleBuilder);
        this.setChildrenTupleBuilders(builderMap);
    }

    @Override
    protected Map<String, TupleBuilder<?, ?>> getBuilders() {
        if (super.getBuilders().isEmpty()) {
            this.addBuilders();
        }
        return super.getBuilders();
    }

    @Override
    public Object buildValue(Object parent, Node node) {
        LinkedHashMap map = new LinkedHashMap();
        ReflectionUtils.setProperty(parent, this.getFieldName(), map);
        return map;
    }

    public Class getValueClass() {
        return this.valueClass;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setInnerTupleHandler(TupleHandler innerTupleHandler) {
        this.innerTupleHandler = innerTupleHandler;
    }

    public String toString() {
        return this.fieldName;
    }
}

