/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.visitor;

import java.util.List;
import org.raml.model.Raml;
import org.raml.parser.loader.ResourceLoader;
import org.raml.parser.rule.BaseUriRule;
import org.raml.parser.rule.DefaultTupleRule;
import org.raml.parser.rule.ImplicitMapEntryRule;
import org.raml.parser.rule.NodeRule;
import org.raml.parser.rule.NodeRuleFactory;
import org.raml.parser.rule.SimpleRule;
import org.raml.parser.rule.TupleRule;
import org.raml.parser.rule.TypedTupleRule;
import org.raml.parser.rule.ValidationResult;
import org.raml.parser.visitor.MediaTypeResolver;
import org.raml.parser.visitor.TemplateResolver;
import org.raml.parser.visitor.TupleType;
import org.raml.parser.visitor.YamlDocumentValidator;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.ScalarNode;

public class RamlDocumentValidator
extends YamlDocumentValidator {
    private TemplateResolver templateResolver;
    private MediaTypeResolver mediaTypeResolver = new MediaTypeResolver();
    private ResourceLoader resourceLoader;

    public RamlDocumentValidator() {
        super(Raml.class);
    }

    public RamlDocumentValidator(NodeRuleFactory nodeRuleFactory) {
        super(Raml.class, nodeRuleFactory);
    }

    public TemplateResolver getTemplateResolver() {
        if (this.templateResolver == null) {
            this.templateResolver = new TemplateResolver(this.resourceLoader, this);
        }
        return this.templateResolver;
    }

    public MediaTypeResolver getMediaTypeResolver() {
        return this.mediaTypeResolver;
    }

    @Override
    public boolean onMappingNodeStart(MappingNode mappingNode, TupleType tupleType) {
        super.onMappingNodeStart(mappingNode, tupleType);
        if (tupleType == TupleType.KEY) {
            return true;
        }
        NodeRule<?> rule = this.getRuleContext().peek();
        if (this.isResourceRule(rule)) {
            List<ValidationResult> templateValidations = this.getTemplateResolver().resolve(mappingNode, this.getResourceUri(rule), this.getFullUri(rule));
            this.getMessages().addAll(templateValidations);
        } else if (this.isBodyRule(rule)) {
            List<ValidationResult> mediaTypeValidations = this.getMediaTypeResolver().resolve(mappingNode);
            this.getMessages().addAll(mediaTypeValidations);
        }
        return true;
    }

    private String getResourceUri(NodeRule<?> resourceRule) {
        Object keyNode = ((DefaultTupleRule)resourceRule).getKey();
        return ((ScalarNode)keyNode).getValue();
    }

    private String getFullUri(NodeRule<?> resourceRule) {
        String fullUri = "";
        while (resourceRule instanceof ImplicitMapEntryRule) {
            Object keyNode = ((DefaultTupleRule)resourceRule).getKey();
            fullUri = ((ScalarNode)keyNode).getValue() + fullUri;
            resourceRule = ((DefaultTupleRule)resourceRule).getParentTupleRule();
        }
        return fullUri;
    }

    private boolean isBodyRule(NodeRule<?> rule) {
        return rule instanceof TypedTupleRule && ((TypedTupleRule)((Object)rule)).getValueType().getName().equals("org.raml.model.MimeType");
    }

    private boolean isResourceRule(NodeRule<?> rule) {
        return rule instanceof TypedTupleRule && ((TypedTupleRule)((Object)rule)).getValueType().getName().equals("org.raml.model.Resource");
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @Override
    public void onDocumentEnd(MappingNode node) {
        this.validateBaseUriAndVersion();
        super.onDocumentEnd(node);
    }

    private void validateBaseUriAndVersion() {
        BaseUriRule baseUriRule = (BaseUriRule)this.getRule("baseUri");
        SimpleRule versionRule = (SimpleRule)this.getRule("version");
        if (versionRule.getKeyNode() == null && baseUriRule.getParameters().contains(versionRule.getName())) {
            ScalarNode node = baseUriRule.getValueNode();
            this.getMessages().add(ValidationResult.createErrorResult("version parameter must exist in the API definition", node.getStartMark(), node.getEndMark()));
        }
    }

    private <T extends TupleRule> T getRule(String fieldName) {
        return (T)((DefaultTupleRule)this.getRuleContext().peek()).getRuleByFieldName(fieldName);
    }
}

