/*
 * Decompiled with CFR 0.152.
 */
package org.red5.client;

import java.io.IOException;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.red5.client.net.rtmp.ClientExceptionHandler;
import org.red5.client.net.rtmp.INetStreamEventHandler;
import org.red5.client.net.rtmp.RTMPClient;
import org.red5.io.utils.ObjectMap;
import org.red5.proxy.StreamingProxy;
import org.red5.server.api.event.IEvent;
import org.red5.server.api.event.IEventDispatcher;
import org.red5.server.api.service.IPendingServiceCall;
import org.red5.server.api.service.IPendingServiceCallback;
import org.red5.server.messaging.IMessage;
import org.red5.server.net.rtmp.event.IRTMPEvent;
import org.red5.server.net.rtmp.event.Notify;
import org.red5.server.stream.message.RTMPMessage;

public class StreamRelay {
    private static RTMPClient client;
    private static StreamingProxy proxy;
    private static Timer timer;
    private static String sourceStreamName;

    public static void main(String ... args) {
        if (args == null || args.length < 7) {
            System.out.println("Not enough args supplied. Usage: <source uri> <source app> <source stream name> <destination uri> <destination app> <destination stream name> <publish mode>");
        } else {
            String sourceHost = args[0];
            String destHost = args[3];
            String sourceApp = args[1];
            String destApp = args[4];
            int sourcePort = 1935;
            int destPort = 1935;
            sourceStreamName = args[2];
            String destStreamName = args[5];
            String publishMode = args[6];
            int colonIdx = sourceHost.indexOf(58);
            if (colonIdx > 0) {
                sourcePort = Integer.valueOf(sourceHost.substring(colonIdx + 1));
                sourceHost = sourceHost.substring(0, colonIdx);
                System.out.printf("Source host: %s port: %d\n", sourceHost, sourcePort);
            }
            if ((colonIdx = destHost.indexOf(58)) > 0) {
                destPort = Integer.valueOf(destHost.substring(colonIdx + 1));
                destHost = destHost.substring(0, colonIdx);
                System.out.printf("Destination host: %s port: %d\n", destHost, destPort);
            }
            timer = new Timer();
            proxy = new StreamingProxy();
            proxy.setHost(destHost);
            proxy.setPort(destPort);
            proxy.setApp(destApp);
            proxy.init();
            proxy.setConnectionClosedHandler(new Runnable(){

                @Override
                public void run() {
                    System.out.println("Publish connection has been closed, source will be disconnected");
                    client.disconnect();
                }
            });
            proxy.setExceptionHandler(new ClientExceptionHandler(){

                @Override
                public void handleException(Throwable throwable) {
                    throwable.printStackTrace();
                    System.exit(2);
                }
            });
            proxy.start(destStreamName, publishMode, new Object[0]);
            do {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } while (!proxy.isPublished());
            System.out.println("Publishing...");
            client = new RTMPClient();
            client.setStreamEventDispatcher(new StreamEventDispatcher());
            client.setStreamEventHandler(new INetStreamEventHandler(){

                @Override
                public void onStreamEvent(Notify notify) {
                    System.out.printf("onStreamEvent: %s\n", notify);
                    ObjectMap map = (ObjectMap)notify.getCall().getArguments()[0];
                    String code = (String)map.get((Object)"code");
                    System.out.printf("<:%s\n", code);
                    if ("NetStream.Play.StreamNotFound".equals(code)) {
                        System.out.println("Requested stream was not found");
                        client.disconnect();
                    } else if ("NetStream.Play.UnpublishNotify".equals(code) || "NetStream.Play.Complete".equals(code)) {
                        System.out.println("Source has stopped publishing or play is complete");
                        client.disconnect();
                    }
                }
            });
            client.setConnectionClosedHandler(new Runnable(){

                @Override
                public void run() {
                    System.out.println("Source connection has been closed, proxy will be stopped");
                    proxy.stop();
                }
            });
            client.setExceptionHandler(new ClientExceptionHandler(){

                @Override
                public void handleException(Throwable throwable) {
                    throwable.printStackTrace();
                    System.exit(1);
                }
            });
            Map<String, Object> defParams = client.makeDefaultConnectionParams(sourceHost, sourcePort, sourceApp);
            defParams.put("pageUrl", "");
            defParams.put("swfUrl", "app:/Red5-StreamRelay.swf");
            client.setSwfVerification(true);
            client.connect(sourceHost, sourcePort, defParams, new IPendingServiceCallback(){

                public void resultReceived(IPendingServiceCall call) {
                    System.out.println("connectCallback");
                    ObjectMap map = (ObjectMap)call.getResult();
                    String code = (String)map.get((Object)"code");
                    if ("NetConnection.Connect.Rejected".equals(code)) {
                        System.out.printf("Rejected: %s\n", map.get((Object)"description"));
                        client.disconnect();
                        proxy.stop();
                    } else if ("NetConnection.Connect.Success".equals(code)) {
                        timer.schedule((TimerTask)new BandwidthStatusTask(), 2000L);
                    } else {
                        System.out.printf("Unhandled response code: %s\n", code);
                    }
                }
            });
            do {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } while (!proxy.isRunning());
            System.out.println("Stream relay exit");
        }
    }

    private static final class PlayStatusTask
    extends TimerTask {
        private PlayStatusTask() {
        }

        @Override
        public void run() {
            System.out.println("Subscribed: " + client.isSubscribed());
            this.cancel();
            client.createStream(new CreateStreamCallback());
        }
    }

    private static final class BandwidthStatusTask
    extends TimerTask {
        private BandwidthStatusTask() {
        }

        @Override
        public void run() {
            System.out.println("Bandwidth check done: " + client.isBandwidthCheckDone());
            this.cancel();
            timer.schedule((TimerTask)new PlayStatusTask(), 1000L);
            client.subscribe(new SubscribeStreamCallBack(), new Object[]{sourceStreamName});
        }
    }

    private static final class CreateStreamCallback
    implements IPendingServiceCallback {
        private CreateStreamCallback() {
        }

        public void resultReceived(IPendingServiceCall call) {
            System.out.println("resultReceived: " + call);
            int streamId = (Integer)call.getResult();
            System.out.println("stream id: " + streamId);
            if (sourceStreamName.endsWith(".flv") || sourceStreamName.endsWith(".f4v") || sourceStreamName.endsWith(".mp4")) {
                client.play(streamId, sourceStreamName, 0, -1);
            } else {
                client.play(streamId, sourceStreamName, -1, 0);
            }
        }
    }

    private static final class SubscribeStreamCallBack
    implements IPendingServiceCallback {
        private SubscribeStreamCallBack() {
        }

        public void resultReceived(IPendingServiceCall call) {
            System.out.println("resultReceived: " + call);
        }
    }

    private static final class StreamEventDispatcher
    implements IEventDispatcher {
        private StreamEventDispatcher() {
        }

        public void dispatchEvent(IEvent event) {
            System.out.println("ClientStream.dispachEvent()" + event.toString());
            try {
                proxy.pushMessage(null, (IMessage)RTMPMessage.build((IRTMPEvent)((IRTMPEvent)event)));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

