/*
 * Decompiled with CFR 0.152.
 */
package org.red5.client.net.remoting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.util.EntityUtils;
import org.apache.mina.core.buffer.IoBuffer;
import org.red5.compatibility.flex.messaging.messages.AcknowledgeMessage;
import org.red5.compatibility.flex.messaging.messages.AcknowledgeMessageExt;
import org.red5.compatibility.flex.messaging.messages.AsyncMessageExt;
import org.red5.compatibility.flex.messaging.messages.CommandMessage;
import org.red5.io.amf3.Output;
import org.red5.io.client.IRemotingClient;
import org.red5.io.object.Deserializer;
import org.red5.io.object.Input;
import org.red5.io.object.RecordSet;
import org.red5.io.object.Serializer;
import org.red5.io.utils.ObjectMap;
import org.red5.server.net.remoting.RemotingClient;
import org.red5.server.net.remoting.RemotingHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DSRemotingClient
extends RemotingClient {
    protected static Logger log = LoggerFactory.getLogger(DSRemotingClient.class);
    private String dataSourceId = "nil";
    private int sequenceCounter = 1;

    public DSRemotingClient() {
        log.debug("DSRemotingClient created");
    }

    public DSRemotingClient(String url) {
        super(url, 30000);
        log.debug("DSRemotingClient created  - url: {}", (Object)url);
    }

    public String getDataSourceId() {
        return this.dataSourceId;
    }

    public void setDataSourceId(String dataSourceId) {
        this.dataSourceId = dataSourceId;
    }

    private IoBuffer encodeInvoke(String method, Object[] params) {
        log.debug("RemotingClient encodeInvoke - method: {} params: {}", (Object)method, (Object)params);
        IoBuffer result = IoBuffer.allocate((int)1024);
        result.setAutoExpand(true);
        result.putShort((short)3);
        Collection hdr = this.headers.values();
        result.putShort((short)hdr.size());
        for (RemotingHeader header : hdr) {
            Output.putString((IoBuffer)result, (String)header.getName());
            result.put(header.getMustUnderstand() ? (byte)1 : 0);
            IoBuffer tmp = IoBuffer.allocate((int)1024);
            tmp.setAutoExpand(true);
            Output tmpOut = new Output(tmp);
            Serializer.serialize((org.red5.io.object.Output)tmpOut, (Object)header.getValue());
            tmp.flip();
            result.putInt(tmp.limit());
            result.put(tmp);
            tmp.free();
            tmp = null;
        }
        result.putShort((short)1);
        Output.putString((IoBuffer)result, (String)method);
        Output.putString((IoBuffer)result, (String)("/" + this.sequenceCounter++));
        IoBuffer tmp = IoBuffer.allocate((int)1024);
        tmp.setAutoExpand(true);
        Output tmpOut = new Output(tmp);
        if (params == null) {
            tmpOut.writeNull();
        } else {
            tmpOut.writeArray(params);
        }
        tmp.flip();
        result.putInt(tmp.limit());
        result.put(tmp);
        tmp.free();
        tmp = null;
        result.flip();
        return result;
    }

    protected void processHeaders(IoBuffer in) {
        log.debug("RemotingClient processHeaders - buffer limit: {}", (Object)(in != null ? in.limit() : 0));
        int version = in.getUnsignedShort();
        log.debug("Version: {}", (Object)version);
        int count = in.getUnsignedShort();
        log.debug("Count: {}", (Object)count);
        org.red5.io.amf3.Input input = new org.red5.io.amf3.Input(in);
        for (int i = 0; i < count; ++i) {
            String name = input.getString();
            log.debug("Name: {}", (Object)name);
            boolean required = in.get() == 1;
            log.debug("Required: {}", (Object)required);
            Object value = null;
            int len = in.getInt();
            log.debug("Length: {}", (Object)len);
            if (len == -1) {
                in.get();
                len = in.getShort();
                log.debug("Corrected length: {}", (Object)len);
                value = input.readString(len);
            } else {
                value = Deserializer.deserialize((Input)input, Object.class);
            }
            log.debug("Value: {}", value);
            if ("AppendToGatewayUrl".equals(name)) {
                this.appendToUrl = (String)value;
                continue;
            }
            if ("ReplaceGatewayUrl".equals(name)) {
                this.url = (String)value;
                continue;
            }
            if ("RequestPersistentHeader".equals(name)) {
                if (value instanceof Map) {
                    Map valueMap = (Map)value;
                    RemotingHeader header = new RemotingHeader((String)valueMap.get("name"), ((Boolean)valueMap.get("mustUnderstand")).booleanValue(), valueMap.get("data"));
                    this.headers.put(header.getName(), header);
                    continue;
                }
                log.error("Expected Map but received {}", value);
                continue;
            }
            log.warn("Unsupported remoting header \"{}\" received with value \"{}\"", (Object)name, value);
        }
    }

    private Object decodeResult(IoBuffer data) {
        log.debug("decodeResult - data limit: {}", (Object)(data != null ? data.limit() : 0));
        this.processHeaders(data);
        org.red5.io.amf3.Input input = new org.red5.io.amf3.Input(data);
        String target = null;
        byte b = data.get();
        if (b == 0) {
            log.debug("NUL: {}", (Object)b);
            log.debug("SOH: {}", (Object)data.get());
        } else if (b == 1) {
            log.debug("SOH: {}", (Object)b);
        }
        short targetUriLength = data.getShort();
        log.debug("targetUri length: {}", (Object)targetUriLength);
        target = input.readString((int)targetUriLength);
        log.debug("NUL: {}", (Object)data.get());
        int count = data.getInt();
        if (count == -1) {
            log.debug("DC1: {}", (Object)data.get());
            count = 1;
        } else {
            data.position(data.position() - 4);
            count = data.getShort();
        }
        if (count != 1) {
            throw new RuntimeException("Expected exactly one result but got " + count);
        }
        String[] targetParts = target.split("[/]");
        if (targetParts.length > 1) {
            log.debug("Result sequence number: {}", (Object)targetParts[1]);
            target = targetParts[2];
        } else {
            target = target.substring(1);
        }
        log.debug("Target: {}", (Object)target);
        if ("onResult".equals(target)) {
            return input.readObject();
        }
        if ("onStatus".equals(target)) {
            return input.readObject();
        }
        return Deserializer.deserialize((Input)input, Object.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeMethod(String method, Object[] params) {
        log.debug("invokeMethod url: {}", (Object)(this.url + this.appendToUrl));
        IoBuffer resultBuffer = null;
        IoBuffer data = this.encodeInvoke(method, params);
        HttpPost post = null;
        try {
            post = new HttpPost(this.url + this.appendToUrl);
            post.addHeader("Content-Type", "application/x-amf");
            post.setEntity((HttpEntity)new InputStreamEntity(data.asInputStream(), (long)data.limit()));
            HttpResponse response = this.client.execute((HttpUriRequest)post);
            int code = response.getStatusLine().getStatusCode();
            log.debug("HTTP response code: {}", (Object)code);
            if (code / 100 != 2) {
                throw new RuntimeException("Didn't receive success from remoting server");
            }
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                int contentLength = (int)entity.getContentLength();
                if (contentLength < 1) {
                    contentLength = 16;
                }
                byte[] bytes = EntityUtils.toByteArray((HttpEntity)entity);
                resultBuffer = IoBuffer.wrap((byte[])bytes);
                resultBuffer.flip();
                Object result = this.decodeResult(resultBuffer);
                if (result instanceof RecordSet) {
                    ((RecordSet)result).setRemotingClient((IRemotingClient)this);
                }
                Object object = result;
                return object;
            }
        }
        catch (Exception ex) {
            log.error("Error while invoking remoting method.", (Throwable)ex);
            post.abort();
        }
        finally {
            if (resultBuffer != null) {
                resultBuffer.free();
                resultBuffer = null;
            }
            data.free();
            data = null;
        }
        return null;
    }

    private static final void dump(IoBuffer data) {
        log.debug("Hex: {}", (Object)data.getHexDump());
        int pos = data.position();
        byte[] bar = new byte[data.limit() - data.position()];
        data.get(bar);
        log.debug("Str {}", (Object)new String(bar));
        bar = null;
        data.position(pos);
    }

    public static void main(String[] args) {
        DSRemotingClient client = new DSRemotingClient("http://localhost:8400/meta/messagebroker/amfpolling");
        try {
            CommandMessage msg = new CommandMessage();
            msg.setCorrelationId("");
            msg.setDestination("");
            ObjectMap headerMap = new ObjectMap();
            headerMap.put((Object)"DSId", (Object)"nil");
            headerMap.put((Object)"DSMessagingVersion", (Object)1);
            msg.setHeaders((Map)headerMap);
            msg.setOperation(5);
            msg.setBody((Object)new Object[0]);
            Object response = client.invokeMethod("null", new Object[]{msg});
            log.debug("Response: {}\n{}", (Object)response.getClass().getName(), response);
            if (response instanceof AcknowledgeMessage || response instanceof AcknowledgeMessageExt) {
                log.info("Got first ACK");
                AcknowledgeMessage ack = (AcknowledgeMessage)response;
                Object id = ack.getHeader("DSId");
                if (id != null) {
                    log.info("Got DSId: {}", id);
                    client.setDataSourceId((String)id);
                }
            }
            do {
                Thread.sleep(1000L);
                log.info("Done with sleeping");
            } while (client.getDataSourceId().equals("nil"));
            msg = new CommandMessage();
            msg.setCorrelationId("");
            msg.setDestination("Red5Chat");
            headerMap = new ObjectMap();
            headerMap.put((Object)"DSId", (Object)client.getDataSourceId());
            headerMap.put((Object)"DSEndpoint", (Object)"my-polling-amf");
            msg.setHeaders((Map)headerMap);
            msg.setOperation(0);
            msg.setBody((Object)new Object[0]);
            response = client.invokeMethod("null", new Object[]{msg});
            if (response instanceof AcknowledgeMessage || response instanceof AcknowledgeMessageExt) {
                log.info("Got second ACK {}", (Object)((AcknowledgeMessage)response));
            }
            int loop = 12;
            do {
                Thread.sleep(5000L);
                log.info("Done with sleeping");
                msg = new CommandMessage();
                msg.setCorrelationId("");
                msg.setDestination("Red5Chat");
                headerMap = new ObjectMap();
                headerMap.put((Object)"DSId", (Object)client.getDataSourceId());
                msg.setHeaders((Map)headerMap);
                msg.setOperation(2);
                msg.setBody((Object)new Object[0]);
                response = client.invokeMethod("null", new Object[]{msg});
                if (response instanceof AcknowledgeMessage) {
                    AcknowledgeMessage ack = (AcknowledgeMessage)response;
                    log.info("Got ACK response {}", (Object)ack);
                    continue;
                }
                if (!(response instanceof CommandMessage)) continue;
                CommandMessage com = (CommandMessage)response;
                log.info("Got COM response {}", (Object)com);
                ArrayList list = (ArrayList)com.getBody();
                log.info("Child message body: {}", ((AsyncMessageExt)list.get(0)).getBody());
            } while (--loop > 0);
        }
        catch (Exception e) {
            log.warn("Exception {}", (Throwable)e);
        }
    }
}

