/*
 * Decompiled with CFR 0.152.
 */
package org.red5.client.net.rtmp;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.red5.client.net.rtmp.ClientExceptionHandler;
import org.red5.client.net.rtmp.INetStreamEventHandler;
import org.red5.client.net.rtmp.IRTMPClient;
import org.red5.io.utils.ObjectMap;
import org.red5.server.api.IConnection;
import org.red5.server.api.event.IEvent;
import org.red5.server.api.event.IEventDispatcher;
import org.red5.server.api.service.IPendingServiceCall;
import org.red5.server.api.service.IPendingServiceCallback;
import org.red5.server.api.service.IServiceCall;
import org.red5.server.api.service.IServiceInvoker;
import org.red5.server.api.so.IClientSharedObject;
import org.red5.server.api.stream.IClientStream;
import org.red5.server.api.stream.IStreamCapableConnection;
import org.red5.server.messaging.IMessage;
import org.red5.server.net.ICommand;
import org.red5.server.net.rtmp.BaseRTMPHandler;
import org.red5.server.net.rtmp.Channel;
import org.red5.server.net.rtmp.DeferredResult;
import org.red5.server.net.rtmp.IRTMPHandler;
import org.red5.server.net.rtmp.RTMPConnection;
import org.red5.server.net.rtmp.codec.RTMP;
import org.red5.server.net.rtmp.event.ChunkSize;
import org.red5.server.net.rtmp.event.ClientBW;
import org.red5.server.net.rtmp.event.IRTMPEvent;
import org.red5.server.net.rtmp.event.Invoke;
import org.red5.server.net.rtmp.event.Notify;
import org.red5.server.net.rtmp.event.Ping;
import org.red5.server.net.rtmp.event.SWFResponse;
import org.red5.server.net.rtmp.event.ServerBW;
import org.red5.server.net.rtmp.message.Header;
import org.red5.server.service.MethodNotFoundException;
import org.red5.server.service.PendingCall;
import org.red5.server.service.ServiceInvoker;
import org.red5.server.so.ClientSharedObject;
import org.red5.server.so.SharedObjectMessage;
import org.red5.server.stream.AbstractClientStream;
import org.red5.server.stream.OutputStream;
import org.red5.server.stream.consumer.ConnectionConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRTMPClientHandler
extends BaseRTMPHandler
implements IRTMPClient {
    private static final Logger log = LoggerFactory.getLogger(BaseRTMPClientHandler.class);
    protected String protocol = "rtmp";
    protected Map<String, Object> connectionParams;
    private Object[] connectArguments;
    private IPendingServiceCallback connectCallback;
    private Object serviceProvider;
    private IServiceInvoker serviceInvoker = new ServiceInvoker();
    private volatile ConcurrentMap<String, ClientSharedObject> sharedObjects = new ConcurrentHashMap<String, ClientSharedObject>(1, 0.9f, 1);
    private volatile ConcurrentMap<Number, NetStreamPrivateData> streamDataMap = new ConcurrentHashMap<Number, NetStreamPrivateData>(3, 0.75f, 1);
    private Runnable connectionClosedHandler;
    private ClientExceptionHandler exceptionHandler;
    private IEventDispatcher streamEventDispatcher;
    private INetStreamEventHandler streamEventHandler;
    protected volatile RTMPConnection conn;
    protected boolean bandwidthCheckDone;
    protected boolean subscribed;
    private boolean swfVerification;
    private int bytesReadWindow = 2500000;
    private int bytesWrittenWindow = 2500000;

    protected BaseRTMPClientHandler() {
    }

    protected abstract void startConnector(String var1, int var2);

    @Override
    public void connect(String server, int port, String application) {
        log.debug("connect server: {} port {} application {}", new Object[]{server, port, application});
        this.connect(server, port, application, null);
    }

    @Override
    public void connect(String server, int port, String application, IPendingServiceCallback connectCallback) {
        log.debug("connect server: {} port {} application {} connectCallback {}", new Object[]{server, port, application, connectCallback});
        this.connect(server, port, this.makeDefaultConnectionParams(server, port, application), connectCallback);
    }

    @Override
    public Map<String, Object> makeDefaultConnectionParams(String server, int port, String application) {
        ObjectMap params = new ObjectMap();
        params.put("app", application);
        params.put("objectEncoding", 0);
        params.put("fpad", Boolean.FALSE);
        params.put("flashVer", "WIN 11,2,202,235");
        params.put("audioCodecs", 3575);
        params.put("videoFunction", 1);
        params.put("pageUrl", null);
        params.put("path", application);
        params.put("capabilities", 15);
        params.put("swfUrl", null);
        params.put("videoCodecs", 252);
        return params;
    }

    @Override
    public void connect(String server, int port, Map<String, Object> connectionParams) {
        log.debug("connect server: {} port {} connectionParams {}", new Object[]{server, port, connectionParams});
        this.connect(server, port, connectionParams, null);
    }

    @Override
    public void connect(String server, int port, Map<String, Object> connectionParams, IPendingServiceCallback connectCallback) {
        this.connect(server, port, connectionParams, connectCallback, null);
    }

    @Override
    public void connect(String server, int port, Map<String, Object> connectionParams, IPendingServiceCallback connectCallback, Object[] connectCallArguments) {
        log.debug("connect server: {} port {} connect - params: {} callback: {} args: {}", new Object[]{server, port, connectionParams, connectCallback, Arrays.toString(connectCallArguments)});
        log.info("{}://{}:{}/{}", new Object[]{this.protocol, server, port, connectionParams.get("app")});
        this.connectionParams = connectionParams;
        this.connectArguments = connectCallArguments;
        if (!connectionParams.containsKey("objectEncoding")) {
            connectionParams.put("objectEncoding", 0);
        }
        this.connectCallback = connectCallback;
        this.startConnector(server, port);
    }

    @Override
    public void setServiceProvider(Object serviceProvider) {
        this.serviceProvider = serviceProvider;
    }

    @Override
    public void setConnectionClosedHandler(Runnable connectionClosedHandler) {
        log.debug("setConnectionClosedHandler: {}", (Object)connectionClosedHandler);
        this.connectionClosedHandler = connectionClosedHandler;
    }

    @Override
    public void setExceptionHandler(ClientExceptionHandler exceptionHandler) {
        log.debug("setExceptionHandler: {}", (Object)exceptionHandler);
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public IClientSharedObject getSharedObject(String name, boolean persistent) {
        log.debug("getSharedObject name: {} persistent {}", new Object[]{name, persistent});
        ClientSharedObject result = (ClientSharedObject)this.sharedObjects.get(name);
        if (result != null) {
            if (result.isPersistent() != persistent) {
                throw new RuntimeException("Already connected to a shared object with this name, but with different persistence.");
            }
            return result;
        }
        result = new ClientSharedObject(name, persistent);
        this.sharedObjects.put(name, result);
        return result;
    }

    protected void onChunkSize(RTMPConnection conn, Channel channel, Header source, ChunkSize chunkSize) {
        log.debug("onChunkSize");
        RTMP state = conn.getState();
        state.setReadChunkSize(chunkSize.getSize());
        state.setWriteChunkSize(chunkSize.getSize());
        log.info("ChunkSize is not fully implemented: {}", (Object)chunkSize);
    }

    protected void onPing(RTMPConnection conn, Channel channel, Header source, Ping ping) {
        log.trace("onPing");
        switch (ping.getEventType()) {
            case 0: 
            case 1: 
            case 4: 
            case 6: {
                Ping pong = new Ping();
                pong.setEventType((short)7);
                pong.setValue2((Number)((int)(System.currentTimeMillis() & 0xFFFFFFFFFFFFFFFFL)));
                conn.ping(pong);
                break;
            }
            case 2: {
                log.debug("Stream indicates there is no data available");
                break;
            }
            case 3: {
                IClientStream stream = null;
                Number streamId = ping.getValue2();
                int buffer = ping.getValue3();
                log.debug("Client sent a buffer size: {} ms for stream id: {}", (Object)buffer, (Object)streamId);
                stream = conn.getStreamById(streamId);
                if (stream != null) {
                    stream.setClientBufferDuration(buffer);
                    log.info("Setting client buffer on stream: {}", (Object)buffer);
                }
                if (stream != null) break;
                conn.rememberStreamBufferDuration(streamId.intValue(), buffer);
                log.info("Remembering client buffer on stream: {}", (Object)buffer);
                break;
            }
            case 26: {
                log.debug("SWF verification ping");
                SWFResponse swfPong = new SWFResponse(new byte[42]);
                conn.ping((Ping)swfPong);
                break;
            }
            case 31: {
                log.debug("Buffer empty ping");
                break;
            }
            case 32: {
                log.debug("Buffer full ping");
                break;
            }
            default: {
                log.warn("Unhandled ping: {}", (Object)ping);
            }
        }
    }

    protected void onServerBandwidth(RTMPConnection conn, Channel channel, ServerBW message) {
        log.trace("onServerBandwidth");
        int bandwidth = message.getBandwidth();
        if (bandwidth != this.bytesReadWindow) {
            ClientBW clientBw = new ClientBW(bandwidth, 2);
            channel.write((IRTMPEvent)clientBw);
        }
    }

    protected void onClientBandwidth(RTMPConnection conn, Channel channel, ClientBW message) {
        log.trace("onClientBandwidth");
        int bandwidth = message.getBandwidth();
        if (bandwidth != this.bytesWrittenWindow) {
            ServerBW serverBw = new ServerBW(bandwidth);
            channel.write((IRTMPEvent)serverBw);
        }
    }

    protected void onSharedObject(RTMPConnection conn, Channel channel, Header source, SharedObjectMessage object) {
        log.trace("onSharedObject");
        ClientSharedObject so = (ClientSharedObject)this.sharedObjects.get(object.getName());
        if (so != null) {
            if (so.isPersistent() == object.isPersistent()) {
                log.debug("Received SO request: {}", (Object)object);
                so.dispatchEvent((IEvent)object);
            } else {
                log.error("Ignoring request for wrong-persistent SO: {}", (Object)object);
            }
        } else {
            log.error("Ignoring request for non-existend SO: {}", (Object)object);
        }
    }

    public void onBWCheck() {
        log.debug("onBWCheck");
    }

    public void onBWCheck(Object params) {
        log.debug("onBWCheck: {}", params);
    }

    public void onBWDone(Object params) {
        log.debug("onBWDone: {}", params);
        this.bandwidthCheckDone = true;
    }

    public void onBWDone() {
        log.debug("onBWDone");
        this.bandwidthCheckDone = true;
    }

    @Override
    public void invoke(String method, IPendingServiceCallback callback) {
        log.debug("invoke method: {} params {} callback {}", new Object[]{method, callback});
        if (this.conn != null) {
            this.conn.invoke(method, callback);
        } else {
            log.info("Connection was null");
            PendingCall result = new PendingCall(method);
            result.setStatus((byte)32);
            callback.resultReceived((IPendingServiceCall)result);
        }
    }

    @Override
    public void invoke(String method, Object[] params, IPendingServiceCallback callback) {
        log.debug("invoke method: {} params {} callback {}", new Object[]{method, params, callback});
        if (this.conn != null) {
            this.conn.invoke(method, params, callback);
        } else {
            log.info("Connection was null");
            PendingCall result = new PendingCall(method, params);
            result.setStatus((byte)32);
            callback.resultReceived((IPendingServiceCall)result);
        }
    }

    @Override
    public void disconnect() {
        log.debug("disconnect");
        if (this.conn != null) {
            this.streamDataMap.clear();
            this.conn.close();
        } else {
            log.info("Connection was null");
        }
    }

    @Override
    public void createStream(IPendingServiceCallback callback) {
        log.debug("createStream - callback: {}", (Object)callback);
        CreateStreamCallBack wrapper = new CreateStreamCallBack(callback);
        this.invoke("createStream", null, wrapper);
    }

    public void releaseStream(IPendingServiceCallback callback, Object[] params) {
        log.debug("releaseStream - callback: {}", (Object)callback);
        ReleaseStreamCallBack wrapper = new ReleaseStreamCallBack(callback);
        this.invoke("releaseStream", params, wrapper);
    }

    public void deleteStream(IPendingServiceCallback callback) {
        log.debug("deleteStream - callback: {}", (Object)callback);
        DeleteStreamCallBack wrapper = new DeleteStreamCallBack(callback);
        this.invoke("deleteStream", null, wrapper);
    }

    public void subscribe(IPendingServiceCallback callback, Object[] params) {
        log.debug("subscribe - callback: {}", (Object)callback);
        SubscribeStreamCallBack wrapper = new SubscribeStreamCallBack(callback);
        this.invoke("FCSubscribe", params, wrapper);
    }

    @Override
    public void publish(Number streamId, String name, String mode, INetStreamEventHandler handler) {
        log.debug("publish - stream id: {}, name: {}, mode: {}", new Object[]{streamId, name, mode});
        if (handler != null) {
            NetStreamPrivateData streamData = (NetStreamPrivateData)this.streamDataMap.get(streamId);
            if (streamData != null) {
                log.debug("Setting handler on stream data - handler: {}", (Object)handler);
                streamData.handler = handler;
            } else {
                log.debug("Stream data not found for stream id: {}", (Object)streamId);
            }
        }
        Object[] params = new Object[]{name, mode};
        PendingCall pendingCall = new PendingCall("publish", params);
        this.conn.invoke((IServiceCall)pendingCall, this.getChannelForStreamId(streamId));
    }

    @Override
    public void unpublish(Number streamId) {
        log.debug("unpublish stream {}", (Object)streamId);
        PendingCall pendingCall = new PendingCall("publish", new Object[]{false});
        this.conn.invoke((IServiceCall)pendingCall, this.getChannelForStreamId(streamId));
    }

    @Override
    public void publishStreamData(Number streamId, IMessage message) {
        NetStreamPrivateData streamData = (NetStreamPrivateData)this.streamDataMap.get(streamId);
        log.debug("publishStreamData - stream data map: {}", this.streamDataMap);
        if (streamData != null) {
            if (streamData.connConsumer != null) {
                streamData.connConsumer.pushMessage(null, message);
            } else {
                log.warn("Connection consumer was not found for stream id: {}", (Object)streamId);
            }
        } else {
            log.warn("Stream data not found for stream id: {}", (Object)streamId);
        }
    }

    @Override
    public void play(Number streamId, String name, int start, int length) {
        log.debug("play stream {}, name: {}, start {}, length {}", new Object[]{streamId, name, start, length});
        if (this.conn != null) {
            int channel = this.getChannelForStreamId(streamId);
            this.ping((short)3, streamId, 2000);
            PendingCall receiveAudioCall = new PendingCall("receiveAudio");
            this.conn.invoke((IServiceCall)receiveAudioCall, channel);
            PendingCall receiveVideoCall = new PendingCall("receiveVideo");
            this.conn.invoke((IServiceCall)receiveVideoCall, channel);
            Object[] params = new Object[]{name, start >= 1000 || start <= -1000 ? start : start * 1000, length >= 1000 || length <= -1000 ? length : length * 1000};
            PendingCall pendingCall = new PendingCall("play", params);
            this.conn.invoke((IServiceCall)pendingCall, channel);
        } else {
            log.info("Connection was null ?");
        }
    }

    @Override
    public void play2(Number streamId, Map<String, ?> playOptions) {
        log.debug("play2 options: {}", (Object)playOptions.toString());
        String transition = (String)playOptions.get("transition");
        if (this.conn != null) {
            if ("NetStreamPlayTransitions.STOP".equals(transition)) {
                PendingCall pendingCall = new PendingCall("play", new Object[]{Boolean.FALSE});
                this.conn.invoke((IServiceCall)pendingCall, this.getChannelForStreamId(streamId));
            } else if (!"NetStreamPlayTransitions.RESET".equals(transition)) {
                Object[] params = new Object[6];
                params[0] = playOptions.get("streamName").toString();
                Object o = playOptions.get("start");
                params[1] = o instanceof Integer ? (Integer)o : Integer.valueOf((String)o);
                o = playOptions.get("len");
                params[2] = o instanceof Integer ? (Integer)o : Integer.valueOf((String)o);
                params[3] = transition;
                params[4] = playOptions.get("offset");
                params[5] = playOptions.get("oldStreamName");
                PendingCall pendingCall = new PendingCall("play2", params);
                this.conn.invoke((IServiceCall)pendingCall, this.getChannelForStreamId(streamId));
            }
        } else {
            log.info("Connection was null ?");
        }
    }

    public void ping(short pingType, Number streamId, int param) {
        this.conn.ping(new Ping(pingType, streamId, param));
    }

    public void connectionOpened(RTMPConnection conn) {
        log.trace("connectionOpened - conn: {}", (Object)conn);
        Channel channel = conn.getChannel(3);
        PendingCall pendingCall = new PendingCall("connect");
        pendingCall.setArguments(this.connectArguments);
        Invoke invoke = new Invoke((IPendingServiceCall)pendingCall);
        invoke.setConnectionParams(this.connectionParams);
        invoke.setTransactionId(1);
        if (this.connectCallback != null) {
            pendingCall.registerCallback(this.connectCallback);
        }
        conn.registerPendingCall(invoke.getTransactionId(), (IPendingServiceCall)pendingCall);
        log.debug("Writing 'connect' invoke: {}, invokeId: {}", (Object)invoke, (Object)invoke.getTransactionId());
        channel.write((IRTMPEvent)invoke);
    }

    public void connectionClosed(RTMPConnection conn) {
        log.debug("connectionClosed");
        super.connectionClosed(conn);
        if (this.connectionClosedHandler != null) {
            Thread t = new Thread(this.connectionClosedHandler);
            t.setDaemon(true);
            t.start();
        }
    }

    protected void onCommand(RTMPConnection conn, Channel channel, Header source, ICommand command) {
        log.trace("onCommand: {}, id: {}", (Object)command, (Object)command.getTransactionId());
        IServiceCall call = command.getCall();
        String methodName = call.getServiceMethodName();
        log.debug("Service name: {} args[0]: {}", (Object)methodName, call.getArguments().length != 0 ? call.getArguments()[0] : "");
        if ("_result".equals(methodName) || "_error".equals(methodName)) {
            Integer encoding;
            IPendingServiceCall pendingCall = conn.getPendingCall(command.getTransactionId());
            log.debug("Received result for pending call - {}", (Object)pendingCall);
            if (pendingCall != null && "connect".equals(methodName) && (encoding = (Integer)this.connectionParams.get("objectEncoding")) != null && encoding == 3) {
                log.debug("Setting encoding to AMF3");
                conn.getState().setEncoding(IConnection.Encoding.AMF3);
            }
            this.handlePendingCallResult(conn, (Invoke)command);
            return;
        }
        boolean onStatus = "onStatus".equals(methodName);
        log.debug("onStatus {}", (Object)onStatus);
        if (onStatus) {
            Number streamId = source.getStreamId();
            if (log.isDebugEnabled()) {
                log.debug("Stream id from header: {}", (Object)streamId);
                ObjectMap objMap = (ObjectMap)call.getArguments()[0];
                log.debug("Client id from status: {}", objMap.get((Object)"clientid"));
            }
            if (streamId != null) {
                NetStreamPrivateData streamData = (NetStreamPrivateData)this.streamDataMap.get(streamId);
                if (streamData == null) {
                    log.debug("Stream data was not found by id. Map contents: {}", this.streamDataMap);
                    if (!this.streamDataMap.isEmpty()) {
                        streamData = (NetStreamPrivateData)this.streamDataMap.values().iterator().next();
                    }
                }
                if (streamData == null) {
                    log.warn("Stream data was null for id: {}", (Object)streamId);
                }
                if (streamData != null && streamData.handler != null) {
                    log.debug("Got stream data and handler");
                    streamData.handler.onStreamEvent((Notify)command);
                }
            }
        }
        if (this.serviceProvider == null) {
            call.setStatus((byte)17);
            call.setException((Exception)new MethodNotFoundException(methodName));
            log.info("No service provider / method not found; to handle calls like onBWCheck, add a service provider");
        } else {
            this.serviceInvoker.invoke(call, this.serviceProvider);
        }
        if (call instanceof IPendingServiceCall) {
            IPendingServiceCall psc = (IPendingServiceCall)call;
            Object result = psc.getResult();
            log.debug("Pending call result is: {}", result);
            if (result instanceof DeferredResult) {
                DeferredResult dr = (DeferredResult)result;
                dr.setTransactionId(command.getTransactionId());
                dr.setServiceCall(psc);
                dr.setChannel(channel);
                conn.registerDeferredResult(dr);
            } else if (!onStatus) {
                if ("onBWCheck".equals(methodName)) {
                    this.onBWCheck(call.getArguments().length > 0 ? call.getArguments()[0] : null);
                    Invoke reply = new Invoke();
                    reply.setCall(call);
                    reply.setTransactionId(command.getTransactionId());
                    channel.write((IRTMPEvent)reply);
                } else if ("onBWDone".equals(methodName)) {
                    this.onBWDone(call.getArguments().length > 0 ? call.getArguments()[0] : null);
                } else {
                    Invoke reply = new Invoke();
                    reply.setCall(call);
                    reply.setTransactionId(command.getTransactionId());
                    log.debug("Sending empty call reply: {}", (Object)reply);
                    channel.write((IRTMPEvent)reply);
                }
            }
        }
    }

    public void handleException(Throwable throwable) {
        log.debug("Handle exception: {} with: {}", (Object)throwable.getMessage(), (Object)this.exceptionHandler);
        if (this.exceptionHandler == null) {
            log.error("Connection exception", throwable);
            throw new RuntimeException(throwable);
        }
        this.exceptionHandler.handleException(throwable);
    }

    protected int getChannelForStreamId(Number streamId) {
        return (streamId.intValue() - 1) * 5 + 4;
    }

    public void setProtocol(String protocol) throws Exception {
        this.protocol = protocol;
    }

    public void setConnection(RTMPConnection conn) {
        this.conn = conn;
        this.conn.setHandler((IRTMPHandler)this);
    }

    @Override
    public RTMPConnection getConnection() {
        return this.conn;
    }

    public void setSwfVerification(boolean enabled) {
        this.swfVerification = enabled;
    }

    public boolean isSwfVerification() {
        return this.swfVerification;
    }

    public boolean isBandwidthCheckDone() {
        return this.bandwidthCheckDone;
    }

    public boolean isSubscribed() {
        return this.subscribed;
    }

    public Map<String, Object> getConnectionParams() {
        return this.connectionParams;
    }

    @Override
    public void setStreamEventDispatcher(IEventDispatcher streamEventDispatcher) {
        this.streamEventDispatcher = streamEventDispatcher;
    }

    public void setStreamEventHandler(INetStreamEventHandler streamEventHandler) {
        this.streamEventHandler = streamEventHandler;
    }

    private final class NetStreamPrivateData {
        public volatile INetStreamEventHandler handler;
        public volatile OutputStream outputStream;
        public volatile ConnectionConsumer connConsumer;

        private NetStreamPrivateData() {
            if (BaseRTMPClientHandler.this.streamEventHandler != null) {
                this.handler = BaseRTMPClientHandler.this.streamEventHandler;
            }
        }
    }

    private class SubscribeStreamCallBack
    implements IPendingServiceCallback {
        private IPendingServiceCallback wrapped;

        public SubscribeStreamCallBack(IPendingServiceCallback wrapped) {
            log.debug("SubscribeStreamCallBack {}", (Object)wrapped.getClass().getName());
            this.wrapped = wrapped;
        }

        public void resultReceived(IPendingServiceCall call) {
            ObjectMap map;
            log.debug("resultReceived", (Object)call);
            if (call.getResult() instanceof ObjectMap && (map = (ObjectMap)call.getResult()).containsKey((Object)"code")) {
                String code = (String)map.get((Object)"code");
                log.debug("Code: {}", (Object)code);
                if ("NetStream.Play.Start".equals(code)) {
                    BaseRTMPClientHandler.this.subscribed = true;
                }
            }
            this.wrapped.resultReceived(call);
        }
    }

    private class DeleteStreamCallBack
    implements IPendingServiceCallback {
        private IPendingServiceCallback wrapped;

        public DeleteStreamCallBack(IPendingServiceCallback wrapped) {
            log.debug("DeleteStreamCallBack {}", (Object)wrapped.getClass().getName());
            this.wrapped = wrapped;
        }

        public void resultReceived(IPendingServiceCall call) {
            Number streamId = (Number)call.getResult();
            log.debug("Stream id: {}", (Object)streamId);
            log.debug("Connection: {}", (Object)BaseRTMPClientHandler.this.conn);
            log.debug("DeleteStreamCallBack resultReceived - stream id: {}", (Object)streamId);
            if (BaseRTMPClientHandler.this.conn != null && streamId != null) {
                log.debug("Deleting net stream");
                BaseRTMPClientHandler.this.conn.removeClientStream(streamId);
                BaseRTMPClientHandler.this.streamDataMap.remove(streamId);
            }
            this.wrapped.resultReceived(call);
        }
    }

    private class ReleaseStreamCallBack
    implements IPendingServiceCallback {
        private IPendingServiceCallback wrapped;

        public ReleaseStreamCallBack(IPendingServiceCallback wrapped) {
            log.debug("ReleaseStreamCallBack {}", (Object)wrapped.getClass().getName());
            this.wrapped = wrapped;
        }

        public void resultReceived(IPendingServiceCall call) {
            this.wrapped.resultReceived(call);
        }
    }

    private class CreateStreamCallBack
    implements IPendingServiceCallback {
        private IPendingServiceCallback wrapped;

        public CreateStreamCallBack(IPendingServiceCallback wrapped) {
            log.debug("CreateStreamCallBack {}", (Object)wrapped.getClass().getName());
            this.wrapped = wrapped;
        }

        public void resultReceived(IPendingServiceCall call) {
            Number streamId = (Number)call.getResult();
            log.debug("CreateStreamCallBack resultReceived - stream id: {} call: {}", (Object)streamId, (Object)call);
            log.debug("Connection: {}", (Object)BaseRTMPClientHandler.this.conn);
            if (BaseRTMPClientHandler.this.conn != null && streamId != null) {
                log.debug("Setting new net stream");
                NetStream stream = new NetStream(BaseRTMPClientHandler.this.streamEventDispatcher);
                stream.setConnection((IStreamCapableConnection)BaseRTMPClientHandler.this.conn);
                stream.setStreamId(streamId);
                BaseRTMPClientHandler.this.conn.addClientStream((IClientStream)stream);
                NetStreamPrivateData streamData = new NetStreamPrivateData();
                streamData.outputStream = BaseRTMPClientHandler.this.conn.createOutputStream(streamId);
                streamData.connConsumer = new ConnectionConsumer(BaseRTMPClientHandler.this.conn, streamData.outputStream.getVideo(), streamData.outputStream.getAudio(), streamData.outputStream.getData());
                BaseRTMPClientHandler.this.streamDataMap.put(streamId, streamData);
                log.debug("streamDataMap: {}", (Object)BaseRTMPClientHandler.this.streamDataMap);
            }
            this.wrapped.resultReceived(call);
        }
    }

    private static class NetStream
    extends AbstractClientStream
    implements IEventDispatcher {
        private IEventDispatcher dispatcher;

        public NetStream(IEventDispatcher dispatcher) {
            this.dispatcher = dispatcher;
        }

        public void close() {
            log.debug("NetStream close");
        }

        public void start() {
            log.debug("NetStream start");
        }

        public void stop() {
            log.debug("NetStream stop");
        }

        public void dispatchEvent(IEvent event) {
            log.debug("NetStream dispatchEvent: {}", (Object)event);
            if (this.dispatcher != null) {
                this.dispatcher.dispatchEvent(event);
            }
        }
    }
}

