/*
 * Decompiled with CFR 0.152.
 */
package org.red5.client.net.rtmp;

import java.io.File;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.KeyPair;
import java.util.Arrays;
import org.apache.commons.codec.binary.Hex;
import org.apache.mina.core.buffer.IoBuffer;
import org.bouncycastle.util.BigIntegers;
import org.red5.server.net.rtmp.RTMPHandshake;
import org.red5.server.util.FileUtil;
import org.slf4j.LoggerFactory;

public class OutboundHandshake
extends RTMPHandshake {
    private byte[] outgoingDigest = new byte[32];
    private byte[] incomingDigest = new byte[32];
    private byte[] swfHash;
    private int digestPosClient;
    private int digestPosServer;
    private byte[] c1 = null;
    private byte[] s1 = null;

    public OutboundHandshake() {
        super((byte)3);
        this.log = LoggerFactory.getLogger(OutboundHandshake.class);
    }

    public OutboundHandshake(byte handshakeType) {
        super(handshakeType);
        this.log = LoggerFactory.getLogger(OutboundHandshake.class);
    }

    public OutboundHandshake(byte handshakeType, int algorithm) {
        this(handshakeType);
        this.algorithm = algorithm;
    }

    public IoBuffer doHandshake(IoBuffer input) {
        throw new UnsupportedOperationException("Not used, call server response decoders directly");
    }

    protected void createHandshakeBytes() {
        this.log.trace("createHandshakeBytes");
        BigInteger bi = new BigInteger(12288, random);
        this.handshakeBytes = BigIntegers.asUnsignedByteArray((BigInteger)bi);
        if (this.handshakeBytes.length < 1536) {
            ByteBuffer b = ByteBuffer.allocate(1536);
            b.put(this.handshakeBytes);
            b.put((byte)19);
            b.flip();
            this.handshakeBytes = b.array();
        }
    }

    public IoBuffer generateClientRequest1() {
        this.log.debug("generateClientRequest1");
        IoBuffer request = IoBuffer.allocate((int)1537);
        request.put(this.handshakeType);
        if (this.useEncryption() || this.swfSize > 0) {
            this.fp9Handshake = true;
            this.algorithm = 1;
        }
        int time = 5;
        this.handshakeBytes[0] = (byte)(time >>> 24);
        this.handshakeBytes[1] = (byte)(time >>> 16);
        this.handshakeBytes[2] = (byte)(time >>> 8);
        this.handshakeBytes[3] = (byte)time;
        if (this.fp9Handshake) {
            this.handshakeBytes[4] = -128;
            this.handshakeBytes[5] = 0;
            this.handshakeBytes[6] = 7;
            this.handshakeBytes[7] = 2;
        } else {
            this.log.debug("Using pre-version 9.0.115.0 handshake");
            this.handshakeBytes[4] = 0;
            this.handshakeBytes[5] = 0;
            this.handshakeBytes[6] = 0;
            this.handshakeBytes[7] = 0;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Time and version handshake bytes: {}", (Object)Hex.encodeHexString((byte[])Arrays.copyOf(this.handshakeBytes, 8)));
        }
        if (this.fp9Handshake) {
            if (this.useEncryption()) {
                KeyPair keys = this.generateKeyPair();
                this.outgoingPublicKey = this.getPublicKey(keys);
                this.log.debug("Client public key: {}", (Object)Hex.encodeHexString((byte[])this.outgoingPublicKey));
                int clientDHOffset = this.getDHOffset(this.algorithm, this.handshakeBytes, 0);
                this.log.trace("Outgoing DH offset: {}", (Object)clientDHOffset);
                System.arraycopy(this.outgoingPublicKey, 0, this.handshakeBytes, clientDHOffset, 128);
                switch (this.handshakeType) {
                    case 6: {
                        break;
                    }
                    case 8: {
                        break;
                    }
                }
            }
            this.digestPosClient = this.getDigestOffset(this.algorithm, this.handshakeBytes, 0);
            this.log.debug("Client digest position offset: {} algorithm: {}", (Object)this.digestPosClient, (Object)this.algorithm);
            this.c1 = new byte[1536];
            System.arraycopy(this.handshakeBytes, 0, this.c1, 0, 1536);
            this.calculateDigest(this.digestPosClient, this.handshakeBytes, 0, GENUINE_FP_KEY, 30, this.c1, this.digestPosClient);
            System.arraycopy(this.c1, this.digestPosClient, this.outgoingDigest, 0, 32);
            this.log.debug("Client digest: {}", (Object)Hex.encodeHexString((byte[])this.outgoingDigest));
            this.log.debug("Digest is valid: {}", (Object)this.verifyDigest(this.digestPosClient, this.c1, RTMPHandshake.GENUINE_FP_KEY, 30));
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("C1: {}", (Object)Hex.encodeHexString((byte[])this.c1));
        }
        request.put(this.c1);
        request.flip();
        this.handshakeBytes = null;
        return request;
    }

    public IoBuffer decodeServerResponse1(IoBuffer in) {
        this.log.debug("decodeServerResponse1");
        IoBuffer response = null;
        if (in.hasArray()) {
            this.s1 = in.array();
        } else {
            this.s1 = new byte[1536];
            in.get(this.s1);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Server version {}", (Object)Hex.encodeHexString((byte[])Arrays.copyOfRange(this.s1, 4, 8)));
        }
        if (this.fp9Handshake && this.handshakeType == 3 && this.s1[4] == 0) {
            this.log.debug("Switching to pre-fp9 handshake");
            this.fp9Handshake = false;
        }
        if (this.fp9Handshake) {
            if (!this.getServerDigestPosition()) {
                return null;
            }
            System.arraycopy(this.s1, this.digestPosServer, this.incomingDigest, 0, 32);
            this.log.debug("Server digest: {}", (Object)Hex.encodeHexString((byte[])this.incomingDigest));
            if (this.swfSize > 0) {
                this.calculateSwfVerification(this.s1, this.swfHash, this.swfSize);
            }
            if (this.useEncryption()) {
                int serverDHOffset = this.getDHOffset(this.algorithm, this.s1, 0);
                this.log.trace("Incoming DH offset: {}", (Object)serverDHOffset);
                this.incomingPublicKey = new byte[128];
                System.arraycopy(this.s1, serverDHOffset, this.incomingPublicKey, 0, 128);
                this.log.debug("Server public key: {}", (Object)Hex.encodeHexString((byte[])this.incomingPublicKey));
                this.initRC4Encryption(this.getSharedSecret(this.incomingPublicKey, this.keyAgreement));
                switch (this.handshakeType) {
                    case 6: {
                        byte[] dummyBytes = new byte[1536];
                        this.cipherIn.update(dummyBytes);
                        this.cipherOut.update(dummyBytes);
                        break;
                    }
                    case 8: {
                        break;
                    }
                }
            }
            BigInteger bi = new BigInteger(12288, random);
            byte[] c2 = BigIntegers.asUnsignedByteArray((BigInteger)bi);
            byte[] signatureResp = new byte[32];
            byte[] digestResp = new byte[32];
            this.calculateHMAC_SHA256(this.s1, this.digestPosServer, 32, GENUINE_FP_KEY, GENUINE_FP_KEY.length, digestResp, 0);
            this.calculateHMAC_SHA256(c2, 0, 1504, digestResp, 32, signatureResp, 0);
            this.log.debug("Calculated digest key from secure key and server digest: {}", (Object)Hex.encodeHexString((byte[])digestResp));
            if (this.handshakeType == 8) {
                this.log.debug("RTMPE type 8 XTEA");
                for (int i = 0; i < 32; i += 8) {
                }
            } else if (this.handshakeType == 9) {
                this.log.debug("RTMPE type 9 Blowfish");
                for (int i = 0; i < 32; i += 8) {
                }
            }
            this.log.debug("Client signature calculated: {}", (Object)Hex.encodeHexString((byte[])signatureResp));
            response = IoBuffer.allocate((int)1536);
            response.put(c2, 0, 1504);
            response.put(signatureResp);
            response.flip();
        } else {
            response = IoBuffer.allocate((int)1536);
            response.put(this.s1, 0, 1536);
            response.flip();
        }
        return response;
    }

    public boolean decodeServerResponse2(IoBuffer in) {
        byte[] s2;
        this.log.debug("decodeServerResponse2");
        if (in.hasArray()) {
            s2 = in.array();
        } else {
            s2 = new byte[1536];
            in.get(s2);
        }
        if (this.fp9Handshake) {
            if (s2[4] == 0 && s2[5] == 0 && s2[6] == 0 && s2[7] == 0) {
                this.log.warn("Server refused signed authentication");
            }
            byte[] signature = new byte[32];
            byte[] digest = new byte[32];
            this.calculateHMAC_SHA256(this.c1, this.digestPosClient, 32, GENUINE_FMS_KEY, GENUINE_FMS_KEY.length, digest, 0);
            this.calculateHMAC_SHA256(s2, 0, 1504, digest, 32, signature, 0);
            this.log.debug("Digest key: {}", (Object)Hex.encodeHexString((byte[])digest));
            if (this.handshakeType == 8) {
                this.log.debug("RTMPE type 8 XTEA");
                for (int i = 0; i < 32; i += 8) {
                }
            } else if (this.handshakeType == 9) {
                this.log.debug("RTMPE type 9 Blowfish");
                for (int i = 0; i < 32; i += 8) {
                }
            }
            this.log.debug("Signature calculated: {}", (Object)Hex.encodeHexString((byte[])signature));
            this.log.debug("Server sent signature: {}", (Object)Hex.encodeHexString((byte[])s2));
            if (!Arrays.equals(signature, Arrays.copyOfRange(s2, 1504, 1536))) {
                this.log.info("Server not genuine");
                return false;
            }
            this.log.debug("Compatible flash server");
        } else if (!Arrays.equals(s2, this.c1)) {
            this.log.info("Client signature doesn't match!");
        }
        return true;
    }

    private boolean getServerDigestPosition() {
        boolean result = false;
        this.log.trace("Trying algorithm: {}", (Object)this.algorithm);
        this.digestPosServer = this.getDigestOffset(this.algorithm, this.s1, 0);
        this.log.debug("Server digest position offset: {}", (Object)this.digestPosServer);
        result = this.verifyDigest(this.digestPosServer, this.s1, GENUINE_FMS_KEY, 36);
        if (!result) {
            this.algorithm ^= 1;
            this.log.trace("Trying algorithm: {}", (Object)this.algorithm);
            this.digestPosServer = this.getDigestOffset(this.algorithm, this.s1, 0);
            this.log.debug("Server digest position offset: {}", (Object)this.digestPosServer);
            result = this.verifyDigest(this.digestPosServer, this.s1, GENUINE_FMS_KEY, 36);
            if (!result) {
                this.log.warn("Server digest verification failed");
            } else {
                this.log.debug("Server digest verified");
            }
        } else {
            this.log.debug("Server digest verified");
        }
        return result;
    }

    public boolean validate(byte[] handshake) {
        if (this.validateScheme(handshake, 0)) {
            this.algorithm = 0;
            return true;
        }
        if (this.validateScheme(handshake, 1)) {
            this.algorithm = 1;
            return true;
        }
        this.log.error("Unable to validate server");
        return false;
    }

    private boolean validateScheme(byte[] handshake, int scheme) {
        int digestOffset = -1;
        switch (scheme) {
            case 0: {
                digestOffset = this.getDigestOffset1(handshake, 0);
                break;
            }
            case 1: {
                digestOffset = this.getDigestOffset2(handshake, 0);
                break;
            }
            default: {
                this.log.error("Unknown algorithm: {}", (Object)scheme);
            }
        }
        this.log.debug("Algorithm: {} digest offset: {}", (Object)scheme, (Object)digestOffset);
        byte[] tempBuffer = new byte[1504];
        System.arraycopy(handshake, 0, tempBuffer, 0, digestOffset);
        System.arraycopy(handshake, digestOffset + 32, tempBuffer, digestOffset, 1536 - digestOffset - 32);
        byte[] tempHash = new byte[32];
        this.calculateHMAC_SHA256(tempBuffer, 0, tempBuffer.length, GENUINE_FMS_KEY, 36, tempHash, 0);
        this.log.debug("Hash: {}", (Object)Hex.encodeHexString((byte[])tempHash));
        boolean result = true;
        for (int i = 0; i < 32; ++i) {
            if (handshake[digestOffset + i] == tempHash[i]) continue;
            result = false;
            break;
        }
        return result;
    }

    public void initSwfVerification(String swfFilePath) {
        this.log.info("Initializing swf verification for: {}", (Object)swfFilePath);
        byte[] bytes = null;
        if (swfFilePath != null) {
            File localSwfFile = new File(swfFilePath);
            if (localSwfFile.exists() && localSwfFile.canRead()) {
                this.log.info("Swf file path: {}", (Object)localSwfFile.getAbsolutePath());
                bytes = FileUtil.readAsByteArray((File)localSwfFile);
            } else {
                bytes = "Red5 is awesome for handling non-accessable swf file".getBytes();
            }
        } else {
            bytes = new byte[42];
        }
        this.calculateHMAC_SHA256(bytes, 0, bytes.length, GENUINE_FP_KEY, 30, this.swfHash, 0);
        this.swfSize = bytes.length;
        this.log.info("Verification - size: {}, hash: {}", (Object)this.swfSize, (Object)Hex.encodeHexString((byte[])this.swfHash));
    }

    public byte[] getHandshakeBytes() {
        return this.c1;
    }
}

