/*
 * Decompiled with CFR 0.152.
 */
package org.red5.client.net.rtmp;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.mina.core.future.CloseFuture;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.transport.socket.SocketConnector;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.red5.client.net.rtmp.BaseRTMPClientHandler;
import org.red5.client.net.rtmp.RTMPMinaIoHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RTMPClient
extends BaseRTMPClientHandler {
    private static final Logger log = LoggerFactory.getLogger(RTMPClient.class);
    protected static final int CONNECTOR_WORKER_TIMEOUT = 7000;
    private final RTMPMinaIoHandler ioHandler = new RTMPMinaIoHandler();
    protected SocketConnector socketConnector;
    protected ConnectFuture future;
    private IoSession session;

    public RTMPClient() {
        this.ioHandler.setHandler(this);
    }

    @Override
    public Map<String, Object> makeDefaultConnectionParams(String server, int port, String application) {
        Map<String, Object> params = super.makeDefaultConnectionParams(server, port, application);
        if (!params.containsKey("tcUrl")) {
            params.put("tcUrl", String.format("%s://%s:%s/%s", this.protocol, server, port, application));
        }
        return params;
    }

    @Override
    protected void startConnector(String server, int port) {
        this.socketConnector = new NioSocketConnector();
        this.socketConnector.setHandler((IoHandler)this.ioHandler);
        this.future = this.socketConnector.connect((SocketAddress)new InetSocketAddress(server, port));
        this.future.addListener((IoFutureListener)new IoFutureListener<ConnectFuture>(){

            public void operationComplete(ConnectFuture future) {
                try {
                    RTMPClient.this.session = future.getSession();
                }
                catch (Throwable e) {
                    RTMPClient.this.socketConnector.dispose(false);
                    RTMPClient.this.handleException(e);
                }
            }
        });
        this.future.awaitUninterruptibly(7000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        if (this.future != null) {
            try {
                if (this.session != null) {
                    CloseFuture closeFuture = this.session.closeNow();
                    if (closeFuture.await(1000L, TimeUnit.MILLISECONDS) && !this.future.isCanceled() && this.future.cancel()) {
                        log.debug("Connect future cancelled after close future");
                    }
                } else if (this.future.cancel()) {
                    log.debug("Connect future cancelled");
                }
            }
            catch (Exception e) {
                log.warn("Exception during disconnect", (Throwable)e);
            }
            finally {
                this.socketConnector.dispose(false);
            }
        }
        super.disconnect();
    }

    @Override
    public void setProtocol(String protocol) throws Exception {
        this.protocol = protocol;
        if ("rtmps".equals(protocol) || "rtmpt".equals(protocol) || "rtmpte".equals(protocol) || "rtmfp".equals(protocol)) {
            throw new Exception("Unsupported protocol specified, please use the correct client for the intended protocol.");
        }
    }
}

