/*
 * Decompiled with CFR 0.152.
 */
package org.red5.client.net.rtmp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.red5.client.net.rtmpt.RTMPTClientConnection;
import org.red5.server.api.Red5;
import org.red5.server.net.IConnectionManager;
import org.red5.server.net.rtmp.RTMPConnection;
import org.red5.server.net.rtmp.RTMPMinaConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class RTMPConnManager
implements IConnectionManager<RTMPConnection> {
    private static final Logger log = LoggerFactory.getLogger(RTMPConnManager.class);
    private static int maxHandshakeTimeout = 7000;
    private static int maxInactivity = 60000;
    private static int pingInterval = 0;
    private static int executorQueueCapacity = 32;
    protected static IConnectionManager<RTMPConnection> instance = new RTMPConnManager();
    protected ConcurrentMap<String, RTMPConnection> connMap = new ConcurrentHashMap<String, RTMPConnection>();
    protected AtomicInteger conns = new AtomicInteger();

    public static IConnectionManager<RTMPConnection> getInstance() {
        return instance;
    }

    public RTMPConnection createConnection(Class<?> connCls) {
        RTMPConnection conn = null;
        if (RTMPConnection.class.isAssignableFrom(connCls)) {
            try {
                conn = this.createConnectionInstance(connCls);
                this.connMap.put(conn.getSessionId(), conn);
                log.trace("Connections: {}", (Object)this.conns.incrementAndGet());
                log.trace("Connection created: {}", (Object)conn);
            }
            catch (Exception ex) {
                log.warn("Exception creating connection", (Throwable)ex);
            }
        }
        return conn;
    }

    public RTMPConnection createConnection(Class<?> connCls, String sessionId) {
        RTMPConnection conn = null;
        if (RTMPConnection.class.isAssignableFrom(connCls)) {
            try {
                conn = this.createConnectionInstance(connCls);
                if (conn instanceof RTMPTClientConnection) {
                    ((RTMPTClientConnection)conn).setSessionId(sessionId);
                }
                this.connMap.put(conn.getSessionId(), conn);
                log.trace("Connections: {}", (Object)this.conns.incrementAndGet());
                log.trace("Connection created: {}", (Object)conn);
            }
            catch (Exception ex) {
                log.warn("Exception creating connection", (Throwable)ex);
            }
        }
        return conn;
    }

    public void setConnection(RTMPConnection conn) {
        log.trace("Adding connection: {}", (Object)conn);
        int id = conn.getId();
        if (id == -1) {
            log.debug("Connection has unsupported id, using session id hash");
            id = conn.getSessionId().hashCode();
        }
        log.debug("Connection id: {} session id hash: {}", (Object)conn.getId(), (Object)conn.getSessionId().hashCode());
    }

    public RTMPConnection getConnection(int clientId) {
        log.trace("Getting connection by client id: {}", (Object)clientId);
        for (RTMPConnection conn : this.connMap.values()) {
            if (conn.getId() != clientId) continue;
            return (RTMPConnection)this.connMap.get(conn.getSessionId());
        }
        return null;
    }

    public RTMPConnection getConnectionBySessionId(String sessionId) {
        log.debug("Getting connection by session id: {}", (Object)sessionId);
        if (this.connMap.containsKey(sessionId)) {
            return (RTMPConnection)this.connMap.get(sessionId);
        }
        log.warn("Connection not found for {}", (Object)sessionId);
        if (log.isTraceEnabled()) {
            log.trace("Connections ({}) {}", (Object)this.connMap.size(), this.connMap.values());
        }
        return null;
    }

    public RTMPConnection removeConnection(int clientId) {
        log.trace("Removing connection with id: {}", (Object)clientId);
        for (RTMPConnection conn : this.connMap.values()) {
            if (conn.getId() != clientId) continue;
            return this.removeConnection(conn.getSessionId());
        }
        log.warn("Connection was not removed by id: {}", (Object)clientId);
        return null;
    }

    public RTMPConnection removeConnection(String sessionId) {
        RTMPConnection conn;
        log.debug("Removing connection with session id: {}", (Object)sessionId);
        if (log.isTraceEnabled()) {
            log.trace("Connections ({}) at pre-remove: {}", (Object)this.connMap.size(), this.connMap.values());
        }
        if ((conn = (RTMPConnection)this.connMap.remove(sessionId)) != null) {
            log.trace("Connections: {}", (Object)this.conns.decrementAndGet());
            Red5.setConnectionLocal(null);
        }
        return conn;
    }

    public Collection<RTMPConnection> getAllConnections() {
        ArrayList<RTMPConnection> list = new ArrayList<RTMPConnection>(this.connMap.size());
        list.addAll(this.connMap.values());
        return list;
    }

    public Collection<RTMPConnection> removeConnections() {
        ArrayList<RTMPConnection> list = new ArrayList<RTMPConnection>(this.connMap.size());
        list.addAll(this.connMap.values());
        this.connMap.clear();
        this.conns.set(0);
        return list;
    }

    public RTMPConnection createConnectionInstance(Class<?> cls) throws Exception {
        Object conn = null;
        conn = cls == RTMPMinaConnection.class ? (RTMPMinaConnection)cls.newInstance() : (cls == RTMPTClientConnection.class ? (RTMPTClientConnection)((Object)cls.newInstance()) : (RTMPConnection)cls.newInstance());
        conn.setMaxHandshakeTimeout(maxHandshakeTimeout);
        conn.setMaxInactivity(maxInactivity);
        conn.setPingInterval(pingInterval);
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(1);
        executor.setDaemon(true);
        executor.setMaxPoolSize(1);
        executor.setQueueCapacity(executorQueueCapacity);
        executor.initialize();
        conn.setExecutor(executor);
        return conn;
    }

    public static void setMaxHandshakeTimeout(int maxHandshakeTimeout) {
        RTMPConnManager.maxHandshakeTimeout = maxHandshakeTimeout;
    }

    public static void setMaxInactivity(int maxInactivity) {
        RTMPConnManager.maxInactivity = maxInactivity;
    }

    public static void setPingInterval(int pingInterval) {
        RTMPConnManager.pingInterval = pingInterval;
    }

    public static void setExecutorQueueCapacity(int executorQueueCapacity) {
        RTMPConnManager.executorQueueCapacity = executorQueueCapacity;
    }
}

