/*
 * Decompiled with CFR 0.152.
 */
package org.red5.client.net.rtmp;

import org.apache.commons.codec.binary.Hex;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;
import org.red5.client.net.rtmp.BaseRTMPClientHandler;
import org.red5.client.net.rtmp.OutboundHandshake;
import org.red5.client.net.rtmp.RTMPConnManager;
import org.red5.client.net.rtmpe.RTMPEIoFilter;
import org.red5.server.net.rtmp.RTMPConnection;
import org.red5.server.net.rtmp.RTMPHandshake;
import org.red5.server.net.rtmp.RTMPMinaConnection;
import org.red5.server.net.rtmp.message.Packet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class RTMPMinaIoHandler
extends IoHandlerAdapter {
    private static Logger log = LoggerFactory.getLogger(RTMPMinaIoHandler.class);
    private boolean enableSwfVerification;
    protected BaseRTMPClientHandler handler;

    public void sessionCreated(IoSession session) throws Exception {
        log.debug("Session created");
        session.getFilterChain().addFirst("rtmpeFilter", (IoFilter)new RTMPEIoFilter());
        RTMPMinaConnection conn = this.createRTMPMinaConnection();
        conn.setIoSession(session);
        session.setAttribute((Object)"rtmp.sessionid", (Object)conn.getSessionId());
        OutboundHandshake outgoingHandshake = new OutboundHandshake();
        session.setAttribute((Object)"rtmp.handshake", (Object)outgoingHandshake);
        if (this.enableSwfVerification) {
            String swfUrl = (String)this.handler.getConnectionParams().get("swfUrl");
            log.debug("SwfUrl: {}", (Object)swfUrl);
            if (!StringUtils.isEmpty((Object)swfUrl)) {
                outgoingHandshake.initSwfVerification(swfUrl);
            }
        }
        session.setAttribute(RTMPConnection.RTMP_HANDLER, (Object)this.handler);
        this.handler.setConnection((RTMPConnection)conn);
    }

    public void sessionOpened(IoSession session) throws Exception {
        log.debug("Session opened");
        super.sessionOpened(session);
        RTMPHandshake handshake = (RTMPHandshake)session.getAttribute((Object)"rtmp.handshake");
        IoBuffer clientRequest1 = ((OutboundHandshake)handshake).generateClientRequest1();
        session.write((Object)clientRequest1);
    }

    public void sessionClosed(IoSession session) throws Exception {
        log.debug("Session closed");
        String sessionId = (String)session.getAttribute((Object)"rtmp.sessionid");
        if (sessionId != null) {
            log.trace("Session id: {}", (Object)sessionId);
            RTMPMinaConnection conn = (RTMPMinaConnection)RTMPConnManager.getInstance().getConnectionBySessionId(sessionId);
            if (conn != null) {
                conn.sendPendingServiceCallsCloseError();
                this.handler.connectionClosed((RTMPConnection)conn);
                session.removeAttribute(RTMPConnection.RTMP_HANDLER);
                session.removeAttribute((Object)"rtmp.handshake");
                session.removeAttribute((Object)"rtmpe.cipher.in");
                session.removeAttribute((Object)"rtmpe.cipher.out");
            } else {
                log.warn("Connection was null in session");
            }
        } else {
            log.debug("Connections session id was null in session, may already be closed");
        }
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        log.debug("messageReceived");
        if (message instanceof Packet && message != null) {
            String sessionId = (String)session.getAttribute((Object)"rtmp.sessionid");
            log.trace("Session id: {}", (Object)sessionId);
            RTMPMinaConnection conn = (RTMPMinaConnection)RTMPConnManager.getInstance().getConnectionBySessionId(sessionId);
            conn.handleMessageReceived((Packet)message);
        } else {
            log.debug("Not packet type: {}", message);
        }
    }

    public void messageSent(IoSession session, Object message) throws Exception {
        log.debug("messageSent");
        if (message instanceof Packet) {
            String sessionId = (String)session.getAttribute((Object)"rtmp.sessionid");
            log.trace("Session id: {}", (Object)sessionId);
            RTMPMinaConnection conn = (RTMPMinaConnection)RTMPConnManager.getInstance().getConnectionBySessionId(sessionId);
            this.handler.messageSent((RTMPConnection)conn, (Packet)message);
        } else {
            log.trace("messageSent: {}", (Object)Hex.encodeHexString((byte[])((IoBuffer)message).array()));
        }
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        log.warn("Exception caught {}", (Object)cause.getMessage());
        if (log.isDebugEnabled()) {
            log.error("Exception detail", cause);
        }
    }

    public void setHandler(BaseRTMPClientHandler handler) {
        log.debug("Set handler: {}", (Object)handler);
        this.handler = handler;
    }

    public void setEnableSwfVerification(boolean enableSwfVerification) {
        this.enableSwfVerification = enableSwfVerification;
    }

    protected RTMPMinaConnection createRTMPMinaConnection() {
        return (RTMPMinaConnection)RTMPConnManager.getInstance().createConnection(RTMPMinaConnection.class);
    }
}

