/*
 * Decompiled with CFR 0.152.
 */
package org.red5.client.net.rtmp.codec;

import org.apache.mina.core.buffer.IoBuffer;
import org.red5.io.amf3.Output;
import org.red5.io.object.Serializer;
import org.red5.server.api.IConnection;
import org.red5.server.api.Red5;
import org.red5.server.api.service.IPendingServiceCall;
import org.red5.server.api.service.IServiceCall;
import org.red5.server.net.ICommand;
import org.red5.server.net.rtmp.RTMPConnection;
import org.red5.server.net.rtmp.codec.RTMPProtocolEncoder;
import org.red5.server.net.rtmp.event.Invoke;
import org.red5.server.net.rtmp.status.StatusObject;
import org.slf4j.LoggerFactory;

public class RTMPClientProtocolEncoder
extends RTMPProtocolEncoder {
    public RTMPClientProtocolEncoder() {
        this.log = LoggerFactory.getLogger(RTMPClientProtocolEncoder.class);
    }

    protected void encodeCommand(IoBuffer out, ICommand command) {
        this.log.debug("encodeCommand - command: {}", (Object)command);
        RTMPConnection conn = (RTMPConnection)Red5.getConnectionLocal();
        Object output = new org.red5.io.amf.Output(out);
        IServiceCall call = command.getCall();
        boolean isPending = call.getStatus() == 1;
        this.log.debug("Call: {} pending: {}", (Object)call, (Object)isPending);
        if (!isPending) {
            this.log.debug("Call has been executed, send result");
            Serializer.serialize((org.red5.io.object.Output)output, (Object)(call.isSuccess() ? "_result" : "_error"));
        } else {
            this.log.debug("This is a pending call, send request");
            if (conn.getEncoding() == IConnection.Encoding.AMF3) {
                output = new Output(out);
            }
            String action = call.getServiceName() == null ? call.getServiceMethodName() : call.getServiceName() + '.' + call.getServiceMethodName();
            Serializer.serialize((org.red5.io.object.Output)output, (Object)action);
        }
        if (command instanceof Invoke) {
            Serializer.serialize((org.red5.io.object.Output)output, (Object)command.getTransactionId());
            Serializer.serialize((org.red5.io.object.Output)output, (Object)command.getConnectionParams());
        }
        output = call.getServiceName() == null && "connect".equals(call.getServiceMethodName()) ? new org.red5.io.amf.Output(out) : (conn.getEncoding() == IConnection.Encoding.AMF3 ? new Output(out) : new org.red5.io.amf.Output(out));
        if (!isPending && command instanceof Invoke) {
            IPendingServiceCall pendingCall = (IPendingServiceCall)call;
            if (!call.isSuccess()) {
                this.log.debug("Call was not successful");
                StatusObject status = this.generateErrorResult("NetConnection.Call.Failed", call.getException());
                pendingCall.setResult((Object)status);
            }
            Object res = pendingCall.getResult();
            this.log.debug("Writing result: {}", res);
            Serializer.serialize((org.red5.io.object.Output)output, (Object)res);
        } else {
            this.log.debug("Writing params");
            Object[] args = call.getArguments();
            if (args != null) {
                for (Object element : args) {
                    Serializer.serialize((org.red5.io.object.Output)output, (Object)element);
                }
            }
        }
        if (command.getData() != null) {
            out.setAutoExpand(true);
            out.put(command.getData());
        }
    }
}

