/*
 * Decompiled with CFR 0.152.
 */
package org.red5.client.net.rtmp.codec;

import java.util.List;
import java.util.concurrent.Semaphore;
import org.apache.commons.codec.binary.Hex;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecException;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.red5.client.net.rtmp.RTMPConnManager;
import org.red5.client.net.rtmp.codec.RTMPClientProtocolDecoder;
import org.red5.client.net.rtmp.codec.RTMPClientProtocolEncoder;
import org.red5.server.api.IConnection;
import org.red5.server.api.Red5;
import org.red5.server.net.rtmp.RTMPConnection;
import org.red5.server.net.rtmp.codec.RTMPMinaProtocolDecoder;
import org.red5.server.net.rtmp.codec.RTMPMinaProtocolEncoder;
import org.red5.server.net.rtmp.codec.RTMPProtocolDecoder;
import org.red5.server.net.rtmp.codec.RTMPProtocolEncoder;

public class RTMPMinaCodecFactory
implements ProtocolCodecFactory {
    private RTMPMinaProtocolDecoder clientDecoder = new RTMPMinaProtocolDecoder(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void decode(IoSession session, IoBuffer in, ProtocolDecoderOutput out) throws ProtocolCodecException {
            log.trace("decode buffer position: {}", (Object)in.position());
            String sessionId = (String)session.getAttribute((Object)"rtmp.sessionid");
            log.trace("Session id: {}", (Object)sessionId);
            RTMPConnection conn = (RTMPConnection)RTMPConnManager.getInstance().getConnectionBySessionId(sessionId);
            Red5.setConnectionLocal((IConnection)conn);
            byte[] arr = new byte[in.remaining()];
            in.get(arr);
            IoBuffer buf = (IoBuffer)session.getAttribute((Object)"buffer");
            if (buf == null) {
                buf = IoBuffer.allocate((int)arr.length);
                buf.setAutoExpand(true);
                session.setAttribute((Object)"buffer", (Object)buf);
            }
            buf.put(arr);
            buf.flip();
            Semaphore lock = conn.getDecoderLock();
            try {
                lock.acquire();
                List objects = this.getDecoder().decodeBuffer(conn, buf);
                log.trace("Decoded: {}", (Object)objects);
                if (objects != null) {
                    for (Object object : objects) {
                        log.trace("Writing {} to decoder output: {}", object, (Object)out);
                        out.write(object);
                    }
                }
                log.trace("Input buffer position: {}", (Object)in.position());
            }
            catch (Exception e) {
                log.error("Error during decode", (Throwable)e);
            }
            finally {
                lock.release();
                Red5.setConnectionLocal(null);
            }
        }
    };
    private RTMPMinaProtocolEncoder clientEncoder;

    public RTMPMinaCodecFactory() {
        this.clientDecoder.setDecoder((RTMPProtocolDecoder)new RTMPClientProtocolDecoder());
        this.clientEncoder = new RTMPMinaProtocolEncoder(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws ProtocolCodecException {
                String sessionId = (String)session.getAttribute((Object)"rtmp.sessionid");
                log.trace("Session id: {}", (Object)sessionId);
                RTMPConnection conn = (RTMPConnection)RTMPConnManager.getInstance().getConnectionBySessionId(sessionId);
                if (conn != null) {
                    Red5.setConnectionLocal((IConnection)conn);
                    Semaphore lock = conn.getEncoderLock();
                    try {
                        IoBuffer buf;
                        lock.acquire();
                        IoBuffer ioBuffer = buf = message instanceof IoBuffer ? (IoBuffer)message : this.getEncoder().encode(message);
                        if (buf != null) {
                            if (log.isTraceEnabled()) {
                                log.trace("Writing output data: {}", (Object)Hex.encodeHexString((byte[])buf.array()));
                            }
                            out.write((Object)buf);
                        }
                        log.trace("Response buffer was null after encoding");
                    }
                    catch (Exception ex) {
                        log.error("Exception during encode", (Throwable)ex);
                    }
                    finally {
                        lock.release();
                        Red5.setConnectionLocal(null);
                    }
                } else {
                    log.debug("Connection is no longer available for encoding, may have been closed already");
                }
            }
        };
        this.clientEncoder.setEncoder((RTMPProtocolEncoder)new RTMPClientProtocolEncoder());
    }

    public ProtocolDecoder getDecoder(IoSession session) {
        return this.clientDecoder;
    }

    public ProtocolEncoder getEncoder(IoSession session) {
        return this.clientEncoder;
    }
}

