/*
 * Decompiled with CFR 0.152.
 */
package org.red5.client.net.rtmpe;

import javax.crypto.Cipher;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.apache.mina.core.write.WriteRequestWrapper;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.red5.client.net.rtmp.BaseRTMPClientHandler;
import org.red5.client.net.rtmp.OutboundHandshake;
import org.red5.client.net.rtmp.RTMPConnManager;
import org.red5.client.net.rtmp.codec.RTMPMinaCodecFactory;
import org.red5.server.net.rtmp.RTMPConnection;
import org.red5.server.net.rtmp.RTMPMinaConnection;
import org.red5.server.net.rtmp.codec.RTMP;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RTMPEIoFilter
extends IoFilterAdapter {
    private static final Logger log = LoggerFactory.getLogger(RTMPEIoFilter.class);

    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object obj) throws Exception {
        String sessionId = (String)session.getAttribute((Object)"rtmp.sessionid");
        log.trace("Session id: {}", (Object)sessionId);
        RTMPMinaConnection conn = (RTMPMinaConnection)RTMPConnManager.getInstance().getConnectionBySessionId(sessionId);
        if (conn == null) {
            throw new Exception("Receive on unavailable connection - session id: " + sessionId);
        }
        if (log.isTraceEnabled()) {
            log.trace("Bytes read: {} written: {}", (Object)conn.getReadBytes(), (Object)conn.getWrittenBytes());
        }
        RTMP rtmp = conn.getState();
        byte connectionState = conn.getStateCode();
        IoBuffer message = (IoBuffer)obj;
        OutboundHandshake handshake = null;
        switch (connectionState) {
            case 2: {
                if (rtmp.isEncrypted()) {
                    Cipher cipher = (Cipher)session.getAttribute((Object)"rtmpe.cipher.in");
                    if (cipher != null) {
                        if (log.isDebugEnabled()) {
                            log.debug("Decrypting message: {}", (Object)message);
                        }
                        byte[] encrypted = new byte[message.remaining()];
                        message.get(encrypted);
                        message.clear();
                        message.free();
                        byte[] plain = cipher.update(encrypted);
                        IoBuffer messageDecrypted = IoBuffer.wrap((byte[])plain);
                        if (log.isDebugEnabled()) {
                            log.debug("Decrypted buffer: {}", (Object)messageDecrypted);
                        }
                        nextFilter.messageReceived(session, (Object)messageDecrypted);
                        break;
                    }
                    log.warn("Decryption cipher is missing from the session");
                    break;
                }
                log.trace("Not decrypting message: {}", obj);
                nextFilter.messageReceived(session, obj);
                break;
            }
            case 0: {
                IoBuffer c2;
                handshake = (OutboundHandshake)((Object)session.getAttribute((Object)"rtmp.handshake"));
                handshake.addBuffer(message);
                int s0s1Size = handshake.getBufferSize();
                log.trace("Incoming S0S1 size: {}", (Object)s0s1Size);
                if (s0s1Size < 1537) break;
                log.debug("decodeHandshakeS0S1");
                byte handshakeType = handshake.getHandshakeType();
                if (handshakeType == 0) {
                    log.trace("Handshake type is not currently set");
                    handshake.setHandshakeType((byte)3);
                    rtmp.setEncrypted(handshake.useEncryption());
                }
                IoBuffer buf = handshake.getBufferAsIoBuffer();
                byte connectionType = buf.get();
                log.trace("Incoming S0 connection type: {}", (Object)connectionType);
                if (handshake.getHandshakeType() != connectionType) {
                    log.debug("Server requested handshake type: {} client requested: {}", (Object)connectionType, (Object)handshake.getHandshakeType());
                }
                byte[] dst = new byte[1536];
                buf.get(dst);
                int remaining = buf.remaining();
                if (remaining > 0) {
                    handshake.addBuffer(buf);
                    log.trace("Stored {} bytes for later decoding", (Object)remaining);
                }
                if ((c2 = handshake.decodeServerResponse1(IoBuffer.wrap((byte[])dst))) != null) {
                    conn.getState().setState((byte)1);
                    session.write((Object)c2);
                    if (handshake.getBufferSize() < 1536) break;
                    buf.clear();
                    buf = handshake.getBufferAsIoBuffer();
                    if (handshake.decodeServerResponse2(buf)) {
                        log.debug("S2 decoding successful");
                    } else {
                        log.warn("Handshake failed on S2 processing");
                    }
                    this.completeConnection(session, conn, rtmp, handshake);
                    break;
                }
                conn.close();
                break;
            }
            case 1: {
                handshake = (OutboundHandshake)((Object)session.getAttribute((Object)"rtmp.handshake"));
                log.debug("decodeHandshakeS2 - buffer: {}", (Object)message);
                handshake.addBuffer(message);
                int s2Size = handshake.getBufferSize();
                log.trace("Incoming S2 size: {}", (Object)s2Size);
                if (s2Size < 1536) break;
                IoBuffer buf = handshake.getBufferAsIoBuffer();
                byte[] dst = new byte[1536];
                buf.get(dst);
                int index = buf.indexOf(handshake.getHandshakeType());
                if (index != -1) {
                    log.trace("Connection type index in message: {}", (Object)index);
                    buf.position(index);
                }
                log.trace("Message - pos: {} {}", (Object)buf.position(), (Object)message);
                if (handshake.decodeServerResponse2(IoBuffer.wrap((byte[])dst))) {
                    log.debug("S2 decoding successful");
                } else {
                    log.debug("S2 decoding failed");
                }
                this.completeConnection(session, conn, rtmp, handshake);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                log.debug("Nothing to do, connection state: {}", (Object)RTMP.states[connectionState]);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid RTMP state: " + connectionState);
            }
        }
    }

    private void completeConnection(IoSession session, RTMPMinaConnection conn, RTMP rtmp, OutboundHandshake handshake) {
        if (handshake.useEncryption()) {
            rtmp.setEncrypted(true);
            log.debug("Adding ciphers to the session");
            session.setAttribute((Object)"rtmpe.cipher.in", (Object)handshake.getCipherIn());
            session.setAttribute((Object)"rtmpe.cipher.out", (Object)handshake.getCipherOut());
        }
        conn.getState().setState((byte)2);
        log.debug("Connected, removing handshake data");
        session.removeAttribute((Object)"rtmp.handshake");
        log.debug("Adding RTMP protocol filter");
        session.getFilterChain().addAfter("rtmpeFilter", "protocolFilter", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new RTMPMinaCodecFactory()));
        BaseRTMPClientHandler handler = (BaseRTMPClientHandler)session.getAttribute(RTMPConnection.RTMP_HANDLER);
        handler.connectionOpened((RTMPConnection)conn);
    }

    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest request) throws Exception {
        RTMPMinaConnection conn = (RTMPMinaConnection)RTMPConnManager.getInstance().getConnectionBySessionId((String)session.getAttribute((Object)"rtmp.sessionid"));
        if (conn.getState().getState() == 2 && session.containsAttribute((Object)"rtmpe.cipher.out")) {
            Cipher cipher = (Cipher)session.getAttribute((Object)"rtmpe.cipher.out");
            IoBuffer message = (IoBuffer)request.getMessage();
            if (!message.hasRemaining()) {
                if (log.isTraceEnabled()) {
                    log.trace("Ignoring empty message");
                }
                nextFilter.filterWrite(session, request);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("Encrypting message: {}", (Object)message);
                }
                byte[] plain = new byte[message.remaining()];
                message.get(plain);
                message.clear();
                message.free();
                byte[] encrypted = cipher.update(plain);
                IoBuffer messageEncrypted = IoBuffer.wrap((byte[])encrypted);
                if (log.isDebugEnabled()) {
                    log.debug("Encrypted message: {}", (Object)messageEncrypted);
                }
                nextFilter.filterWrite(session, (WriteRequest)new EncryptedWriteRequest(request, messageEncrypted));
            }
        } else {
            log.trace("Non-encrypted message");
            nextFilter.filterWrite(session, request);
        }
    }

    private static class EncryptedWriteRequest
    extends WriteRequestWrapper {
        private final IoBuffer encryptedMessage;

        private EncryptedWriteRequest(WriteRequest writeRequest, IoBuffer encryptedMessage) {
            super(writeRequest);
            this.encryptedMessage = encryptedMessage;
        }

        public Object getMessage() {
            return this.encryptedMessage;
        }
    }
}

