/*
 * Decompiled with CFR 0.152.
 */
package org.red5.client.net.rtmps;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.net.ssl.SSLContext;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.IoFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.ssl.SslFilter;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.red5.client.net.rtmp.RTMPClient;
import org.red5.client.net.rtmp.RTMPMinaIoHandler;
import org.red5.client.net.ssl.BogusSslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RTMPSClient
extends RTMPClient {
    private static final Logger log = LoggerFactory.getLogger(RTMPSClient.class);
    private final RTMPSClientIoHandler ioHandler;
    private char[] password;
    private String keyStoreType = "JKS";

    public RTMPSClient() {
        this.protocol = "rtmps";
        this.ioHandler = new RTMPSClientIoHandler();
        this.ioHandler.setHandler(this);
    }

    @Override
    protected void startConnector(String server, int port) {
        this.socketConnector = new NioSocketConnector();
        this.socketConnector.setHandler((IoHandler)this.ioHandler);
        this.future = this.socketConnector.connect((SocketAddress)new InetSocketAddress(server, port));
        this.future.addListener(new IoFutureListener(){

            public void operationComplete(IoFuture future) {
                try {
                    future.getSession();
                }
                catch (Throwable e) {
                    RTMPSClient.this.handleException(e);
                }
            }
        });
        this.future.awaitUninterruptibly(7000L);
    }

    public void setKeyStorePassword(String password) {
        this.password = password.toCharArray();
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    private class RTMPSClientIoHandler
    extends RTMPMinaIoHandler {
        private RTMPSClientIoHandler() {
        }

        @Override
        public void sessionOpened(IoSession session) throws Exception {
            SSLContext sslContext = BogusSslContextFactory.getInstance(false);
            SslFilter sslFilter = new SslFilter(sslContext);
            sslFilter.setUseClientMode(true);
            if (sslFilter != null) {
                session.getFilterChain().addFirst("sslFilter", (IoFilter)sslFilter);
            }
            super.sessionOpened(session);
        }

        @Override
        public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
            log.warn("Exception caught {}", (Object)cause.getMessage());
            if (log.isDebugEnabled()) {
                log.error("Exception detail", cause);
            }
            session.close(true);
        }
    }
}

