/*
 * Decompiled with CFR 0.152.
 */
package org.red5.client.net.rtmpt;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.mina.core.buffer.IoBuffer;
import org.red5.server.api.IConnection;
import org.red5.server.api.Red5;
import org.red5.server.net.rtmp.IRTMPHandler;
import org.red5.server.net.rtmp.RTMPConnection;
import org.red5.server.net.rtmp.codec.RTMPProtocolDecoder;
import org.red5.server.net.rtmp.codec.RTMPProtocolEncoder;
import org.red5.server.net.rtmp.message.Packet;
import org.red5.server.net.rtmpt.codec.RTMPTProtocolDecoder;
import org.red5.server.net.rtmpt.codec.RTMPTProtocolEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRTMPTConnection
extends RTMPConnection {
    private static final Logger log = LoggerFactory.getLogger(BaseRTMPTConnection.class);
    private RTMPTProtocolDecoder decoder;
    private RTMPTProtocolEncoder encoder;
    private ConcurrentLinkedQueue<PendingData> pendingMessages = new ConcurrentLinkedQueue();
    private volatile boolean closing;
    private AtomicLong readBytes = new AtomicLong(0L);
    private AtomicLong writtenBytes = new AtomicLong(0L);
    private IoBuffer buffer = IoBuffer.allocate((int)2048);
    protected String clientSessionId;
    private volatile IRTMPHandler handler;

    public BaseRTMPTConnection(String type) {
        super(type);
        this.buffer.setAutoExpand(true);
    }

    public abstract IoBuffer getPendingMessages(int var1);

    public void close() {
        log.debug("close - state: {}", (Object)this.state.getState());
        this.closing = true;
    }

    public boolean isClosing() {
        return this.closing;
    }

    public void realClose() {
        if (this.isClosing()) {
            if (this.buffer != null) {
                this.buffer.free();
                this.buffer = null;
            }
            this.state.setState((byte)5);
            this.pendingMessages.clear();
            super.close();
        }
    }

    public void writeRaw(IoBuffer packet) {
        this.pendingMessages.add(new PendingData(packet));
    }

    public long getReadBytes() {
        return this.readBytes.get();
    }

    public long getWrittenBytes() {
        return this.writtenBytes.get();
    }

    public long getPendingMessages() {
        return this.pendingMessages.size();
    }

    public void setSessionId(String sessionId) {
        log.debug("Overriding generated session id {} with {}", (Object)this.sessionId, (Object)sessionId);
        this.clientSessionId = sessionId;
    }

    public String getSessionId() {
        if (this.clientSessionId == null) {
            return this.sessionId;
        }
        return this.clientSessionId;
    }

    public List<?> decode(IoBuffer data) {
        log.debug("decode - state: {}", (Object)this.state);
        if (this.closing || this.state.getState() == 5) {
            return Collections.EMPTY_LIST;
        }
        this.readBytes.addAndGet(data.limit());
        this.buffer.put(data);
        this.buffer.flip();
        return this.decoder.decodeBuffer((RTMPConnection)this, this.buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Packet packet) {
        IoBuffer data;
        log.debug("write - state: {}", (Object)this.state);
        if (this.closing || this.state.getState() == 5) {
            return;
        }
        try {
            Red5.setConnectionLocal((IConnection)this);
            data = this.encoder.encode((Object)packet);
        }
        catch (Exception e) {
            log.error("Could not encode message {}", (Object)packet, (Object)e);
            return;
        }
        finally {
            Red5.setConnectionLocal(null);
        }
        if (data != null) {
            this.writingMessage(packet);
            this.pendingMessages.add(new PendingData(data, packet));
        } else {
            log.info("Response buffer was null after encoding");
        }
    }

    protected IoBuffer foldPendingMessages(int targetSize) {
        if (this.pendingMessages.isEmpty()) {
            return null;
        }
        IoBuffer result = IoBuffer.allocate((int)2048);
        result.setAutoExpand(true);
        LinkedList<Packet> toNotify = new LinkedList<Packet>();
        while (!this.pendingMessages.isEmpty()) {
            PendingData pendingMessage = (PendingData)this.pendingMessages.remove();
            result.put(pendingMessage.getBuffer());
            if (pendingMessage.getPacket() != null) {
                toNotify.add(pendingMessage.getPacket());
            }
            if (result.position() <= targetSize) continue;
            break;
        }
        for (Packet message : toNotify) {
            try {
                this.handler.messageSent((RTMPConnection)this, message);
            }
            catch (Exception e) {
                log.error("Could not notify stream subsystem about sent message", (Throwable)e);
            }
        }
        result.flip();
        this.writtenBytes.addAndGet(result.limit());
        return result;
    }

    public void setHandler(IRTMPHandler handler) {
        this.handler = handler;
    }

    public void setDecoder(RTMPProtocolDecoder decoder) {
        this.decoder = (RTMPTProtocolDecoder)decoder;
    }

    public void setEncoder(RTMPProtocolEncoder encoder) {
        this.encoder = (RTMPTProtocolEncoder)encoder;
    }

    private static class PendingData {
        private IoBuffer buffer;
        private Packet packet;

        private PendingData(IoBuffer buffer, Packet packet) {
            this.buffer = buffer;
            this.packet = packet;
        }

        private PendingData(IoBuffer buffer) {
            this.buffer = buffer;
        }

        public IoBuffer getBuffer() {
            return this.buffer;
        }

        public Packet getPacket() {
            return this.packet;
        }

        public String toString() {
            return this.getClass().getName() + "(buffer=" + this.buffer + "; packet=" + this.packet + ")";
        }
    }
}

