/*
 * Decompiled with CFR 0.152.
 */
package org.red5.client.net.rtmpt;

import java.util.Map;
import org.apache.mina.core.buffer.IoBuffer;
import org.red5.client.net.rtmp.BaseRTMPClientHandler;
import org.red5.client.net.rtmp.OutboundHandshake;
import org.red5.client.net.rtmpt.RTMPTClientConnector;
import org.red5.server.net.rtmp.codec.RTMP;
import org.red5.server.net.rtmp.codec.RTMPProtocolDecoder;
import org.red5.server.net.rtmp.codec.RTMPProtocolEncoder;
import org.red5.server.net.rtmp.message.Packet;
import org.red5.server.net.rtmpt.codec.RTMPTCodecFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RTMPTClient
extends BaseRTMPClientHandler {
    private static final Logger log = LoggerFactory.getLogger(RTMPTClient.class);
    private RTMPTClientConnector connector;
    private RTMPTCodecFactory codecFactory;

    public RTMPTClient() {
        this.protocol = "rtmpt";
        this.codecFactory = new RTMPTCodecFactory();
        this.codecFactory.init();
    }

    @Override
    public Map<String, Object> makeDefaultConnectionParams(String server, int port, String application) {
        Map<String, Object> params = super.makeDefaultConnectionParams(server, port, application);
        if (!params.containsKey("tcUrl")) {
            params.put("tcUrl", this.protocol + "://" + server + ':' + port + '/' + application);
        }
        return params;
    }

    @Override
    protected synchronized void startConnector(String server, int port) {
        this.connector = new RTMPTClientConnector(server, port, this);
        log.debug("Created connector {}", (Object)this.connector);
        this.connector.start();
    }

    public void messageReceived(Object message) {
        if (message instanceof Packet) {
            try {
                this.messageReceived(this.conn, (Packet)message);
            }
            catch (Exception e) {
                log.warn("Exception on packet receive", (Throwable)e);
            }
        } else {
            IoBuffer in = (IoBuffer)message;
            RTMP rtmp = this.conn.getState();
            byte connectionState = this.conn.getStateCode();
            log.trace("connectionState: {}", (Object)RTMP.states[connectionState]);
            OutboundHandshake handshake = (OutboundHandshake)((Object)this.conn.getAttribute("rtmp.handshake"));
            switch (connectionState) {
                case 0: {
                    log.debug("Handshake - client phase 1 - size: {}", (Object)in.remaining());
                    in.get();
                    byte handshakeType = in.get();
                    log.debug("Handshake - byte type: {}", (Object)handshakeType);
                    byte[] s1 = new byte[1536];
                    in.get(s1);
                    IoBuffer out = handshake.decodeServerResponse1(IoBuffer.wrap((byte[])s1));
                    if (out != null) {
                        rtmp.setState((byte)1);
                        this.conn.writeRaw(out);
                        if (in.remaining() < 1536) break;
                        log.debug("Handshake - client phase 2 - size: {}", (Object)in.remaining());
                        if (!handshake.decodeServerResponse2(in)) {
                            log.warn("Handshake failed on S2 processing");
                        }
                        this.conn.removeAttribute("rtmp.handshake");
                        this.conn.setStateCode((byte)2);
                        this.connectionOpened(this.conn);
                        break;
                    }
                    log.warn("Handshake failed on S0S1 processing");
                    this.conn.close();
                    break;
                }
                case 1: {
                    log.debug("Handshake - client phase 2 - size: {}", (Object)in.remaining());
                    if (!handshake.decodeServerResponse2(in)) {
                        log.warn("Handshake failed on S2 processing");
                    }
                    this.conn.removeAttribute("rtmp.handshake");
                    this.conn.setStateCode((byte)2);
                    this.connectionOpened(this.conn);
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid RTMP state: " + connectionState);
                }
            }
        }
    }

    @Override
    public synchronized void disconnect() {
        if (this.connector != null) {
            this.connector.setStopRequested(true);
            this.connector.interrupt();
        }
        super.disconnect();
    }

    public RTMPProtocolDecoder getDecoder() {
        return this.codecFactory.getRTMPDecoder();
    }

    public RTMPProtocolEncoder getEncoder() {
        return this.codecFactory.getRTMPEncoder();
    }
}

