/*
 * Decompiled with CFR 0.152.
 */
package org.red5.client.net.rtmpt;

import java.io.IOException;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ParseException;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.util.EntityUtils;
import org.apache.mina.core.buffer.IoBuffer;
import org.red5.client.net.rtmp.OutboundHandshake;
import org.red5.client.net.rtmp.RTMPConnManager;
import org.red5.client.net.rtmpt.RTMPTClient;
import org.red5.client.net.rtmpt.RTMPTClientConnection;
import org.red5.server.api.IConnection;
import org.red5.server.api.Red5;
import org.red5.server.net.rtmp.IRTMPHandler;
import org.red5.server.net.rtmp.codec.RTMP;
import org.red5.server.util.HttpConnectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RTMPTClientConnector
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(RTMPTClientConnector.class);
    private static final String CONTENT_TYPE = "application/x-fcs";
    private static final ByteArrayEntity ZERO_REQUEST_ENTITY = new ByteArrayEntity(new byte[]{0});
    private static final int SEND_TARGET_SIZE = 32768;
    private final HttpClient httpClient = HttpConnectionUtil.getClient();
    private final HttpHost targetHost;
    private final RTMPTClient client;
    private String sessionId;
    private long messageCount = 1L;
    private volatile boolean stopRequested = false;

    public RTMPTClientConnector(String server, int port, RTMPTClient client) {
        this.targetHost = new HttpHost(server, port, "http");
        this.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        HttpPost post = null;
        try {
            RTMPTClientConnection conn = this.openConnection();
            this.client.setConnection(conn);
            Red5.setConnectionLocal((IConnection)conn);
            while (!conn.isClosing() && !this.stopRequested) {
                List<?> messages;
                int limit;
                IoBuffer toSend = conn.getPendingMessages(32768);
                int n = limit = toSend != null ? toSend.limit() : 0;
                if (limit > 0) {
                    post = this.makePost("send");
                    post.setEntity((HttpEntity)new InputStreamEntity(toSend.asInputStream(), (long)limit));
                    post.addHeader("Content-Type", CONTENT_TYPE);
                } else {
                    post = this.makePost("idle");
                    post.setEntity((HttpEntity)ZERO_REQUEST_ENTITY);
                    post.addHeader("Content-Type", CONTENT_TYPE);
                }
                HttpResponse response = this.httpClient.execute(this.targetHost, (HttpRequest)post);
                this.checkResponseCode(response);
                byte[] received = EntityUtils.toByteArray((HttpEntity)response.getEntity());
                IoBuffer data = IoBuffer.wrap((byte[])received);
                log.debug("State: {}", (Object)RTMP.states[conn.getStateCode()]);
                if (conn.hasAttribute("rtmp.handshake")) {
                    this.client.messageReceived(data);
                    continue;
                }
                if (data.limit() > 0) {
                    data.skip(1);
                }
                if ((messages = conn.decode(data)) == null || messages.isEmpty()) {
                    try {
                        Thread.sleep(250L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        if (!this.stopRequested) continue;
                        post.abort();
                        break;
                    }
                }
                for (Object message : messages) {
                    try {
                        this.client.messageReceived(message);
                    }
                    catch (Exception e) {
                        log.error("Could not process message", (Throwable)e);
                    }
                }
            }
            this.finalizeConnection();
            this.client.connectionClosed(conn);
        }
        catch (Throwable e) {
            log.debug("RTMPT handling exception", e);
            this.client.handleException(e);
            if (post != null) {
                post.abort();
            }
        }
        finally {
            Red5.setConnectionLocal(null);
        }
    }

    public String getSessionId() {
        return this.sessionId;
    }

    private RTMPTClientConnection openConnection() throws IOException {
        RTMPTClientConnection conn = null;
        HttpPost openPost = this.getPost("/open/1");
        this.setCommonHeaders(openPost);
        openPost.addHeader("Content-Type", CONTENT_TYPE);
        openPost.setEntity((HttpEntity)ZERO_REQUEST_ENTITY);
        HttpResponse response = this.httpClient.execute(this.targetHost, (HttpRequest)openPost);
        this.checkResponseCode(response);
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            String responseStr = EntityUtils.toString((HttpEntity)entity);
            this.sessionId = responseStr.substring(0, responseStr.length() - 1);
            log.debug("Got an id {}", (Object)this.sessionId);
            conn = (RTMPTClientConnection)((Object)RTMPConnManager.getInstance().createConnection(RTMPTClientConnection.class, this.sessionId));
            log.debug("Got session id {} from connection", (Object)conn.getSessionId());
            conn.setHandler((IRTMPHandler)this.client);
            conn.setDecoder(this.client.getDecoder());
            conn.setEncoder(this.client.getEncoder());
            OutboundHandshake outgoingHandshake = new OutboundHandshake();
            outgoingHandshake.setHandshakeType((byte)3);
            conn.setAttribute("rtmp.handshake", (Object)outgoingHandshake);
            log.debug("Handshake 1st phase");
            IoBuffer handshake = outgoingHandshake.generateClientRequest1();
            conn.writeRaw(handshake);
        }
        return conn;
    }

    private void finalizeConnection() throws IOException {
        log.debug("Sending close post");
        HttpPost closePost = this.getPost(this.makeUrl("close"));
        closePost.addHeader("Content-Type", CONTENT_TYPE);
        closePost.setEntity((HttpEntity)ZERO_REQUEST_ENTITY);
        HttpResponse response = this.httpClient.execute(this.targetHost, (HttpRequest)closePost);
        EntityUtils.consume((HttpEntity)response.getEntity());
    }

    private HttpPost getPost(String uri) {
        HttpPost post = new HttpPost(uri);
        post.setProtocolVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
        return post;
    }

    private HttpPost makePost(String command) {
        HttpPost post = this.getPost(this.makeUrl(command));
        this.setCommonHeaders(post);
        return post;
    }

    private String makeUrl(String command) {
        return String.format("/%s/%s/%s", command, this.sessionId, this.messageCount++);
    }

    private void setCommonHeaders(HttpPost post) {
        post.addHeader("Connection", "Keep-Alive");
        post.addHeader("Cache-Control", "no-cache");
    }

    private void checkResponseCode(HttpResponse response) throws ParseException, IOException {
        int code = response.getStatusLine().getStatusCode();
        if (code != 200) {
            throw new RuntimeException("Bad HTTP status returned, line: " + response.getStatusLine() + "; body: " + EntityUtils.toString((HttpEntity)response.getEntity()));
        }
    }

    public void setStopRequested(boolean stopRequested) {
        this.stopRequested = stopRequested;
    }
}

