/*
 * Decompiled with CFR 0.152.
 */
package org.red5.client.net.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.GeneralSecurityException;
import javax.net.ServerSocketFactory;
import org.red5.client.net.ssl.BogusSslContextFactory;

public class SslServerSocketFactory
extends ServerSocketFactory {
    private static boolean sslEnabled = false;
    private static ServerSocketFactory sslFactory = null;
    private static ServerSocketFactory factory = null;

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        return new ServerSocket(port);
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        return new ServerSocket(port, backlog);
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
        return new ServerSocket(port, backlog, ifAddress);
    }

    public static ServerSocketFactory getServerSocketFactory() throws IOException {
        if (SslServerSocketFactory.isSslEnabled()) {
            if (sslFactory == null) {
                try {
                    sslFactory = BogusSslContextFactory.getInstance(true).getServerSocketFactory();
                }
                catch (GeneralSecurityException e) {
                    IOException ioe = new IOException("could not create SSL socket");
                    ioe.initCause(e);
                    throw ioe;
                }
            }
            return sslFactory;
        }
        if (factory == null) {
            factory = new SslServerSocketFactory();
        }
        return factory;
    }

    public static boolean isSslEnabled() {
        return sslEnabled;
    }

    public static void setSslEnabled(boolean newSslEnabled) {
        sslEnabled = newSslEnabled;
    }
}

