/*
 * Decompiled with CFR 0.152.
 */
package org.red5.proxy;

import java.io.IOException;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import org.red5.client.net.rtmp.ClientExceptionHandler;
import org.red5.client.net.rtmp.INetStreamEventHandler;
import org.red5.client.net.rtmp.RTMPClient;
import org.red5.io.utils.ObjectMap;
import org.red5.proxy.StreamState;
import org.red5.server.api.service.IPendingServiceCall;
import org.red5.server.api.service.IPendingServiceCallback;
import org.red5.server.messaging.IMessage;
import org.red5.server.messaging.IMessageComponent;
import org.red5.server.messaging.IPipe;
import org.red5.server.messaging.IPipeConnectionListener;
import org.red5.server.messaging.IPushableConsumer;
import org.red5.server.messaging.OOBControlMessage;
import org.red5.server.messaging.PipeConnectionEvent;
import org.red5.server.net.rtmp.event.Notify;
import org.red5.server.stream.message.RTMPMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingProxy
implements IPushableConsumer,
IPipeConnectionListener,
INetStreamEventHandler,
IPendingServiceCallback {
    private static Logger log = LoggerFactory.getLogger(StreamingProxy.class);
    private ConcurrentLinkedQueue<IMessage> frameBuffer = new ConcurrentLinkedQueue();
    private String host;
    private int port;
    private String app;
    private RTMPClient rtmpClient;
    private StreamState state;
    private String publishName;
    private Number streamId;
    private String publishMode;
    private final Semaphore lock = new Semaphore(1, true);
    private static Timer timer;

    public void init() {
        this.rtmpClient = new RTMPClient();
        this.setState(StreamState.STOPPED);
        timer = new Timer();
    }

    public void start(String publishName, String publishMode, Object[] params) {
        this.setState(StreamState.CONNECTING);
        this.publishName = publishName;
        this.publishMode = publishMode;
        Map<String, Object> defParams = this.rtmpClient.makeDefaultConnectionParams(this.host, this.port, this.app);
        defParams.put("swfUrl", "app:/Red5-StreamProxy.swf");
        defParams.put("pageUrl", "");
        this.rtmpClient.setSwfVerification(true);
        this.rtmpClient.setStreamEventHandler(this);
        this.rtmpClient.connect(this.host, this.port, defParams, this, params);
    }

    public void stop() {
        timer.cancel();
        if (this.state != StreamState.STOPPED) {
            this.rtmpClient.disconnect();
        }
        this.setState(StreamState.STOPPED);
        this.frameBuffer.clear();
    }

    private void createStream() {
        this.setState(StreamState.STREAM_CREATING);
        this.rtmpClient.createStream(this);
    }

    public void onPipeConnectionEvent(PipeConnectionEvent event) {
        log.debug("onPipeConnectionEvent: {}", (Object)event);
    }

    public void pushMessage(IPipe pipe, IMessage message) throws IOException {
        if (this.isPublished() && message instanceof RTMPMessage) {
            RTMPMessage rtmpMsg = (RTMPMessage)message;
            this.rtmpClient.publishStreamData(this.streamId, (IMessage)rtmpMsg);
        } else {
            log.trace("Adding message to buffer. Current size: {}", (Object)this.frameBuffer.size());
            this.frameBuffer.add(message);
        }
    }

    public void onOOBControlMessage(IMessageComponent source, IPipe pipe, OOBControlMessage oobCtrlMsg) {
        log.debug("onOOBControlMessage: {}", (Object)oobCtrlMsg);
    }

    public void onBWDone() {
        log.debug("onBWDone");
        this.rtmpClient.onBWDone(null);
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setApp(String app) {
        this.app = app;
    }

    @Override
    public void onStreamEvent(Notify notify) {
        log.debug("onStreamEvent: {}", (Object)notify);
        ObjectMap map = (ObjectMap)notify.getCall().getArguments()[0];
        String code = (String)map.get((Object)"code");
        log.debug("<:{}", (Object)code);
        if ("NetStream.Publish.Start".equals(code)) {
            this.setState(StreamState.PUBLISHED);
            IMessage message = null;
            while ((message = this.frameBuffer.poll()) != null) {
                this.rtmpClient.publishStreamData(this.streamId, message);
            }
        } else if ("NetStream.Unpublish.Success".equals(code)) {
            this.setState(StreamState.UNPUBLISHED);
        }
    }

    public void resultReceived(IPendingServiceCall call) {
        String method = call.getServiceMethodName();
        log.debug("resultReceived:> {}", (Object)method);
        if ("connect".equals(method)) {
            timer.schedule((TimerTask)new BandwidthStatusTask(), 2000L);
        } else if (!"releaseStream".equals(method)) {
            if ("createStream".equals(method)) {
                this.setState(StreamState.PUBLISHING);
                Object result = call.getResult();
                if (result instanceof Number) {
                    this.streamId = (Number)result;
                    log.debug("Publishing: {}", (Object)this.state);
                    this.rtmpClient.publish(this.streamId, this.publishName, this.publishMode, this);
                } else {
                    this.rtmpClient.disconnect();
                    this.setState(StreamState.STOPPED);
                }
            } else if ("FCPublish".equals(method)) {
                // empty if block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setState(StreamState state) {
        try {
            this.lock.acquire();
            this.state = state;
        }
        catch (InterruptedException e) {
            log.warn("Exception setting state", (Throwable)e);
        }
        finally {
            this.lock.release();
        }
    }

    protected StreamState getState() {
        return this.state;
    }

    public void setConnectionClosedHandler(Runnable connectionClosedHandler) {
        log.debug("setConnectionClosedHandler: {}", (Object)connectionClosedHandler);
        if (this.rtmpClient != null) {
            this.rtmpClient.setConnectionClosedHandler(connectionClosedHandler);
        } else {
            log.warn("Internal client is null, ensure that init() is called before adding handlers");
        }
    }

    public void setExceptionHandler(ClientExceptionHandler exceptionHandler) {
        log.debug("setExceptionHandler: {}", (Object)exceptionHandler);
        if (this.rtmpClient != null) {
            this.rtmpClient.setExceptionHandler(exceptionHandler);
        } else {
            log.warn("Internal client is null, ensure that init() is called before adding handlers");
        }
    }

    public boolean isPublished() {
        return this.getState().equals((Object)StreamState.PUBLISHED);
    }

    public boolean isRunning() {
        return !this.getState().equals((Object)StreamState.STOPPED);
    }

    private final class BandwidthStatusTask
    extends TimerTask {
        private BandwidthStatusTask() {
        }

        @Override
        public void run() {
            log.debug("Bandwidth check done: {}", (Object)StreamingProxy.this.rtmpClient.isBandwidthCheckDone());
            this.cancel();
            StreamingProxy.this.createStream();
        }
    }
}

