/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.p2;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.AbstractMojoExecutionException;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.eclipse.sisu.equinox.launching.internal.P2ApplicationLauncher;
import org.reficio.p2.EclipseArtifact;
import org.reficio.p2.FeatureBuilder;
import org.reficio.p2.P2Artifact;
import org.reficio.p2.P2FeatureDefinition;
import org.reficio.p2.P2Helper;
import org.reficio.p2.P2Validator;
import org.reficio.p2.TychoFeatureBuilder;
import org.reficio.p2.bundler.ArtifactBundler;
import org.reficio.p2.bundler.ArtifactBundlerInstructions;
import org.reficio.p2.bundler.ArtifactBundlerRequest;
import org.reficio.p2.bundler.impl.AquteBundler;
import org.reficio.p2.logger.Logger;
import org.reficio.p2.publisher.BundlePublisher;
import org.reficio.p2.publisher.CategoryPublisher;
import org.reficio.p2.resolver.eclipse.EclipseResolutionRequest;
import org.reficio.p2.resolver.eclipse.impl.DefaultEclipseResolver;
import org.reficio.p2.resolver.maven.Artifact;
import org.reficio.p2.resolver.maven.ArtifactResolutionRequest;
import org.reficio.p2.resolver.maven.ArtifactResolutionResult;
import org.reficio.p2.resolver.maven.ArtifactResolver;
import org.reficio.p2.resolver.maven.ResolvedArtifact;
import org.reficio.p2.resolver.maven.impl.AetherResolver;
import org.reficio.p2.utils.BundleUtils;
import org.reficio.p2.utils.JarUtils;
import org.reficio.p2.utils.Utils;

@Mojo(name="site", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyResolution=ResolutionScope.RUNTIME, requiresDependencyCollection=ResolutionScope.RUNTIME)
public class P2Mojo
extends AbstractMojo
implements Contextualizable {
    private static final String BUNDLES_TOP_FOLDER = "/source";
    private static final String FEATURES_DESTINATION_FOLDER = "/source/features";
    private static final String BUNDLES_DESTINATION_FOLDER = "/source/plugins";
    private static final String DEFAULT_CATEGORY_FILE = "category.xml";
    private static final String DEFAULT_CATEGORY_CLASSPATH_LOCATION = "/";
    private String timestamp = Utils.getTimeStamp();
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Requirement
    @Component
    private BuildPluginManager pluginManager;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private String buildDirectory;
    @Parameter(defaultValue="${project.build.directory}/repository", required=true)
    private String destinationDirectory;
    @Requirement
    @Component
    private P2ApplicationLauncher launcher;
    @Parameter(defaultValue="")
    private String categoryFileURL;
    @Parameter(defaultValue="false")
    private boolean pedantic;
    @Parameter(defaultValue="false")
    private boolean skipInvalidArtifacts;
    @Parameter(defaultValue="false")
    private boolean skipNotExistingArtifacts;
    @Parameter(defaultValue="true")
    private boolean compressSite;
    @Parameter(defaultValue="0", alias="p2.timeout")
    private int forkedProcessTimeoutInSeconds;
    @Parameter(defaultValue="true")
    private boolean reuseSnapshotVersionFromArtifact;
    @Parameter(defaultValue="")
    private String additionalArgs;
    private PlexusContainer container;
    private Object repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    private Object repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    private List<Object> projectRepos;
    @Parameter(readonly=true)
    private List<P2Artifact> artifacts;
    @Parameter(readonly=true)
    private List<P2Artifact> features;
    @Parameter(readonly=true)
    private List<EclipseArtifact> p2;
    @Parameter(readonly=true)
    private List<P2FeatureDefinition> featureDefinitions;
    private Log log = this.getLog();
    private File bundlesDestinationFolder;
    private File featuresDestinationFolder;

    public void execute() {
        try {
            this.initializeEnvironment();
            this.initializeRepositorySystem();
            this.processArtifacts(this.artifacts);
            this.processFeatures();
            this.processEclipseArtifacts();
            this.executeP2PublisherPlugin();
            this.executeCategoryPublisher();
            this.cleanupEnvironment();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void initializeEnvironment() throws IOException {
        Logger.initialize(this.log);
        this.bundlesDestinationFolder = new File(this.buildDirectory, BUNDLES_DESTINATION_FOLDER);
        this.featuresDestinationFolder = new File(this.buildDirectory, FEATURES_DESTINATION_FOLDER);
        FileUtils.deleteDirectory((File)new File(this.buildDirectory, BUNDLES_TOP_FOLDER));
        FileUtils.forceMkdir((File)this.bundlesDestinationFolder);
        FileUtils.forceMkdir((File)this.featuresDestinationFolder);
        this.artifacts = this.artifacts != null ? this.artifacts : new ArrayList<P2Artifact>();
        this.features = this.features != null ? this.features : new ArrayList<P2Artifact>();
        this.p2 = this.p2 != null ? this.p2 : new ArrayList<EclipseArtifact>();
    }

    private void initializeRepositorySystem() {
        if (this.repoSystem == null) {
            this.repoSystem = this.lookup("org.eclipse.aether.RepositorySystem");
        }
        if (this.repoSystem == null) {
            this.repoSystem = this.lookup("org.sonatype.aether.RepositorySystem");
        }
        Preconditions.checkNotNull((Object)this.repoSystem, (Object)"Could not initialize RepositorySystem");
    }

    private Object lookup(String role) {
        try {
            return this.container.lookup(role);
        }
        catch (ComponentLookupException componentLookupException) {
            return null;
        }
    }

    private Multimap<P2Artifact, ArtifactBundlerInstructions> processArtifacts(List<P2Artifact> artifacts) {
        BundleUtils.INSTANCE.setReuseSnapshotVersionFromArtifact(this.reuseSnapshotVersionFromArtifact);
        ArrayListMultimap bundlerInstructions = ArrayListMultimap.create();
        Multimap<P2Artifact, ResolvedArtifact> resolvedArtifacts = this.resolveArtifacts(artifacts);
        Set<Artifact> processedArtifacts = this.processRootArtifacts(resolvedArtifacts, (Multimap<P2Artifact, ArtifactBundlerInstructions>)bundlerInstructions, artifacts);
        this.processTransitiveArtifacts(resolvedArtifacts, processedArtifacts, (Multimap<P2Artifact, ArtifactBundlerInstructions>)bundlerInstructions, artifacts);
        return bundlerInstructions;
    }

    private Set<Artifact> processRootArtifacts(Multimap<P2Artifact, ResolvedArtifact> processedArtifacts, Multimap<P2Artifact, ArtifactBundlerInstructions> bundlerInstructions, List<P2Artifact> artifacts) {
        HashSet bundledArtifacts = Sets.newHashSet();
        for (P2Artifact p2Artifact : artifacts) {
            for (ResolvedArtifact resolvedArtifact : processedArtifacts.get((Object)p2Artifact)) {
                if (!resolvedArtifact.isRoot()) continue;
                if (bundledArtifacts.add(resolvedArtifact.getArtifact())) {
                    ArtifactBundlerInstructions abi = this.bundleArtifact(p2Artifact, resolvedArtifact);
                    bundlerInstructions.put((Object)p2Artifact, (Object)abi);
                    continue;
                }
                String message = String.format("p2-maven-plugin misconfiguration\n\n\tJar [%s] is configured as an artifact multiple times. \n\tRemove the duplicate artifact definitions.\n", resolvedArtifact.getArtifact());
                throw new RuntimeException(message);
            }
        }
        return bundledArtifacts;
    }

    private void processTransitiveArtifacts(Multimap<P2Artifact, ResolvedArtifact> resolvedArtifacts, Set<Artifact> bundledArtifacts, Multimap<P2Artifact, ArtifactBundlerInstructions> bundlerInstructions, List<P2Artifact> artifacts) {
        for (P2Artifact p2Artifact : artifacts) {
            for (ResolvedArtifact resolvedArtifact : resolvedArtifacts.get((Object)p2Artifact)) {
                if (resolvedArtifact.isRoot()) continue;
                if (!bundledArtifacts.contains(resolvedArtifact.getArtifact())) {
                    try {
                        bundledArtifacts.add(resolvedArtifact.getArtifact());
                        ArtifactBundlerInstructions abi = this.bundleArtifact(p2Artifact, resolvedArtifact);
                        bundlerInstructions.put((Object)p2Artifact, (Object)abi);
                        continue;
                    }
                    catch (RuntimeException ex) {
                        if (this.skipInvalidArtifacts) {
                            this.log.warn((CharSequence)String.format("Skip artifact=[%s]: %s", p2Artifact.getId(), ex.getMessage()));
                            continue;
                        }
                        throw ex;
                    }
                }
                this.log.debug((CharSequence)String.format("Not bundling transitive dependency since it has already been bundled [%s]", resolvedArtifact.getArtifact()));
            }
        }
    }

    private void processFeatures() {
        Multimap<P2Artifact, ResolvedArtifact> resolvedFeatures = this.resolveFeatures();
        this.log.info((CharSequence)("Resolved " + resolvedFeatures.size() + " features"));
        for (P2Artifact p2Artifact : this.features) {
            for (ResolvedArtifact resolvedArtifact : resolvedFeatures.get((Object)p2Artifact)) {
                this.handleFeature(p2Artifact, resolvedArtifact);
            }
        }
        if (this.featureDefinitions != null) {
            for (P2FeatureDefinition p2Feature : this.featureDefinitions) {
                this.createFeature(p2Feature);
            }
        }
    }

    private Multimap<P2Artifact, ResolvedArtifact> resolveArtifacts(List<P2Artifact> artifacts) {
        ArrayListMultimap resolvedArtifacts = ArrayListMultimap.create();
        for (P2Artifact p2Artifact : artifacts) {
            ArtifactResolutionResult resolutionResult;
            this.logResolving(p2Artifact);
            try {
                resolutionResult = this.resolveArtifact(p2Artifact);
            }
            catch (Exception ex) {
                if (this.skipNotExistingArtifacts) {
                    this.log.warn((CharSequence)String.format("Skip artifact=[%s]: %s", p2Artifact.getId(), ex.getMessage()));
                    continue;
                }
                throw new RuntimeException(ex);
            }
            resolvedArtifacts.putAll((Object)p2Artifact, resolutionResult.getResolvedArtifacts());
        }
        return resolvedArtifacts;
    }

    private Multimap<P2Artifact, ResolvedArtifact> resolveFeatures() {
        ArrayListMultimap resolvedArtifacts = ArrayListMultimap.create();
        for (P2Artifact p2Artifact : this.features) {
            this.logResolving(p2Artifact);
            ArtifactResolutionResult resolutionResult = this.resolveArtifact(p2Artifact);
            resolvedArtifacts.putAll((Object)p2Artifact, resolutionResult.getResolvedArtifacts());
        }
        return resolvedArtifacts;
    }

    private void logResolving(EclipseArtifact p2) {
        this.log.info((CharSequence)String.format("Resolving artifact=[%s] source=[%s]", p2.getId(), p2.shouldIncludeSources()));
    }

    private void logResolving(P2Artifact p2) {
        this.log.info((CharSequence)String.format("Resolving artifact=[%s] transitive=[%s] source=[%s]", p2.getId(), p2.shouldIncludeTransitive(), p2.shouldIncludeSources()));
    }

    private ArtifactResolutionResult resolveArtifact(P2Artifact p2Artifact) {
        ArtifactResolutionRequest resolutionRequest = ArtifactResolutionRequest.builder().rootArtifactId(p2Artifact.getId()).resolveSource(p2Artifact.shouldIncludeSources()).resolveTransitive(p2Artifact.shouldIncludeTransitive()).excludes(p2Artifact.getExcludes()).build();
        ArtifactResolutionResult resolutionResult = this.getArtifactResolver().resolve(resolutionRequest);
        this.logResolved(resolutionRequest, resolutionResult);
        return resolutionResult;
    }

    private ArtifactResolver getArtifactResolver() {
        return new AetherResolver(this.repoSystem, this.repoSession, this.projectRepos);
    }

    private void logResolved(ArtifactResolutionRequest resolutionRequest, ArtifactResolutionResult resolutionResult) {
        for (ResolvedArtifact resolvedArtifact : resolutionResult.getResolvedArtifacts()) {
            this.log.info((CharSequence)("\t [JAR] " + resolvedArtifact.getArtifact()));
            if (resolvedArtifact.getSourceArtifact() != null) {
                this.log.info((CharSequence)("\t [SRC] " + resolvedArtifact.getSourceArtifact().toString()));
                continue;
            }
            if (!resolutionRequest.isResolveSource()) continue;
            this.log.warn((CharSequence)("\t [SRC] Failed to resolve source for artifact " + resolvedArtifact.getArtifact().toString()));
        }
    }

    private void createFeature(P2FeatureDefinition p2featureDefinition) {
        try {
            Multimap<P2Artifact, ArtifactBundlerInstructions> bi = this.processArtifacts(p2featureDefinition.getArtifacts());
            if (null == p2featureDefinition.getFeatureFile()) {
                p2featureDefinition.setVersion(Utils.mavenToEclipse(p2featureDefinition.getVersion(), this.timestamp));
                boolean unpack = p2featureDefinition.getUnpack();
                FeatureBuilder featureBuilder = new FeatureBuilder(p2featureDefinition, bi, false, unpack, this.timestamp);
                featureBuilder.generate(this.featuresDestinationFolder);
                if (p2featureDefinition.getGenerateSourceFeature()) {
                    FeatureBuilder sourceFeatureBuilder = new FeatureBuilder(p2featureDefinition, bi, true, false, this.timestamp);
                    sourceFeatureBuilder.generate(this.featuresDestinationFolder);
                }
            } else {
                File basedir = p2featureDefinition.getFeatureFile().getParentFile();
                TychoFeatureBuilder builder = new TychoFeatureBuilder(p2featureDefinition.getFeatureFile(), this.featuresDestinationFolder.getAbsolutePath(), "test.feature", "1.0.0", this.project, this.session, this.pluginManager);
                builder.execute();
            }
            this.log.info((CharSequence)("Created feature " + p2featureDefinition.getId()));
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
        }
    }

    private ArtifactBundlerInstructions bundleArtifact(P2Artifact p2Artifact, ResolvedArtifact resolvedArtifact) {
        this.log.info((CharSequence)("Bundling Artifact " + p2Artifact.getId()));
        P2Validator.validateBundleRequest(p2Artifact, resolvedArtifact);
        ArtifactBundler bundler = this.getArtifactBundler();
        ArtifactBundlerInstructions bundlerInstructions = P2Helper.createBundlerInstructions(p2Artifact, resolvedArtifact, this.timestamp);
        ArtifactBundlerRequest bundlerRequest = P2Helper.createBundlerRequest(p2Artifact, resolvedArtifact, this.bundlesDestinationFolder);
        bundler.execute(bundlerRequest, bundlerInstructions);
        return bundlerInstructions;
    }

    private void handleFeature(P2Artifact p2Artifact, ResolvedArtifact resolvedArtifact) {
        this.log.debug((CharSequence)("Handling feature " + p2Artifact.getId()));
        ArtifactBundlerRequest bundlerRequest = P2Helper.createBundlerRequest(p2Artifact, resolvedArtifact, this.featuresDestinationFolder);
        try {
            File inputFile = bundlerRequest.getBinaryInputFile();
            File outputFile = bundlerRequest.getBinaryOutputFile();
            JarUtils.adjustFeatureXml(inputFile, outputFile, this.bundlesDestinationFolder, this.log, this.timestamp);
            this.log.info((CharSequence)("Copied " + inputFile + " to " + outputFile));
        }
        catch (Exception ex) {
            throw new RuntimeException("Error while bundling jar or source: " + bundlerRequest.getBinaryInputFile().getName(), ex);
        }
    }

    private void processEclipseArtifacts() {
        DefaultEclipseResolver resolver = new DefaultEclipseResolver(this.projectRepos, this.bundlesDestinationFolder);
        for (EclipseArtifact artifact : this.p2) {
            this.logResolving(artifact);
            String[] tokens = artifact.getId().split(":");
            if (tokens.length != 2) {
                throw new RuntimeException("Wrong format " + artifact.getId());
            }
            EclipseResolutionRequest request = new EclipseResolutionRequest(tokens[0], tokens[1], artifact.shouldIncludeSources());
            resolver.resolve(request);
        }
    }

    private ArtifactBundler getArtifactBundler() {
        return new AquteBundler(this.pedantic);
    }

    private void executeP2PublisherPlugin() throws IOException, MojoExecutionException {
        this.prepareDestinationDirectory();
        BundlePublisher publisher = BundlePublisher.builder().mavenProject(this.project).mavenSession(this.session).buildPluginManager(this.pluginManager).compressSite(this.compressSite).additionalArgs(this.additionalArgs).build();
        publisher.execute();
    }

    private void prepareDestinationDirectory() throws IOException {
        FileUtils.deleteDirectory((File)new File(this.destinationDirectory));
    }

    private void executeCategoryPublisher() throws AbstractMojoExecutionException, IOException {
        this.prepareCategoryLocationFile();
        CategoryPublisher publisher = CategoryPublisher.builder().p2ApplicationLauncher(this.launcher).additionalArgs(this.additionalArgs).forkedProcessTimeoutInSeconds(this.forkedProcessTimeoutInSeconds).categoryFileLocation(this.categoryFileURL).metadataRepositoryLocation(this.destinationDirectory).build();
        publisher.execute();
    }

    private void prepareCategoryLocationFile() throws IOException {
        if (StringUtils.isBlank((String)this.categoryFileURL)) {
            InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/category.xml");
            File destinationFolder = new File(this.destinationDirectory);
            destinationFolder.mkdirs();
            File categoryDefinitionFile = new File(destinationFolder, DEFAULT_CATEGORY_FILE);
            FileWriter writer = new FileWriter(categoryDefinitionFile);
            IOUtils.copy((InputStream)is, (Writer)writer, (String)"UTF-8");
            IOUtils.closeQuietly((Writer)writer);
            this.categoryFileURL = categoryDefinitionFile.getAbsolutePath();
        }
    }

    private void cleanupEnvironment() throws IOException {
        File workFolder = new File(this.buildDirectory, BUNDLES_TOP_FOLDER);
        try {
            FileUtils.deleteDirectory((File)workFolder);
        }
        catch (IOException ex) {
            this.log.warn((CharSequence)("Cannot cleanup the work folder " + workFolder.getAbsolutePath()));
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }
}

